/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.wsl.remoteSdk;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.PathMappingProviderEx;
import com.intellij.remote.ext.PathMappingType;
import com.intellij.util.PathMappingSettings;
import com.intellij.wsl.remoteSdk.WSLBundle;
import com.intellij.wsl.remoteSdk.WSLCredentialsHolder;
import com.intellij.wsl.remoteSdk.WSLCredentialsType;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLPathMappingsProvider
extends PathMappingProviderEx {
    private static final Logger LOG = Logger.getInstance(WSLPathMappingsProvider.class);
    private static final PathMappingType MAPPING_TYPE = new PathMappingType(AllIcons.Ide.Readonly, WSLBundle.messagePointer("tooltip.wsl.mappings", new Object[0]));

    @NotNull
    public String getProviderPresentableName(@NotNull RemoteSdkAdditionalData data) {
        if (data == null) {
            WSLPathMappingsProvider.$$$reportNull$$$0(0);
        }
        return "WSL Path Mappings provider";
    }

    public boolean accepts(@Nullable RemoteSdkAdditionalData data) {
        return data != null && data.getRemoteConnectionType() == WSLCredentialsType.getInstance();
    }

    @NotNull
    public PathMappingType getMappingType() {
        PathMappingType pathMappingType = MAPPING_TYPE;
        if (pathMappingType == null) {
            WSLPathMappingsProvider.$$$reportNull$$$0(1);
        }
        return pathMappingType;
    }

    @NotNull
    public PathMappingSettings getPathMappingSettings(@NotNull Project project, @NotNull RemoteSdkAdditionalData data) {
        WSLDistribution distribution;
        if (project == null) {
            WSLPathMappingsProvider.$$$reportNull$$$0(2);
        }
        if (data == null) {
            WSLPathMappingsProvider.$$$reportNull$$$0(3);
        }
        PathMappingSettings settings = new PathMappingSettings();
        try {
            distribution = WSLCredentialsHolder.get(data).getDistribution();
        }
        catch (ConfigurationException e) {
            PathMappingSettings pathMappingSettings = settings;
            if (pathMappingSettings == null) {
                WSLPathMappingsProvider.$$$reportNull$$$0(4);
            }
            return pathMappingSettings;
        }
        HashSet<String> localPathsToMap = new HashSet<String>();
        VirtualFile projectBaseDir = project.getBaseDir();
        if (projectBaseDir != null) {
            localPathsToMap.add(projectBaseDir.getCanonicalPath());
            VirtualFile projectContainer = projectBaseDir.getParent();
            if (projectContainer != null) {
                localPathsToMap.add(projectContainer.getCanonicalPath());
            }
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                localPathsToMap.add(contentRoot.getCanonicalPath());
                VirtualFile contentRootParent = contentRoot.getParent();
                if (contentRootParent == null) continue;
                localPathsToMap.add(contentRootParent.getCanonicalPath());
            }
        }
        localPathsToMap.forEach(localPath -> {
            try {
                String wslPath = distribution.getWslPath(localPath);
                if (wslPath != null) {
                    settings.addMapping(localPath, wslPath);
                } else {
                    LOG.warn("Unable to map to WSL: " + localPath);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to map windows path " + localPath + " into wsl distribution " + distribution.getMsId() + ". " + e.getMessage());
            }
        });
        PathMappingSettings pathMappingSettings = settings;
        if (pathMappingSettings == null) {
            WSLPathMappingsProvider.$$$reportNull$$$0(5);
        }
        return pathMappingSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/wsl/remoteSdk/WSLPathMappingsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/wsl/remoteSdk/WSLPathMappingsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappingSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProviderPresentableName";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPathMappingSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5 -> new IllegalStateException(string);
        };
    }
}

