/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PuppetQualifiedNamesUtil {
    public static final String SEPARATOR = "::";
    public static final String MAIN_NAMESPACE = "";

    public static String capitalizePuppetName(@NonNls String typeName) {
        char[] chars = typeName.toCharArray();
        int sepcount = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (i == 0 || sepcount == 2) {
                chars[i] = Character.toUpperCase(chars[i]);
                sepcount = 0;
                continue;
            }
            if (chars[i] == ':') {
                ++sepcount;
                continue;
            }
            chars[i] = Character.toLowerCase(chars[i]);
            sepcount = 0;
        }
        return new String(chars);
    }

    @Contract(value="null -> null")
    public static String getCanonicalVariableFullQualifiedName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        if (!StringUtil.startsWith((CharSequence)name, (CharSequence)SEPARATOR)) {
            return name;
        }
        return name.lastIndexOf(SEPARATOR) == 0 ? name : name.substring(2);
    }

    @NotNull
    public static List<TextRange> getQualifiedPartRanges(@NotNull PsiElement element, TextRange nameRange) {
        if (element == null) {
            PuppetQualifiedNamesUtil.$$$reportNull$$$0(0);
        }
        String text = element.getText();
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int last = nameRange.getStartOffset();
        while (last < nameRange.getEndOffset()) {
            int next = text.indexOf(SEPARATOR, last);
            if (next == -1) {
                next = nameRange.getEndOffset();
            }
            if (next > last) {
                result.add(TextRange.create((int)last, (int)next));
            }
            last = next + SEPARATOR.length();
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            PuppetQualifiedNamesUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/util/PuppetQualifiedNamesUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/util/PuppetQualifiedNamesUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedPartRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedPartRanges";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

