/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.ice4j.StunException;
import org.ice4j.StunMessageEvent;
import org.ice4j.message.Message;
import org.ice4j.stack.ErrorHandler;
import org.ice4j.stack.MessageEventHandler;
import org.ice4j.stack.NetAccessManager;
import org.ice4j.stack.RawMessage;
import org.ice4j.stack.StunStack;

class MessageProcessingTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(MessageProcessingTask.class.getName());
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final NetAccessManager netAccessManager;
    private final ErrorHandler errorHandler;
    private final MessageEventHandler messageEventHandler;
    private RawMessage rawMessage;
    private Consumer<MessageProcessingTask> rawMessageProcessedHandler;

    MessageProcessingTask(NetAccessManager netAccessManager) throws IllegalArgumentException {
        if (netAccessManager == null) {
            throw new NullPointerException("netAccessManager");
        }
        MessageEventHandler messageEventHandler = netAccessManager.getMessageEventHandler();
        if (messageEventHandler == null) {
            throw new IllegalArgumentException("The message event handler may not be null");
        }
        this.netAccessManager = netAccessManager;
        this.messageEventHandler = messageEventHandler;
        this.errorHandler = netAccessManager;
    }

    void setMessage(RawMessage message, Consumer<MessageProcessingTask> onProcessed) {
        if (message == null) {
            throw new IllegalArgumentException("The message may not be null");
        }
        this.rawMessage = message;
        this.rawMessageProcessedHandler = onProcessed;
    }

    void resetState() {
        this.cancelled.set(false);
        this.rawMessage = null;
        this.rawMessageProcessedHandler = null;
    }

    public void cancel() {
        this.cancelled.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Consumer<MessageProcessingTask> onProcessed = this.rawMessageProcessedHandler;
        RawMessage message = this.rawMessage;
        try {
            Message stunMessage;
            if (message == null) {
                return;
            }
            this.rawMessage = null;
            this.rawMessageProcessedHandler = null;
            if (this.cancelled.get()) {
                return;
            }
            StunStack stunStack = this.netAccessManager.getStunStack();
            try {
                stunMessage = Message.decode(message.getBytes(), 0, message.getMessageLength());
            }
            catch (StunException ex) {
                this.errorHandler.handleError("Failed to decode a stun message!", ex);
                if (onProcessed != null) {
                    onProcessed.accept(this);
                }
                return;
            }
            logger.finest("Dispatching a StunMessageEvent.");
            StunMessageEvent stunMessageEvent = new StunMessageEvent(stunStack, message, stunMessage);
            this.messageEventHandler.handleMessageEvent(stunMessageEvent);
        }
        catch (Throwable err) {
            this.errorHandler.handleFatalError(Thread.currentThread(), "Unexpected Error!", err);
        }
        finally {
            if (onProcessed != null) {
                onProcessed.accept(this);
            }
        }
    }
}

