/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyStringFormatParser;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyCallExpressionNavigator;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyInjectionUtil {
    public static final List<Class<? extends PsiElement>> ELEMENTS_TO_INJECT_IN = List.of(PyStringLiteralExpression.class, PyParenthesizedExpression.class, PyBinaryExpression.class, PyCallExpression.class, PsiComment.class);

    private PyInjectionUtil() {
    }

    @Nullable
    public static PsiElement getLargestStringLiteral(@NotNull PsiElement context) {
        if (context == null) {
            PyInjectionUtil.$$$reportNull$$$0(0);
        }
        PsiElement element2 = null;
        for (PsiElement current = context; current != null && PyInjectionUtil.isStringLiteralPart(current, element2); current = current.getParent()) {
            element2 = current;
        }
        return element2;
    }

    @NotNull
    public static InjectionResult registerStringLiteralInjection(@NotNull PsiElement element2, @NotNull MultiHostRegistrar registrar, @NotNull Language language) {
        if (element2 == null) {
            PyInjectionUtil.$$$reportNull$$$0(1);
        }
        if (registrar == null) {
            PyInjectionUtil.$$$reportNull$$$0(2);
        }
        if (language == null) {
            PyInjectionUtil.$$$reportNull$$$0(3);
        }
        return PyInjectionUtil.registerStringLiteralInjection(element2, registrar, language, "", "");
    }

    @NotNull
    public static InjectionResult registerStringLiteralInjectionWithParenthesis(@NotNull PsiElement element2, @NotNull MultiHostRegistrar registrar, @NotNull Language language) {
        if (element2 == null) {
            PyInjectionUtil.$$$reportNull$$$0(4);
        }
        if (registrar == null) {
            PyInjectionUtil.$$$reportNull$$$0(5);
        }
        if (language == null) {
            PyInjectionUtil.$$$reportNull$$$0(6);
        }
        return PyInjectionUtil.registerStringLiteralInjection(element2, registrar, language, "(", ")");
    }

    @NotNull
    private static InjectionResult registerStringLiteralInjection(@NotNull PsiElement element2, @NotNull MultiHostRegistrar registrar, @NotNull Language language, @NotNull String prefix, @NotNull String suffix) {
        if (element2 == null) {
            PyInjectionUtil.$$$reportNull$$$0(7);
        }
        if (registrar == null) {
            PyInjectionUtil.$$$reportNull$$$0(8);
        }
        if (language == null) {
            PyInjectionUtil.$$$reportNull$$$0(9);
        }
        if (prefix == null) {
            PyInjectionUtil.$$$reportNull$$$0(10);
        }
        if (suffix == null) {
            PyInjectionUtil.$$$reportNull$$$0(11);
        }
        registrar.startInjecting(language);
        InjectionResult result2 = PyInjectionUtil.processStringLiteral(element2, registrar, prefix, suffix, Formatting.NONE);
        if (result2.isInjected()) {
            registrar.frankensteinInjection(!result2.isStrict()).doneInjecting();
        }
        InjectionResult injectionResult = result2;
        if (injectionResult == null) {
            PyInjectionUtil.$$$reportNull$$$0(12);
        }
        return injectionResult;
    }

    private static boolean isStringLiteralPart(@NotNull PsiElement element2, @Nullable PsiElement context) {
        if (element2 == null) {
            PyInjectionUtil.$$$reportNull$$$0(13);
        }
        if (element2 == context || element2 instanceof PyStringLiteralExpression || element2 instanceof PsiComment) {
            return true;
        }
        if (element2 instanceof PyParenthesizedExpression) {
            PyExpression contained = ((PyParenthesizedExpression)element2).getContainedExpression();
            return contained != null && PyInjectionUtil.isStringLiteralPart((PsiElement)contained, context);
        }
        if (element2 instanceof PyBinaryExpression) {
            PyBinaryExpression expr = (PyBinaryExpression)element2;
            PyExpression left = expr.getLeftExpression();
            PyExpression right = expr.getRightExpression();
            if (expr.isOperator("+")) {
                return PyInjectionUtil.isStringLiteralPart((PsiElement)left, context) || right != null && PyInjectionUtil.isStringLiteralPart((PsiElement)right, context);
            }
            if (expr.isOperator("%")) {
                return right != context && PyInjectionUtil.isStringLiteralPart((PsiElement)left, context);
            }
            return false;
        }
        if (element2 instanceof PyCallExpression) {
            PyExpression qualifier = PyInjectionUtil.getFormatCallQualifier((PyCallExpression)element2);
            return qualifier != null && PyInjectionUtil.isStringLiteralPart((PsiElement)qualifier, context);
        }
        if (element2 instanceof PyReferenceExpression) {
            PyCallExpression callExpr = PyCallExpressionNavigator.getPyCallExpressionByCallee((PsiElement)element2);
            return callExpr != null && PyInjectionUtil.isStringLiteralPart((PsiElement)callExpr, context);
        }
        return false;
    }

    @Nullable
    private static PyExpression getFormatCallQualifier(@NotNull PyCallExpression element2) {
        PyQualifiedExpression qualifiedExpr;
        PyExpression qualifier;
        PyExpression callee;
        if (element2 == null) {
            PyInjectionUtil.$$$reportNull$$$0(14);
        }
        if ((callee = element2.getCallee()) instanceof PyQualifiedExpression && (qualifier = (qualifiedExpr = (PyQualifiedExpression)callee).getQualifier()) != null && "format".equals(qualifiedExpr.getReferencedName())) {
            return qualifier;
        }
        return null;
    }

    @NotNull
    private static InjectionResult processStringLiteral(@NotNull PsiElement element2, @NotNull MultiHostRegistrar registrar, @NotNull String prefix, @NotNull String suffix, @NotNull Formatting formatting) {
        PyExpression qualifier;
        if (element2 == null) {
            PyInjectionUtil.$$$reportNull$$$0(15);
        }
        if (registrar == null) {
            PyInjectionUtil.$$$reportNull$$$0(16);
        }
        if (prefix == null) {
            PyInjectionUtil.$$$reportNull$$$0(17);
        }
        if (suffix == null) {
            PyInjectionUtil.$$$reportNull$$$0(18);
        }
        if (formatting == null) {
            PyInjectionUtil.$$$reportNull$$$0(19);
        }
        String missingValue = "missing_value";
        if (element2 instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression expr = (PyStringLiteralExpression)element2;
            boolean injected = false;
            boolean strict = true;
            for (PyStringElement stringElem : expr.getStringElements()) {
                int nodeOffsetInParent = stringElem.getTextOffset() - expr.getTextRange().getStartOffset();
                TextRange contentRange = stringElem.getContentRange();
                int contentStartOffset = contentRange.getStartOffset();
                if (formatting != Formatting.NONE || stringElem.isFormatted() || stringElem.isTemplate()) {
                    List subsRanges;
                    if (formatting != Formatting.NONE) {
                        String content = stringElem.getContent();
                        subsRanges = StreamEx.of((Collection)(formatting == Formatting.NEW_STYLE ? PyStringFormatParser.parseNewStyleFormat((String)content) : PyStringFormatParser.parsePercentFormat((String)content))).select(PyStringFormatParser.SubstitutionChunk.class).map(chunk -> chunk.getTextRange().shiftRight(contentStartOffset)).toList();
                    } else {
                        subsRanges = ContainerUtil.map((Collection)((PyFormattedStringElement)stringElem).getFragments(), PsiElement::getTextRangeInParent);
                    }
                    if (!subsRanges.isEmpty()) {
                        strict = false;
                    }
                    TextRange sentinel = TextRange.from((int)contentRange.getEndOffset(), (int)0);
                    List withSentinel = ContainerUtil.append((List)subsRanges, (Object[])new TextRange[]{sentinel});
                    int literalChunkStart = contentStartOffset;
                    for (int i = 0; i < withSentinel.size(); ++i) {
                        TextRange subRange = (TextRange)withSentinel.get(i);
                        int literalChunkEnd = subRange.getStartOffset();
                        if (literalChunkEnd > literalChunkStart) {
                            String chunkPrefix = i == 0 ? prefix : (i == 1 && ((TextRange)withSentinel.get(0)).getStartOffset() == contentStartOffset ? "missing_value" : "");
                            String chunkSuffix = i < withSentinel.size() - 1 ? "missing_value" : (i == withSentinel.size() - 1 ? suffix : "");
                            TextRange chunkRange = TextRange.create((int)literalChunkStart, (int)literalChunkEnd);
                            registrar.addPlace(chunkPrefix, chunkSuffix, (PsiLanguageInjectionHost)expr, chunkRange.shiftRight(nodeOffsetInParent));
                            injected = true;
                        }
                        literalChunkStart = subRange.getEndOffset();
                    }
                    continue;
                }
                registrar.addPlace(prefix, suffix, (PsiLanguageInjectionHost)expr, contentRange.shiftRight(nodeOffsetInParent));
                injected = true;
            }
            return new InjectionResult(injected, strict);
        }
        if (element2 instanceof PyParenthesizedExpression) {
            PyExpression contained = ((PyParenthesizedExpression)element2).getContainedExpression();
            if (contained != null) {
                return PyInjectionUtil.processStringLiteral((PsiElement)contained, registrar, prefix, suffix, formatting);
            }
        } else if (element2 instanceof PyBinaryExpression) {
            PyBinaryExpression expr = (PyBinaryExpression)element2;
            PyExpression left = expr.getLeftExpression();
            PyExpression right = expr.getRightExpression();
            boolean isLeftString = PyInjectionUtil.isStringLiteralPart((PsiElement)left, null);
            if (expr.isOperator("+")) {
                boolean isRightString = right != null && PyInjectionUtil.isStringLiteralPart((PsiElement)right, null);
                InjectionResult result2 = InjectionResult.EMPTY;
                if (isLeftString) {
                    result2 = result2.append(PyInjectionUtil.processStringLiteral((PsiElement)left, registrar, prefix, isRightString ? "" : "missing_value", formatting));
                }
                if (isRightString) {
                    result2 = result2.append(PyInjectionUtil.processStringLiteral((PsiElement)right, registrar, isLeftString ? "" : "missing_value", suffix, formatting));
                }
                InjectionResult injectionResult = result2;
                if (injectionResult == null) {
                    PyInjectionUtil.$$$reportNull$$$0(20);
                }
                return injectionResult;
            }
            if (expr.isOperator("%")) {
                return PyInjectionUtil.processStringLiteral((PsiElement)left, registrar, prefix, suffix, Formatting.PERCENT);
            }
        } else if (element2 instanceof PyCallExpression && (qualifier = PyInjectionUtil.getFormatCallQualifier((PyCallExpression)element2)) != null) {
            return PyInjectionUtil.processStringLiteral((PsiElement)qualifier, registrar, prefix, suffix, Formatting.NEW_STYLE);
        }
        InjectionResult injectionResult = InjectionResult.EMPTY;
        if (injectionResult == null) {
            PyInjectionUtil.$$$reportNull$$$0(21);
        }
        return injectionResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 12: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/PyInjectionUtil";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/PyInjectionUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "registerStringLiteralInjection";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "processStringLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLargestStringLiteral";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerStringLiteralInjection";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerStringLiteralInjectionWithParenthesis";
                break;
            }
            case 12: 
            case 20: 
            case 21: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteralPart";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFormatCallQualifier";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processStringLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 20, 21 -> new IllegalStateException(string);
        };
    }

    public static class InjectionResult {
        public static final InjectionResult EMPTY = new InjectionResult(false, true);
        private final boolean myInjected;
        private final boolean myStrict;

        public InjectionResult(boolean injected, boolean strict) {
            this.myInjected = injected;
            this.myStrict = strict;
        }

        public boolean isInjected() {
            return this.myInjected;
        }

        public boolean isStrict() {
            return this.myStrict;
        }

        public InjectionResult append(@NotNull InjectionResult result2) {
            if (result2 == null) {
                InjectionResult.$$$reportNull$$$0(0);
            }
            return new InjectionResult(this.myInjected || result2.isInjected(), this.myStrict && result2.isStrict());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/PyInjectionUtil$InjectionResult", "append"));
        }
    }

    private static enum Formatting {
        NONE,
        PERCENT,
        NEW_STYLE;

    }
}

