/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.hierarchy;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.Navigatable;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    private final List<SmartPsiElementPointer<PsiElement>> myUsages;

    public PyHierarchyNodeDescriptor(NodeDescriptor parentDescriptor, @NotNull PsiElement element2, boolean isBase) {
        if (element2 == null) {
            PyHierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        this(parentDescriptor, element2, Collections.emptySet(), isBase);
    }

    public PyHierarchyNodeDescriptor(NodeDescriptor parentDescriptor, @NotNull PsiElement element2, @NotNull Collection<? extends PsiElement> usages, boolean isBase) {
        if (element2 == null) {
            PyHierarchyNodeDescriptor.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            PyHierarchyNodeDescriptor.$$$reportNull$$$0(2);
        }
        super(element2.getProject(), parentDescriptor, element2, isBase);
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        this.myUsages = ContainerUtil.map(usages, arg_0 -> ((SmartPointerManager)pointerManager).createSmartPsiElementPointer(arg_0));
    }

    public boolean update() {
        boolean changes = super.update();
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        NavigatablePsiElement element2 = (NavigatablePsiElement)this.getPsiElement();
        if (element2 == null) {
            return this.invalidElement();
        }
        ItemPresentation presentation = element2.getPresentation();
        if (presentation != null) {
            String locationString;
            PyClass cls;
            if (element2 instanceof PyFunction && (cls = ((PyFunction)element2).getContainingClass()) != null) {
                this.myHighlightedText.getEnding().addText(cls.getName() + ".");
            }
            this.myHighlightedText.getEnding().addText(presentation.getPresentableText());
            int count = this.myUsages.size();
            if (count > 1) {
                String text = " " + IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{count});
                this.myHighlightedText.getEnding().addText(text, HierarchyNodeDescriptor.getUsageCountPrefixAttributes());
            }
            if ((locationString = presentation.getLocationString()) != null) {
                this.myHighlightedText.getEnding().addText(" " + locationString, HierarchyNodeDescriptor.getPackageNameAttributes());
            }
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    public void navigate(boolean requestFocus) {
        Navigatable element2 = this.getNavigationTarget();
        if (element2 != null && element2.canNavigate()) {
            element2.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        Navigatable element2 = this.getNavigationTarget();
        return element2 != null && element2.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Nullable
    private Navigatable getNavigationTarget() {
        Navigatable firstUsage;
        if (!this.myUsages.isEmpty() && (firstUsage = (Navigatable)PyUtil.as((Object)this.myUsages.get(0).getElement(), Navigatable.class)) != null) {
            return firstUsage;
        }
        return (Navigatable)PyUtil.as((Object)this.getPsiElement(), Navigatable.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "usages";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/hierarchy/PyHierarchyNodeDescriptor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

