/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.interpreter;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyPsiBundle;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/inspections/interpreter/InterpreterSettingsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myModule", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getFamilyName", "", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Companion", "intellij.python.community.impl"})
public final class InterpreterSettingsQuickFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Module myModule;

    public InterpreterSettingsQuickFix(@Nullable Module myModule) {
        this.myModule = myModule;
    }

    @NotNull
    public String getFamilyName() {
        String string;
        if (PlatformUtils.isPyCharm()) {
            String string2 = PyPsiBundle.message((String)"INSP.interpreter.interpreter.settings", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = PyPsiBundle.message((String)"INSP.interpreter.configure.python.interpreter", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Companion.showPythonInterpreterSettings(project, this.myModule);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/interpreter/InterpreterSettingsQuickFix$Companion;", "", "<init>", "()V", "showPythonInterpreterSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "justOneModuleInheritingSdk", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void showPythonInterpreterSettings(@NotNull Project project, @Nullable Module module2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String id = "com.jetbrains.python.configuration.PyActiveSdkModuleConfigurable";
            ConfigurableGroup configurableGroup = ConfigurableExtensionPointUtil.getConfigurableGroup((Project)project, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)configurableGroup, (String)"getConfigurableGroup(...)");
            ConfigurableGroup group2 = configurableGroup;
            if (ConfigurableVisitor.findById((String)id, (List)CollectionsKt.listOf((Object)group2)) != null) {
                ShowSettingsUtilImpl.Companion.showSettingsDialog(project, id, null);
                return;
            }
            ProjectSettingsService settingsService = ProjectSettingsService.getInstance((Project)project);
            if (module2 == null || this.justOneModuleInheritingSdk(project, module2)) {
                settingsService.openProjectSettings();
            } else {
                settingsService.openModuleSettings(module2);
            }
        }

        private final boolean justOneModuleInheritingSdk(Project project, Module module2) {
            return ProjectRootManager.getInstance((Project)project).getProjectSdk() == null && ModuleRootManager.getInstance((Module)module2).isSdkInherited() && ModuleManager.Companion.getInstance(project).getModules().length < 2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

