/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.module.PySourceRootDetectionService;
import java.io.File;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\r\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016J\r\u0010\u000e\u001a\u00070\f\u00a2\u0006\u0002\b\u000fH\u0016J\r\u0010\u0010\u001a\u00070\f\u00a2\u0006\u0002\b\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/python/inspections/quickfix/PyMarkDirectoryAsSourceRootQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/util/Iconable;", "project", "Lcom/intellij/openapi/project/Project;", "sourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "startInWriteAction", "", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getName", "Lcom/intellij/codeInspection/util/IntentionName;", "getPathName", "Lcom/intellij/openapi/util/NlsSafe;", "getIcon", "Ljavax/swing/Icon;", "flags", "", "applyFix", "", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.python.community.impl"})
public final class PyMarkDirectoryAsSourceRootQuickFix
implements LocalQuickFix,
Iconable {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile sourceRoot;

    public PyMarkDirectoryAsSourceRootQuickFix(@NotNull Project project, @NotNull VirtualFile sourceRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceRoot, (String)"sourceRoot");
        this.project = project;
        this.sourceRoot = sourceRoot;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message((String)"QFIX.add.source.root.for.unresolved.import.family.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.getPathName()};
        String string = PyPsiBundle.message((String)"QFIX.add.source.root.for.unresolved.import.name", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final String getPathName() {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        if (virtualFile == null) {
            String string = this.sourceRoot.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }
        VirtualFile projectDir = virtualFile;
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)this.sourceRoot, (VirtualFile)projectDir, (char)File.separatorChar);
        String string = relativePath;
        if (string == null || (string = StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null)) == null) {
            String string2 = this.sourceRoot.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = AllIcons.Modules.SourceRoot;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SourceRoot");
        return icon;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ((PySourceRootDetectionService)((Object)project.getService(PySourceRootDetectionService.class))).markAsSourceRoot(this.sourceRoot, true);
    }
}

