/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.setupPy;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateAction;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerExt;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u001a\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/python/packaging/setupPy/CreateSetupPyAction;", "Lcom/intellij/ide/fileTemplates/actions/CreateFromTemplateAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getAttributesDefaults", "Lcom/intellij/ide/fileTemplates/actions/AttributesDefaults;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getTargetDirectory", "Lcom/intellij/psi/PsiDirectory;", "view", "Lcom/intellij/ide/IdeView;", "elementCreated", "dialog", "Lcom/intellij/ide/fileTemplates/ui/CreateFromTemplateDialog;", "createdElement", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.python.community.impl"})
public final class CreateSetupPyAction
extends CreateFromTemplateAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String AUTHOR_PROPERTY = "python.packaging.author";
    @NotNull
    private static final String EMAIL_PROPERTY = "python.packaging.author.email";
    @NotNull
    public static final String SETUP_SCRIPT_TEMPLATE_NAME = "Setup Script";

    public CreateSetupPyAction() {
        super(SETUP_SCRIPT_TEMPLATE_NAME, PythonFileType.INSTANCE.getIcon(), CreateSetupPyAction::_init_$lambda$0);
        this.getTemplatePresentation().setText(PyBundle.message("python.packaging.create.setup.py", new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Module module2 = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        e.getPresentation().setEnabled(module2 != null && !PyPackageUtil.hasSetupPy(module2));
    }

    @NotNull
    public AttributesDefaults getAttributesDefaults(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        AttributesDefaults defaults = new AttributesDefaults("setup.py").withFixedName(true);
        if (project != null) {
            defaults.addPredefined("Import", CreateSetupPyAction.Companion.getSetupImport(dataContext));
            defaults.add("Package_name", project.getName());
            PropertiesComponent properties = PropertiesComponent.getInstance();
            defaults.add("Author", properties.getValue(AUTHOR_PROPERTY, SystemProperties.getUserName()));
            defaults.add("Author_email", properties.getValue(EMAIL_PROPERTY, ""));
            defaults.addPredefined("PackageList", CreateSetupPyAction.Companion.getPackageList(dataContext));
            defaults.addPredefined("PackageDirs", CreateSetupPyAction.Companion.getPackageDirs(dataContext));
        }
        defaults.setAttributeVisibleNames(CreateSetupPyAction.Companion.getVisibleNames());
        Intrinsics.checkNotNull((Object)defaults);
        return defaults;
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(@NotNull DataContext dataContext, @Nullable IdeView view) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        if (module2 != null) {
            Collection collection = PyUtil.getSourceRoots((Module)module2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSourceRoots(...)");
            Collection sourceRoots = collection;
            if (!sourceRoots.isEmpty()) {
                PsiManager psiManager = PsiManager.getInstance((Project)module2.getProject());
                Object e = sourceRoots.iterator().next();
                Intrinsics.checkNotNull(e);
                return psiManager.findDirectory((VirtualFile)e);
            }
        }
        return super.getTargetDirectory(dataContext, view);
    }

    protected void elementCreated(@NotNull CreateFromTemplateDialog dialog, @Nullable PsiElement createdElement) {
        String authorEmail;
        Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        Properties properties = dialog.getEnteredProperties();
        String author = properties.getProperty("Author");
        if (author != null) {
            propertiesComponent.setValue(AUTHOR_PROPERTY, author);
        }
        if ((authorEmail = properties.getProperty("Author_email")) != null) {
            propertiesComponent.setValue(EMAIL_PROPERTY, authorEmail);
        }
    }

    private static final FileTemplate _init_$lambda$0() {
        return FileTemplateManager.getDefaultInstance().getInternalTemplate(SETUP_SCRIPT_TEMPLATE_NAME);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/packaging/setupPy/CreateSetupPyAction$Companion;", "", "<init>", "()V", "AUTHOR_PROPERTY", "", "EMAIL_PROPERTY", "SETUP_SCRIPT_TEMPLATE_NAME", "visibleNames", "", "getVisibleNames", "()Ljava/util/Map;", "getSetupImport", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "hasSetuptoolsPackage", "", "module", "Lcom/intellij/openapi/module/Module;", "getPackageList", "getPackageDirs", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, String> getVisibleNames() {
            HashMap<String, String> attributeToName = new HashMap<String, String>();
            attributeToName.put("Package_name", PyBundle.message("python.packaging.create.setup.package.name", new Object[0]));
            attributeToName.put("Version", PyBundle.message("python.packaging.create.setup.version", new Object[0]));
            attributeToName.put("URL", PyBundle.message("python.packaging.create.setup.url", new Object[0]));
            attributeToName.put("License", PyBundle.message("python.packaging.create.setup.license", new Object[0]));
            attributeToName.put("Author", PyBundle.message("python.packaging.create.setup.author", new Object[0]));
            attributeToName.put("Author_Email", PyBundle.message("python.packaging.create.setup.author.email", new Object[0]));
            attributeToName.put("Description", PyBundle.message("python.packaging.create.setup.description", new Object[0]));
            return attributeToName;
        }

        private final String getSetupImport(DataContext dataContext) {
            Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
            return this.hasSetuptoolsPackage(module2) ? "from setuptools import setup" : "from distutils.core import setup";
        }

        private final boolean hasSetuptoolsPackage(Module module2) {
            Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)module2);
            if (sdk2 == null) {
                return false;
            }
            Module module3 = module2;
            if (module3 == null || (module3 = module3.getProject()) == null) {
                return false;
            }
            Module project = module3;
            PythonPackageManager packageManager2 = PythonPackageManager.Companion.forSdk((Project)project, sdk2);
            return PythonPackageManagerExt.hasInstalledPackageSnapshot$default(packageManager2, "setuptools", null, 2, null);
        }

        private final String getPackageList(DataContext dataContext) {
            Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
            if (module2 != null) {
                return "['" + StringUtil.join((Collection)PyPackageUtil.getPackageNames(module2), (String)"', '") + "']";
            }
            return "[]";
        }

        private final String getPackageDirs(DataContext dataContext) {
            Module module2 = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
            if (module2 != null) {
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getSourceRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
                for (VirtualFile virtualFile : virtualFileArray) {
                    Intrinsics.checkNotNull((Object)virtualFile);
                    VirtualFile sourceRoot = virtualFile;
                    VirtualFile contentRoot = ProjectFileIndex.getInstance((Project)module2.getProject()).getContentRootForFile(sourceRoot);
                    if (contentRoot == null || Comparing.equal((Object)contentRoot, (Object)sourceRoot)) continue;
                    String string = VfsUtilCore.getRelativePath((VirtualFile)sourceRoot, (VirtualFile)contentRoot, (char)'/');
                    Intrinsics.checkNotNull((Object)string);
                    String relativePath = string;
                    return "\n    package_dir={'': '" + relativePath + "'},";
                }
            }
            return "";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

