/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.actions.CreatePackageAction;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.PyImportOptimizer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PyMoveFileHandler
extends MoveFileHandler {
    private static final Key<String> ORIGINAL_FILE_LOCATION = Key.create((String)"PY_ORIGINAL_FILE_LOCATION");

    public boolean canProcessElement(PsiFile element2) {
        return element2.getFileType() == PythonFileType.INSTANCE;
    }

    public void prepareMovedFile(PsiFile file, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
        if (file != null) {
            PsiDirectory root;
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                PyUtil.deletePycFiles((String)virtualFile.getPath());
            }
            Collection roots = PyUtil.getSourceRoots((PsiElement)file);
            for (root = moveDestination; root != null && !roots.contains(root.getVirtualFile()); root = root.getParentDirectory()) {
            }
            boolean searchForReferences = RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE;
            if (moveDestination != root && root != null && searchForReferences && !PyMoveFileHandler.probablyNamespacePackage(file, moveDestination, root)) {
                CreatePackageAction.createInitPyInHierarchy(moveDestination, root);
            }
        }
    }

    public void updateMovedFile(PsiFile file) throws IncorrectOperationException {
        if (file instanceof PyFile) {
            PyMoveFileHandler.updateRelativeImportsInModule((PyFile)file);
        }
    }

    private static void updateRelativeImportsInModule(@NotNull PyFile module2) {
        QualifiedName newName;
        String originalLocation;
        if (module2 == null) {
            PyMoveFileHandler.$$$reportNull$$$0(0);
        }
        if ((originalLocation = PyMoveFileHandler.getOriginalLocation((PsiFile)module2)) == null) {
            return;
        }
        for (PyFromImportStatement statement : module2.getFromImports()) {
            if (!PyMoveFileHandler.canBeRelative(statement)) continue;
            int relativeLevel = Math.max(statement.getRelativeLevel(), 1);
            PsiFileSystemItem sourceElement = PyMoveFileHandler.resolveRelativeImportFromModuleLocation(module2, originalLocation, statement.getImportSource(), relativeLevel);
            if (sourceElement == null) continue;
            newName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)sourceElement);
            PyMoveFileHandler.replaceRelativeImportSourceWithQualifiedExpression(statement, newName);
        }
        for (PyImportElement importElement : module2.getImportTargets()) {
            ScopeOwner scopeOwner;
            PsiFileSystemItem resolved;
            PyReferenceExpression referenceExpr = importElement.getImportReferenceExpression();
            if (!PyMoveFileHandler.canBeRelative(importElement) || referenceExpr == null || (resolved = PyMoveFileHandler.resolveRelativeImportFromModuleLocation(module2, originalLocation, referenceExpr, 1)) == null) continue;
            newName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)resolved);
            PyMoveFileHandler.replaceWithQualifiedExpression((PsiElement)referenceExpr, newName);
            final QualifiedName oldQualifiedName = referenceExpr.asQualifiedName();
            if (Comparing.equal((Object)oldQualifiedName, (Object)newName) || (scopeOwner = ScopeUtil.getScopeOwner((PsiElement)importElement)) == null) continue;
            scopeOwner.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

                public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (Comparing.equal((Object)node.asQualifiedName(), (Object)oldQualifiedName)) {
                        PyMoveFileHandler.replaceWithQualifiedExpression((PsiElement)node, newName);
                    } else {
                        super.visitPyReferenceExpression(node);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/refactoring/move/PyMoveFileHandler$1", "visitPyReferenceExpression"));
                }
            });
        }
    }

    private static boolean canBeRelative(@NotNull PyFromImportStatement statement) {
        if (statement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(1);
        }
        return LanguageLevel.forElement((PsiElement)statement).isPython2() || statement.getRelativeLevel() > 0;
    }

    private static boolean canBeRelative(@NotNull PyImportElement statement) {
        if (statement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(2);
        }
        return LanguageLevel.forElement((PsiElement)statement).isPython2();
    }

    @Nullable
    private static PsiFileSystemItem resolveRelativeImportFromModuleLocation(@NotNull PyFile context, @NotNull String moduleLocation, @Nullable PyReferenceExpression referenceExpr, int relativeLevel) {
        if (context == null) {
            PyMoveFileHandler.$$$reportNull$$$0(3);
        }
        if (moduleLocation == null) {
            PyMoveFileHandler.$$$reportNull$$$0(4);
        }
        String relativeImportBasePath = VirtualFileManager.extractPath((String)moduleLocation);
        for (int level = 0; level < relativeLevel; ++level) {
            relativeImportBasePath = PathUtil.getParentPath((String)relativeImportBasePath);
        }
        if (!relativeImportBasePath.isEmpty()) {
            VirtualFile relativeImportBaseDir;
            String protocol = VirtualFileManager.extractProtocol((String)moduleLocation);
            assert (protocol != null) : "Original location: " + moduleLocation;
            String relativeImportBaseUrl = VirtualFileManager.constructUrl((String)protocol, (String)relativeImportBasePath);
            VirtualFile sourceFile = relativeImportBaseDir = VirtualFileManager.getInstance().findFileByUrl(relativeImportBaseUrl);
            if (relativeImportBaseDir != null && relativeImportBaseDir.isDirectory() && referenceExpr != null) {
                QualifiedName qualifiedName = referenceExpr.asQualifiedName();
                if (qualifiedName == null) {
                    return null;
                }
                String relativePath = qualifiedName.join("/");
                sourceFile = relativeImportBaseDir.findFileByRelativePath(relativePath);
                if (sourceFile == null) {
                    sourceFile = relativeImportBaseDir.findFileByRelativePath(relativePath + ".py");
                }
            }
            if (sourceFile != null) {
                Object sourceElement = sourceFile.isDirectory() ? context.getManager().findDirectory(sourceFile) : context.getManager().findFile(sourceFile);
                return sourceElement;
            }
        }
        return null;
    }

    private static boolean probablyNamespacePackage(@NotNull PsiFile anchor, @NotNull PsiDirectory destination, @NotNull PsiDirectory root) {
        if (anchor == null) {
            PyMoveFileHandler.$$$reportNull$$$0(5);
        }
        if (destination == null) {
            PyMoveFileHandler.$$$reportNull$$$0(6);
        }
        if (root == null) {
            PyMoveFileHandler.$$$reportNull$$$0(7);
        }
        if (LanguageLevel.forElement((PsiElement)anchor).isPython2()) {
            return false;
        }
        while (destination != null && destination != root) {
            if (destination.findFile("__init__.py") != null) {
                return false;
            }
            destination = destination.getParent();
        }
        return true;
    }

    public @Unmodifiable @NotNull List<UsageInfo> findUsages(@NotNull PsiFile file, @NotNull PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        if (file == null) {
            PyMoveFileHandler.$$$reportNull$$$0(8);
        }
        if (newParent == null) {
            PyMoveFileHandler.$$$reportNull$$$0(9);
        }
        file.putUserData(ORIGINAL_FILE_LOCATION, (Object)file.getVirtualFile().getUrl());
        List usages = PyPsiIndexUtil.findUsages((PsiNamedElement)file, (boolean)false);
        List list = ContainerUtil.map((Collection)usages, usage -> {
            PsiElement element2 = usage.getElement();
            if (element2 != null) {
                return new PyUsageInfo(element2, file);
            }
            return usage;
        });
        if (list == null) {
            PyMoveFileHandler.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void retargetUsages(@Unmodifiable @NotNull List<? extends UsageInfo> usages, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        if (usages == null) {
            PyMoveFileHandler.$$$reportNull$$$0(11);
        }
        if (oldToNewMap == null) {
            PyMoveFileHandler.$$$reportNull$$$0(12);
        }
        HashSet<PsiFile> updatedFiles = new HashSet<PsiFile>();
        for (UsageInfo usageInfo : usages) {
            PsiElement usageElement = usageInfo.getElement();
            if (usageElement == null || !(usageInfo instanceof PyUsageInfo)) continue;
            PsiFile movedElement = ((PyUsageInfo)usageInfo).myFile;
            PsiFile usageFile = usageElement.getContainingFile();
            PyImportStatementBase importStmt = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)usageElement, PyImportStatementBase.class);
            if (importStmt != null) {
                boolean usageInsideImportElement;
                TypeEvalContext typeEvalContext;
                PyResolveContext resolveContext;
                if (PyMoveFileHandler.getOriginalLocation(usageFile) != null && ContainerUtil.getFirstItem((List)PyUtil.multiResolveTopPriority((PsiElement)usageElement, (PyResolveContext)(resolveContext = PyResolveContext.implicitContext((TypeEvalContext)(typeEvalContext = TypeEvalContext.userInitiated((Project)usageFile.getProject(), (PsiFile)usageFile)))))) == movedElement) continue;
                updatedFiles.add(usageFile);
                boolean bl = usageInsideImportElement = PsiTreeUtil.getParentOfType((PsiElement)usageElement, PyImportElement.class) != null;
                if (usageInsideImportElement && PyClassRefactoringUtil.updateUnqualifiedImportOfElement((PyImportStatementBase)importStmt, (PsiNamedElement)movedElement)) continue;
                QualifiedName newElementName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)movedElement, (PsiElement)usageElement);
                if (importStmt instanceof PyFromImportStatement) {
                    if (usageInsideImportElement) continue;
                    PyMoveFileHandler.replaceRelativeImportSourceWithQualifiedExpression((PyFromImportStatement)importStmt, newElementName);
                    continue;
                }
                PyMoveFileHandler.replaceWithQualifiedExpression(usageElement, newElementName);
                continue;
            }
            if (!(usageElement instanceof PyReferenceExpression)) continue;
            updatedFiles.add(usageFile);
            if (((PyReferenceExpression)usageElement).isQualified()) {
                QualifiedName newQualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)movedElement, (PsiElement)usageElement);
                PyMoveFileHandler.replaceWithQualifiedExpression(usageElement, newQualifiedName);
                continue;
            }
            QualifiedName newName = QualifiedName.fromComponents((String[])new String[]{PyPsiRefactoringUtil.getOriginalName((PsiNamedElement)movedElement)});
            PyMoveFileHandler.replaceWithQualifiedExpression(usageElement, newName);
        }
        if (!updatedFiles.isEmpty()) {
            PyImportOptimizer optimizer = PyImportOptimizer.onlyRemoveUnused();
            for (PsiFile file : updatedFiles) {
                boolean injectedFragment = InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file);
                if (injectedFragment) continue;
                optimizer.processFile(file).run();
            }
        }
    }

    @Nullable
    private static String getOriginalLocation(PsiFile file) {
        return file == null ? null : (String)file.getUserData(ORIGINAL_FILE_LOCATION);
    }

    @NotNull
    private static PsiElement replaceWithQualifiedExpression(@NotNull PsiElement oldElement, @Nullable QualifiedName newElementName) {
        if (oldElement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(13);
        }
        if (newElementName != null && PyPsiRefactoringUtil.isValidQualifiedName((QualifiedName)newElementName)) {
            PyElementGenerator generator = PyElementGenerator.getInstance((Project)oldElement.getProject());
            PyExpression newElement = generator.createExpressionFromText(LanguageLevel.forElement((PsiElement)oldElement), newElementName.toString());
            PsiElement psiElement = oldElement.replace((PsiElement)newElement);
            if (psiElement == null) {
                PyMoveFileHandler.$$$reportNull$$$0(14);
            }
            return psiElement;
        }
        PsiElement psiElement = oldElement;
        if (psiElement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement replaceRelativeImportSourceWithQualifiedExpression(@NotNull PyFromImportStatement importStatement, @Nullable QualifiedName qualifiedName) {
        Couple<PsiElement> range;
        if (importStatement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(16);
        }
        if ((range = PyMoveFileHandler.getRelativeImportSourceRange(importStatement)) != null && qualifiedName != null) {
            if (range.getFirst() != range.getSecond()) {
                importStatement.deleteChildRange(((PsiElement)range.getFirst()).getNextSibling(), (PsiElement)range.getSecond());
            }
            PyMoveFileHandler.replaceWithQualifiedExpression((PsiElement)range.getFirst(), qualifiedName);
        }
        PyFromImportStatement pyFromImportStatement = importStatement;
        if (pyFromImportStatement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(17);
        }
        return pyFromImportStatement;
    }

    @Nullable
    private static Couple<PsiElement> getRelativeImportSourceRange(@NotNull PyFromImportStatement statement) {
        if (statement == null) {
            PyMoveFileHandler.$$$reportNull$$$0(18);
        }
        PsiElement fromKeyword = statement.getFirstChild();
        assert (fromKeyword.getNode().getElementType() == PyTokenTypes.FROM_KEYWORD);
        PsiElement elementAfterFrom = PsiTreeUtil.skipWhitespacesForward((PsiElement)fromKeyword);
        if (elementAfterFrom == null) {
            return null;
        }
        if (elementAfterFrom instanceof PyReferenceExpression) {
            return Couple.of((Object)elementAfterFrom, (Object)elementAfterFrom);
        }
        if (elementAfterFrom.getNode().getElementType() == PyTokenTypes.DOT) {
            PsiElement lastDot;
            PsiElement next = elementAfterFrom;
            do {
                lastDot = next;
            } while ((next = PsiTreeUtil.skipWhitespacesForward((PsiElement)next)) != null && next.getNode().getElementType() == PyTokenTypes.DOT);
            if (next instanceof PyReferenceExpression) {
                return Couple.of((Object)elementAfterFrom, (Object)next);
            }
            return Couple.of((Object)elementAfterFrom, (Object)lastDot);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleLocation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/PyMoveFileHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewMap";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/PyMoveFileHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWithQualifiedExpression";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceRelativeImportSourceWithQualifiedExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateRelativeImportsInModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canBeRelative";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveRelativeImportFromModuleLocation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "probablyNamespacePackage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "retargetUsages";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithQualifiedExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "replaceRelativeImportSourceWithQualifiedExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeImportSourceRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14, 15, 17 -> new IllegalStateException(string);
        };
    }

    static final class PyUsageInfo
    extends UsageInfo {
        @NotNull
        private final PsiFile myFile;

        PyUsageInfo(@NotNull PsiElement element2, @NotNull PsiFile file) {
            if (element2 == null) {
                PyUsageInfo.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PyUsageInfo.$$$reportNull$$$0(1);
            }
            super(element2);
            this.myFile = file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/refactoring/move/PyMoveFileHandler$PyUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

