/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.library.PythonLibraryType;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.run.Context;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.PySdkTargetPaths;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\u001an\u0010\u0000\u001a\u00020\u00012(\u0010\u0002\u001a$\u0012\u0004\u0012\u00020\u0004\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u00032\u0006\u0010\b\u001a\u00020\t2\"\u0010\n\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\t\u001a,\u0010\u000f\u001a\u00020\u00012\"\u0010\u0010\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u000bH\u0002\u001a`\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t\u001a`\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t\u001aN\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u00122\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002\u001aF\u0010\u0011\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u00122\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u0002\u001a*\u0010#\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070$2\u0006\u0010%\u001a\u00020&\u001a<\u0010'\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010(\u001a\u00020)2\"\u0010*\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u000bH\u0002\u001a<\u0010+\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010(\u001a\u00020)2\"\u0010*\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u000bH\u0002\u001a4\u0010,\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\"\u0010\n\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u000bH\u0002\u001a\u000e\u0010-\u001a\u0004\u0018\u00010.*\u00020)H\u0002\u001a4\u0010/\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\"\u0010\n\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u000bH\u0002\u001aG\u00100\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 2\"\u0010\n\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0005j\b\u0012\u0004\u0012\u00020\u0004`\u00070\u000b2\f\u00101\u001a\b\u0012\u0004\u0012\u00020)02H\u0002\u00a2\u0006\u0002\u00103\u00a8\u00064"}, d2={"initPythonPath", "", "envs", "", "", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "passParentEnvs", "", "pythonPathList", "", "targetEnvironmentRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "checkPythonPathInEnvs", "appendSystemPythonPath", "pythonPath", "collectPythonPath", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "sdkHome", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "shouldAddContentRoots", "shouldAddSourceRoots", "isDebug", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "context", "Lcom/jetbrains/python/run/Context;", "addContentRoots", "addSourceRoots", "getAddedPaths", "", "sdkAdditionalData", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "addToPythonPath", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "pathList", "addIfNeeded", "addLibrariesFromModule", "toNioPathOrNull", "Ljava/nio/file/Path;", "addRootsFromModule", "addRoots", "roots", "", "(Lcom/jetbrains/python/run/Context;Ljava/util/Collection;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "intellij.python.community.impl"})
@JvmName(name="TargetedPythonPaths")
@SourceDebugExtension(value={"SMAP\nTargetedPythonPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetedPythonPaths.kt\ncom/jetbrains/python/run/TargetedPythonPaths\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n742#2,9:226\n1586#2:235\n1661#2,3:236\n1586#2:239\n1661#2,3:240\n1586#2:243\n1661#2,3:244\n12033#3,10:247\n14060#3:257\n14061#3:259\n12043#3:260\n1#4:258\n*S KotlinDebug\n*F\n+ 1 TargetedPythonPaths.kt\ncom/jetbrains/python/run/TargetedPythonPaths\n*L\n57#1:226,9\n57#1:235\n57#1:236,3\n132#1:239\n132#1:240,3\n135#1:243\n135#1:244,3\n178#1:247,10\n178#1:257\n178#1:259\n178#1:260\n178#1:258\n*E\n"})
public final class TargetedPythonPaths {
    public static final void initPythonPath(@NotNull Map<String, Function<TargetEnvironment, String>> envs, boolean passParentEnvs, @NotNull Collection<Function<TargetEnvironment, String>> pythonPathList, @NotNull TargetEnvironmentRequest targetEnvironmentRequest, boolean checkPythonPathInEnvs) {
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter(pythonPathList, (String)"pythonPathList");
        Intrinsics.checkNotNullParameter((Object)targetEnvironmentRequest, (String)"targetEnvironmentRequest");
        if (passParentEnvs && targetEnvironmentRequest instanceof LocalTargetEnvironmentRequest && (!checkPythonPathInEnvs || !envs.containsKey("PYTHONPATH"))) {
            TargetedPythonPaths.appendSystemPythonPath(pythonPathList);
        }
        PythonScripts.appendToPythonPath(envs, pythonPathList, targetEnvironmentRequest.getTargetPlatform());
    }

    public static /* synthetic */ void initPythonPath$default(Map map2, boolean bl, Collection collection, TargetEnvironmentRequest targetEnvironmentRequest, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        TargetedPythonPaths.initPythonPath(map2, bl, collection, targetEnvironmentRequest, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void appendSystemPythonPath(Collection<Function<TargetEnvironment, String>> pythonPath) {
        String syspath = System.getenv("PYTHONPATH");
        if (syspath != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list;
            ListIterator iterator$iv;
            Iterable $this$dropLastWhile$iv;
            CharSequence charSequence = syspath;
            Object object = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
            object = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
            Collection<Function<TargetEnvironment, String>> collection = pythonPath;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String p0 = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)p0).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$map = false;
            iterator$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(TargetEnvironmentFunctions.constant((Object)p0));
            }
            collection.addAll((List)destination$iv$iv);
        }
    }

    @NotNull
    public static final Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull Project project, @Nullable Module module2, @Nullable String sdkHome, @Nullable PyRemotePathMapper pathMapper, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Sdk sdk2 = PythonSdkUtil.findSdkByPath((String)sdkHome);
        return TargetedPythonPaths.collectPythonPath(project, module2, sdk2, pathMapper, shouldAddContentRoots, shouldAddSourceRoots, isDebug);
    }

    @NotNull
    public static final Collection<Function<TargetEnvironment, String>> collectPythonPath(@NotNull Project project, @Nullable Module module2, @Nullable Sdk sdk2, @Nullable PyRemotePathMapper pathMapper, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return TargetedPythonPaths.collectPythonPath(new Context(project, sdk2, pathMapper), module2, shouldAddContentRoots, shouldAddSourceRoots, isDebug);
    }

    private static final Collection<Function<TargetEnvironment, String>> collectPythonPath(Context context, Module module2, boolean shouldAddContentRoots, boolean shouldAddSourceRoots, boolean isDebug) {
        Set pythonPath = new LinkedHashSet<Function<TargetEnvironment, String>>(TargetedPythonPaths.collectPythonPath(context, module2, shouldAddContentRoots, shouldAddSourceRoots));
        return pythonPath;
    }

    private static final Collection<Function<TargetEnvironment, String>> collectPythonPath(Context context, Module module2, boolean addContentRoots, boolean addSourceRoots) {
        Collection pythonPathList = new LinkedHashSet();
        if (module2 != null) {
            Set dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module2, (Set)dependencies);
            if (addContentRoots) {
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
                TargetedPythonPaths.addRoots(context, pythonPathList, virtualFileArray);
                for (Module dependency : dependencies) {
                    VirtualFile[] virtualFileArray2 = ModuleRootManager.getInstance((Module)dependency).getContentRoots();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getContentRoots(...)");
                    TargetedPythonPaths.addRoots(context, pythonPathList, virtualFileArray2);
                }
            }
            if (addSourceRoots) {
                VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module2).getSourceRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
                TargetedPythonPaths.addRoots(context, pythonPathList, virtualFileArray);
                for (Module dependency : dependencies) {
                    VirtualFile[] virtualFileArray3 = ModuleRootManager.getInstance((Module)dependency).getSourceRoots();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray3, (String)"getSourceRoots(...)");
                    TargetedPythonPaths.addRoots(context, pythonPathList, virtualFileArray3);
                }
            }
            TargetedPythonPaths.addLibrariesFromModule(module2, pythonPathList);
            TargetedPythonPaths.addRootsFromModule(module2, pythonPathList);
            for (Module dependency : dependencies) {
                TargetedPythonPaths.addLibrariesFromModule(dependency, pythonPathList);
                TargetedPythonPaths.addRootsFromModule(dependency, pythonPathList);
            }
        }
        return pythonPathList;
    }

    @NotNull
    public static final List<Function<TargetEnvironment, String>> getAddedPaths(@NotNull SdkAdditionalData sdkAdditionalData) {
        Intrinsics.checkNotNullParameter((Object)sdkAdditionalData, (String)"sdkAdditionalData");
        List pathList = new ArrayList();
        if (sdkAdditionalData instanceof PythonSdkAdditionalData) {
            List list;
            if (sdkAdditionalData instanceof RemoteSdkProperties) {
                Set set = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAddedPathFiles(...)");
                $this$map$iv = set;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    var12_12 = destination$iv$iv;
                    boolean bl = false;
                    var12_12.add(((RemoteSdkProperties)sdkAdditionalData).getPathMappings().convertToRemote(it.getPath()));
                }
                list = (List)destination$iv$iv;
            } else {
                Set set = ((PythonSdkAdditionalData)sdkAdditionalData).getAddedPathFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAddedPathFiles(...)");
                $this$map$iv = set;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (VirtualFile)item$iv$iv;
                    var12_12 = destination$iv$iv;
                    boolean bl = false;
                    var12_12.add(it.getPath());
                }
                list = (List)destination$iv$iv;
            }
            List addedPaths = list;
            for (Object e : addedPaths) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String file = (String)e;
                pathList.add(TargetEnvironmentFunctions.constant((Object)file));
            }
        }
        return pathList;
    }

    private static final void addToPythonPath(Context context, VirtualFile file, Collection<Function<TargetEnvironment, String>> pathList) {
        if (file.getFileSystem() instanceof JarFileSystem) {
            VirtualFile realFile = JarFileSystem.getInstance().getVirtualFileForJar(file);
            if (realFile != null) {
                TargetedPythonPaths.addIfNeeded(context, realFile, pathList);
            }
        } else if (file.isDirectory()) {
            TargetedPythonPaths.addIfNeeded(context, file, pathList);
        }
    }

    private static final void addIfNeeded(Context context, VirtualFile file, Collection<Function<TargetEnvironment, String>> pathList) {
        Path filePath = Path.of(FileUtil.toSystemDependentName((String)file.getPath()), new String[0]);
        Project project = context.getProject();
        Sdk sdk2 = context.getSdk();
        PyRemotePathMapper pyRemotePathMapper = context.getPathMapper();
        Intrinsics.checkNotNull((Object)filePath);
        pathList.add(PySdkTargetPaths.getTargetPathForPythonConsoleExecution(project, sdk2, pyRemotePathMapper, filePath));
    }

    /*
     * WARNING - void declaration
     */
    private static final void addLibrariesFromModule(Module module2, Collection<Function<TargetEnvironment, String>> pythonPathList) {
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module2).getOrderEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"getOrderEntries(...)");
        for (OrderEntry entry : orderEntryArray) {
            void $this$mapNotNullTo$iv$iv;
            String name2;
            if (!(entry instanceof LibraryOrderEntry) || (name2 = ((LibraryOrderEntry)entry).getLibraryName()) != null && StringsKt.endsWith$default((String)name2, (String)" interpreter library", (boolean)false, (int)2, null)) continue;
            VirtualFile[] virtualFileArray = ((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRootFiles(...)");
            Object[] $this$mapNotNull$iv = virtualFileArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Path it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (TargetedPythonPaths.toNioPathOrNull(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (Path root : (List)destination$iv$iv) {
                PersistentLibraryKind kind;
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (!PlatformUtils.isPyCharm()) {
                    pythonPathList.add(TargetEnvironmentFunctions.targetPath((Path)root));
                    continue;
                }
                if (!(library instanceof LibraryEx) || (kind = ((LibraryEx)library).getKind()) != PythonLibraryType.getInstance().getKind()) continue;
                pythonPathList.add(TargetEnvironmentFunctions.targetPath((Path)root));
            }
        }
    }

    private static final Path toNioPathOrNull(VirtualFile $this$toNioPathOrNull) {
        return $this$toNioPathOrNull.getFileSystem().getNioPath($this$toNioPathOrNull);
    }

    private static final void addRootsFromModule(Module module2, Collection<Function<TargetEnvironment, String>> pythonPathList) {
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module2);
        if (extension != null) {
            VirtualFile pathForTests;
            VirtualFile path2 = extension.getCompilerOutputPath();
            if (path2 != null) {
                pythonPathList.add(TargetEnvironmentFunctions.constant((Object)path2.getPath()));
            }
            if ((pathForTests = extension.getCompilerOutputPathForTests()) != null) {
                pythonPathList.add(TargetEnvironmentFunctions.constant((Object)pathForTests.getPath()));
            }
        }
    }

    private static final void addRoots(Context context, Collection<Function<TargetEnvironment, String>> pythonPathList, VirtualFile[] roots) {
        for (VirtualFile root : roots) {
            TargetedPythonPaths.addToPythonPath(context, root, pythonPathList);
        }
    }
}

