/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ui.chat.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.aiplayground.models.chat.ChatMessage;
import com.intellij.aiplayground.ui.chat.view.FormattedView;
import com.intellij.aiplayground.ui.chat.view.MessageBubble;
import com.intellij.aiplayground.ui.chat.view.MessageBubblePanelKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.BackgroundRoundedPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0004J\u0012\u0010\"\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010&\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010(H\u0004J\u0012\u0010)\u001a\u00020\u001f2\b\u0010*\u001a\u0004\u0018\u00010+H\u0004J\u0012\u0010,\u001a\u00020\u001f2\b\u0010*\u001a\u0004\u0018\u00010+H\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0004\u0018\u00018\u0000X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lcom/intellij/aiplayground/ui/chat/view/MessageBubbleComponent;", "T", "Lcom/intellij/aiplayground/models/chat/ChatMessage;", "Ljavax/swing/JComponent;", "Lcom/intellij/aiplayground/ui/chat/view/MessageBubble;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "message", "getMessage", "()Lcom/intellij/aiplayground/models/chat/ChatMessage;", "setMessage", "(Lcom/intellij/aiplayground/models/chat/ChatMessage;)V", "Lcom/intellij/aiplayground/models/chat/ChatMessage;", "header", "Ljavax/swing/JPanel;", "getHeader", "()Ljavax/swing/JPanel;", "footer", "getFooter", "headerLabel", "panel", "getPanel", "messageLabel", "Lcom/intellij/aiplayground/ui/chat/view/FormattedView;", "getMessageLabel", "()Lcom/intellij/aiplayground/ui/chat/view/FormattedView;", "updateContent", "", "text", "", "setBackground", "bg", "Ljava/awt/Color;", "getBackground", "setActionGroup", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "setHeaderLabel", "label", "Ljavax/swing/JLabel;", "setFooter", "intellij.aiplayground.ui"})
@StabilityInferred(parameters=0)
public abstract class MessageBubbleComponent<T extends ChatMessage>
extends JComponent
implements MessageBubble<T> {
    @NotNull
    private final Project project;
    @Nullable
    private T message;
    @NotNull
    private final JPanel header;
    @NotNull
    private final JPanel footer;
    @Nullable
    private JComponent headerLabel;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final FormattedView messageLabel;
    public static final int $stable = 8;

    public MessageBubbleComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.header = new JPanel(new BorderLayout());
        this.header.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
        this.header.setOpaque(false);
        this.footer = new JPanel(new BorderLayout());
        this.footer.setBorder((Border)JBUI.Borders.emptyTop((int)12));
        this.footer.setOpaque(false);
        this.panel = (JPanel)new BackgroundRoundedPanel(12, null, 2, null);
        ((BackgroundRoundedPanel)this.panel).setLayout((LayoutManager)new BorderLayout());
        this.messageLabel = MessageBubblePanelKt.access$getFormattedViewProvider$p().createView(this.project);
        ((BackgroundRoundedPanel)this.panel).setBorder(JBUI.Borders.empty((int)8));
        this.panel.add(this.messageLabel.getComponent(), "Center");
        this.panel.add((Component)this.header, "North");
        this.panel.add((Component)this.footer, "South");
        this.add((Component)this.panel, "Center");
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Nullable
    protected final T getMessage() {
        return this.message;
    }

    protected final void setMessage(@Nullable T t) {
        this.message = t;
    }

    @NotNull
    protected final JPanel getHeader() {
        return this.header;
    }

    @NotNull
    protected final JPanel getFooter() {
        return this.footer;
    }

    @NotNull
    protected final JPanel getPanel() {
        return this.panel;
    }

    @NotNull
    protected final FormattedView getMessageLabel() {
        return this.messageLabel;
    }

    @Override
    protected final void updateContent(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.messageLabel.updateText(text);
    }

    @Override
    public void setBackground(@Nullable Color bg) {
        this.panel.setBackground(bg);
    }

    @Override
    @Nullable
    public Color getBackground() {
        return this.panel.getBackground();
    }

    protected final void setActionGroup(@Nullable ActionGroup group) {
        if (group == null) {
            return;
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("MessageBubbleToolbar", group, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)this);
        actionToolbar2.getComponent().setOpaque(false);
        actionToolbar2.getComponent().setBorder(null);
        this.header.add((Component)actionToolbar2.getComponent(), "East");
    }

    protected final void setHeaderLabel(@Nullable JLabel label) {
        if (this.headerLabel != null) {
            this.header.remove(this.headerLabel);
            this.headerLabel = null;
        }
        if (label != null) {
            this.header.add((Component)label, "Center");
        }
        this.headerLabel = label;
        this.header.revalidate();
    }

    protected final void setFooter(@Nullable JLabel label) {
        this.footer.removeAll();
        if (label != null) {
            this.footer.add((Component)label, "Center");
        }
        this.footer.revalidate();
    }
}

