/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.GotoTaskAction;
import com.intellij.tasks.core.TaskSymbol;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrTextInitParams;
import com.intellij.ui.dsl.listCellRenderer.LcrTextSpeedSearchParams;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"getTaskCellRenderer", "Ljavax/swing/ListCellRenderer;", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.tasks.core"})
@JvmName(name="TaskUiUtil")
public final class TaskUiUtil {
    @NotNull
    public static final ListCellRenderer<Object> getTaskCellRenderer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return BuilderKt.listCellRenderer(arg_0 -> TaskUiUtil.getTaskCellRenderer$lambda$0(project, arg_0));
    }

    private static final Unit getTaskCellRenderer$lambda$0$0$0(MinusculeMatcher $matcher, Task $task, LcrTextSpeedSearchParams $this$speedSearch) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$speedSearch, (String)"$this$speedSearch");
        MinusculeMatcher minusculeMatcher = $matcher;
        if (minusculeMatcher != null) {
            String string = $task.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            list = minusculeMatcher.match(string);
        } else {
            list = null;
        }
        $this$speedSearch.setRanges((Iterable)list);
        return Unit.INSTANCE;
    }

    private static final Unit getTaskCellRenderer$lambda$0$0(boolean $isClosed, MinusculeMatcher $matcher, Task $task, LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        if ($isClosed) {
            $this$text.setForeground($this$text.getGreyForeground());
        }
        $this$text.speedSearch(arg_0 -> TaskUiUtil.getTaskCellRenderer$lambda$0$0$0($matcher, $task, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit getTaskCellRenderer$lambda$0(Project $project, LcrRow $this$listCellRenderer) {
        Object value;
        Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
        $this$listCellRenderer.setSelectionColor(UIUtil.getListSelectionBackground((boolean)true));
        Matcher matcher = MatcherHolder.getAssociatedMatcher((JComponent)$this$listCellRenderer.getList());
        MinusculeMatcher matcher2 = matcher instanceof MinusculeMatcher ? (MinusculeMatcher)matcher : null;
        Object object = value = $this$listCellRenderer.getValue();
        if (object instanceof TaskSymbol) {
            Icon icon;
            Task task2 = ((TaskSymbol)value).getTask();
            TaskManager taskManager = TaskManager.getManager((Project)$project);
            boolean isLocalTask = taskManager.findTask(task2.getId()) != null;
            boolean isClosed = task2.isClosed() || task2 instanceof LocalTask && taskManager.isLocallyClosed((LocalTask)task2);
            $this$listCellRenderer.setBackground(isLocalTask ? UIUtil.getListBackground() : UIUtil.getDecoratedRowColor());
            if (isClosed) {
                Icon icon2 = task2.getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getIcon(...)");
                icon = IconLoader.getTransparentIcon((Icon)icon2);
            } else {
                Icon icon3 = task2.getIcon();
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getIcon(...)");
            }
            LcrRow.icon$default((LcrRow)$this$listCellRenderer, (Icon)icon, null, (int)2, null);
            String string = task2.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            $this$listCellRenderer.text(string, arg_0 -> TaskUiUtil.getTaskCellRenderer$lambda$0$0(isClosed, matcher2, task2, arg_0));
        } else if (Intrinsics.areEqual((Object)object, (Object)"...")) {
            Icon icon = EmptyIcon.ICON_16;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ICON_16");
            LcrRow.icon$default((LcrRow)$this$listCellRenderer, (Icon)icon, null, (int)2, null);
            LcrRow.text$default((LcrRow)$this$listCellRenderer, (String)"...", null, (int)2, null);
        } else if (Intrinsics.areEqual((Object)object, (Object)GotoTaskAction.CREATE_NEW_TASK_ACTION)) {
            LcrRow.icon$default((LcrRow)$this$listCellRenderer, (Icon)LayeredIcon.Companion.create(AllIcons.FileTypes.Unknown, AllIcons.Actions.New), null, (int)2, null);
            String string = GotoTaskAction.CREATE_NEW_TASK_ACTION.getActionText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActionText(...)");
            LcrRow.text$default((LcrRow)$this$listCellRenderer, (String)string, null, (int)2, null);
        }
        return Unit.INSTANCE;
    }
}

