/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.checkout;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.checkout.PerforceCloneParams;
import org.jetbrains.idea.perforce.checkout.PerforceCloneTask;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionTester;
import org.jetbrains.idea.perforce.perforce.connections.TestParametersConnection;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u0015H\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010#\u001a\u00020$H\u0002J \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/idea/perforce/checkout/PerforceCloneDialogComponent;", "Lcom/intellij/openapi/vcs/ui/VcsCloneComponent;", "project", "Lcom/intellij/openapi/project/Project;", "dialogStateListener", "Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/ui/cloneDialog/VcsCloneDialogComponentStateListener;)V", "serverField", "Lcom/intellij/ui/components/JBTextField;", "userField", "passwordField", "Lcom/intellij/ui/components/JBPasswordField;", "clientField", "directoryField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getView", "Ljavax/swing/JComponent;", "doClone", "", "listener", "Lcom/intellij/openapi/vcs/CheckoutProvider$Listener;", "isOkEnabled", "", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "getOkButtonText", "", "getPreferredFocusedComponent", "dispose", "testConnectionAndShowResult", "testConnection", "doTestConnection", "Lorg/jetbrains/idea/perforce/perforce/connections/PerforceConnectionTester$TestConnectionResult;", "createTestConnectionSettings", "Lorg/jetbrains/idea/perforce/perforce/PerforceSettings;", "server", "user", "client", "intellij.vcs.perforce"})
public final class PerforceCloneDialogComponent
implements VcsCloneComponent {
    @NotNull
    private final Project project;
    @NotNull
    private final VcsCloneDialogComponentStateListener dialogStateListener;
    private JBTextField serverField;
    private JBTextField userField;
    private JBPasswordField passwordField;
    private JBTextField clientField;
    private TextFieldWithBrowseButton directoryField;
    @NotNull
    private final DialogPanel panel;

    /*
     * WARNING - void declaration
     */
    public PerforceCloneDialogComponent(@NotNull Project project, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        void it;
        void $this$panel_u24lambda_u241;
        DialogPanel dialogPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dialogStateListener, (String)"dialogStateListener");
        this.project = project;
        this.dialogStateListener = dialogStateListener;
        DialogPanel dialogPanel2 = dialogPanel = BuilderKt.panel(arg_0 -> PerforceCloneDialogComponent.panel$lambda$0(this, arg_0));
        PerforceCloneDialogComponent perforceCloneDialogComponent = this;
        boolean bl = false;
        Insets insets = UIUtil.PANEL_REGULAR_INSETS;
        void var7_8 = $this$panel_u24lambda_u241;
        boolean bl2 = false;
        var7_8.setBorder(BorderFactory.createEmptyBorder(0, it.left, it.bottom, it.right));
        perforceCloneDialogComponent.panel = dialogPanel;
        DocumentAdapter listener2 = new DocumentAdapter(this){
            final /* synthetic */ PerforceCloneDialogComponent this$0;
            {
                this.this$0 = $receiver;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PerforceCloneDialogComponent.access$getDialogStateListener$p(this.this$0).onOkActionEnabled(this.this$0.isOkEnabled());
            }
        };
        JBTextField jBTextField = this.serverField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverField");
            jBTextField = null;
        }
        jBTextField.getDocument().addDocumentListener((DocumentListener)listener2);
        JBTextField jBTextField2 = this.userField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userField");
            jBTextField2 = null;
        }
        jBTextField2.getDocument().addDocumentListener((DocumentListener)listener2);
        JBTextField jBTextField3 = this.clientField;
        if (jBTextField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientField");
            jBTextField3 = null;
        }
        jBTextField3.getDocument().addDocumentListener((DocumentListener)listener2);
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.directoryField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"directoryField");
            textFieldWithBrowseButton = null;
        }
        textFieldWithBrowseButton.getTextField().getDocument().addDocumentListener((DocumentListener)listener2);
    }

    @NotNull
    public JComponent getView() {
        return (JComponent)this.panel;
    }

    public void doClone(@NotNull CheckoutProvider.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        JBTextField jBTextField = this.serverField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverField");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        JBTextField jBTextField2 = this.userField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userField");
            jBTextField2 = null;
        }
        String string3 = jBTextField2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        JBPasswordField jBPasswordField = this.passwordField;
        if (jBPasswordField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"passwordField");
            jBPasswordField = null;
        }
        char[] cArray = jBPasswordField.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
        char[] cArray2 = cArray;
        String string5 = new String(cArray2);
        JBTextField jBTextField3 = this.clientField;
        if (jBTextField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientField");
            jBTextField3 = null;
        }
        String string6 = jBTextField3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        String string7 = ((Object)StringsKt.trim((CharSequence)string6)).toString();
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.directoryField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"directoryField");
            textFieldWithBrowseButton = null;
        }
        String string8 = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getText(...)");
        PerforceCloneParams params = new PerforceCloneParams(string2, string4, string5, string7, ((Object)StringsKt.trim((CharSequence)string8)).toString());
        Path projectPath = Path.of(params.getDirectory(), new String[0]).toAbsolutePath();
        PerforceCloneTask cloneTask = new PerforceCloneTask(this.project, params, listener2);
        CloneableProjectsService cloneableProjectsService = CloneableProjectsService.Companion.getInstance();
        Intrinsics.checkNotNull((Object)projectPath);
        cloneableProjectsService.runCloneTask(projectPath, (CloneableProjectsService.CloneTask)cloneTask);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOkEnabled() {
        JBTextField jBTextField = this.serverField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverField");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) return false;
        boolean bl = true;
        if (!bl) return false;
        JBTextField jBTextField2 = this.userField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userField");
            jBTextField2 = null;
        }
        String string2 = jBTextField2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string2)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        JBTextField jBTextField3 = this.clientField;
        if (jBTextField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientField");
            jBTextField3 = null;
        }
        String string3 = jBTextField3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string3)) return false;
        boolean bl3 = true;
        if (!bl3) return false;
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.directoryField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"directoryField");
            textFieldWithBrowseButton = null;
        }
        String string4 = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string4)) return false;
        return true;
    }

    @NotNull
    public List<ValidationInfo> doValidateAll() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBTextField jBTextField;
        JBTextField jBTextField2;
        List result = new ArrayList();
        JBTextField jBTextField3 = this.serverField;
        if (jBTextField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverField");
            jBTextField3 = null;
        }
        String string = jBTextField3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            String string2 = PerforceBundle.message("checkout.validation.server.empty", new Object[0]);
            JBTextField jBTextField4 = this.serverField;
            if (jBTextField4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"serverField");
                jBTextField4 = null;
            }
            result.add(new ValidationInfo(string2, (JComponent)jBTextField4));
        }
        if ((jBTextField2 = this.userField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userField");
            jBTextField2 = null;
        }
        String string3 = jBTextField2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string3)) {
            String string4 = PerforceBundle.message("checkout.validation.user.empty", new Object[0]);
            JBTextField jBTextField5 = this.userField;
            if (jBTextField5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"userField");
                jBTextField5 = null;
            }
            result.add(new ValidationInfo(string4, (JComponent)jBTextField5));
        }
        if ((jBTextField = this.clientField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientField");
            jBTextField = null;
        }
        String string5 = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string5)) {
            String string6 = PerforceBundle.message("checkout.validation.client.empty", new Object[0]);
            JBTextField jBTextField6 = this.clientField;
            if (jBTextField6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clientField");
                jBTextField6 = null;
            }
            result.add(new ValidationInfo(string6, (JComponent)jBTextField6));
        }
        if ((textFieldWithBrowseButton = this.directoryField) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"directoryField");
            textFieldWithBrowseButton = null;
        }
        String string7 = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string7)) {
            String string8 = PerforceBundle.message("checkout.validation.directory.empty", new Object[0]);
            TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.directoryField;
            if (textFieldWithBrowseButton2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"directoryField");
                textFieldWithBrowseButton2 = null;
            }
            result.add(new ValidationInfo(string8, (JComponent)textFieldWithBrowseButton2));
        } else {
            File dir;
            TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.directoryField;
            if (textFieldWithBrowseButton3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"directoryField");
                textFieldWithBrowseButton3 = null;
            }
            if ((dir = new File(textFieldWithBrowseButton3.getText())).exists() && !dir.isDirectory()) {
                String string9 = PerforceBundle.message("checkout.validation.directory.not.dir", new Object[0]);
                TextFieldWithBrowseButton textFieldWithBrowseButton4 = this.directoryField;
                if (textFieldWithBrowseButton4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"directoryField");
                    textFieldWithBrowseButton4 = null;
                }
                result.add(new ValidationInfo(string9, (JComponent)textFieldWithBrowseButton4));
            }
        }
        if (result.isEmpty()) {
            return CollectionsKt.listOfNotNull((Object)this.testConnection());
        }
        return result;
    }

    @NotNull
    public String getOkButtonText() {
        String string = PerforceBundle.message("checkout.button.sync", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JBTextField jBTextField = this.serverField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverField");
            jBTextField = null;
        }
        return (JComponent)jBTextField;
    }

    public void dispose() {
    }

    private final void testConnectionAndShowResult() {
        JBTextField jBTextField = this.serverField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverField");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String server = ((Object)StringsKt.trim((CharSequence)string)).toString();
        JBTextField jBTextField2 = this.userField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userField");
            jBTextField2 = null;
        }
        String string2 = jBTextField2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String user = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (StringsKt.isBlank((CharSequence)server) || StringsKt.isBlank((CharSequence)user)) {
            Messages.showWarningDialog((Component)((Component)this.panel), (String)PerforceBundle.message("checkout.test.connection.fill.fields", new Object[0]), (String)PerforceBundle.message("checkout.test.connection.title", new Object[0]));
            return;
        }
        PerforceConnectionTester.TestConnectionResult result = this.doTestConnection();
        if (result.isCancelled()) {
            Messages.showMessageDialog((Project)this.project, (String)PerforceBundle.message("connection.cancelled", new Object[0]), (String)PerforceBundle.message("connection.state.title", new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        if (result.getErrorMessage() != null) {
            Messages.showErrorDialog((Project)this.project, (String)result.getErrorMessage(), (String)PerforceBundle.message("connection.state.title", new Object[0]));
            return;
        }
        P4RootsInformation p4RootsInformation = result.getInfo();
        if (p4RootsInformation == null) {
            return;
        }
        P4RootsInformation info = p4RootsInformation;
        PerforceConnectionProblemsNotifier.showSingleConnectionState(this.project, info);
    }

    private final ValidationInfo testConnection() {
        PerforceConnectionTester.TestConnectionResult result = this.doTestConnection();
        if (result.isCancelled()) {
            return null;
        }
        if (result.getErrorMessage() != null) {
            return new ValidationInfo(result.getErrorMessage());
        }
        P4RootsInformation p4RootsInformation = result.getInfo();
        if (p4RootsInformation == null) {
            return null;
        }
        P4RootsInformation info = p4RootsInformation;
        String string = PerforceConnectionProblemsNotifier.getSingleConnectionState(info);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSingleConnectionState(...)");
        String errorMessage = string;
        return StringsKt.isBlank((CharSequence)errorMessage) ? null : new ValidationInfo(errorMessage);
    }

    private final PerforceConnectionTester.TestConnectionResult doTestConnection() {
        P4ConnectionParameters p4ConnectionParameters;
        JBTextField jBTextField = this.serverField;
        if (jBTextField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"serverField");
            jBTextField = null;
        }
        String string = jBTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String server = ((Object)StringsKt.trim((CharSequence)string)).toString();
        JBTextField jBTextField2 = this.userField;
        if (jBTextField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"userField");
            jBTextField2 = null;
        }
        String string2 = jBTextField2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String user = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        JBPasswordField jBPasswordField = this.passwordField;
        if (jBPasswordField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"passwordField");
            jBPasswordField = null;
        }
        char[] cArray = jBPasswordField.getPassword();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
        char[] cArray2 = cArray;
        String password = new String(cArray2);
        JBTextField jBTextField3 = this.clientField;
        if (jBTextField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientField");
            jBTextField3 = null;
        }
        String string3 = jBTextField3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        String client = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.directoryField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"directoryField");
            textFieldWithBrowseButton = null;
        }
        String string4 = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        String directory = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        Path clientRoot = Path.of(directory, new String[0]);
        if (!clientRoot.toFile().isDirectory()) {
            Object[] objectArray = new Object[]{directory};
            return new PerforceConnectionTester.TestConnectionResult(false, false, null, null, PerforceBundle.message("checkout.validation.directory.not.exist", objectArray), 8, null);
        }
        PerforceSettings settings = this.createTestConnectionSettings(server, user, client);
        P4ConnectionParameters $this$doTestConnection_u24lambda_u240 = p4ConnectionParameters = new P4ConnectionParameters();
        boolean bl = false;
        $this$doTestConnection_u24lambda_u240.setServer(server);
        $this$doTestConnection_u24lambda_u240.setUser(user);
        $this$doTestConnection_u24lambda_u240.setClient(client);
        $this$doTestConnection_u24lambda_u240.setPassword(password);
        P4ConnectionParameters parameters = p4ConnectionParameters;
        TestParametersConnection connection = new TestParametersConnection(parameters, new ConnectionId());
        PerforceConnectionTester tester = new PerforceConnectionTester(this.project, settings);
        return tester.testConnection(connection, clientRoot);
    }

    private final PerforceSettings createTestConnectionSettings(String server, String user, String client) {
        PerforceSettings perforceSettings;
        PerforceSettings $this$createTestConnectionSettings_u24lambda_u240 = perforceSettings = new PerforceSettings(this.project);
        boolean bl = false;
        $this$createTestConnectionSettings_u24lambda_u240.setCanGoOffline(false);
        $this$createTestConnectionSettings_u24lambda_u240.useP4CONFIG = false;
        $this$createTestConnectionSettings_u24lambda_u240.USE_LOGIN = true;
        $this$createTestConnectionSettings_u24lambda_u240.port = server;
        $this$createTestConnectionSettings_u24lambda_u240.user = user;
        $this$createTestConnectionSettings_u24lambda_u240.client = client;
        return perforceSettings;
    }

    private static final Unit panel$lambda$0$0$0(JBTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.getEmptyText().setText(PerforceBundle.message("settings.port.placeholder", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$5$0(PerforceCloneDialogComponent this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.testConnectionAndShowResult();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0(PerforceCloneDialogComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.serverField = (JBTextField)TextFieldKt.columns((Cell)$this$row.textField(), (int)25).applyToComponent(PerforceCloneDialogComponent::panel$lambda$0$0$0).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$1(PerforceCloneDialogComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.userField = (JBTextField)TextFieldKt.columns((Cell)$this$row.textField(), (int)25).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$2(PerforceCloneDialogComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.passwordField = (JBPasswordField)TextFieldKt.columns((Cell)$this$row.cell((JComponent)new JBPasswordField()), (int)25).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$3(PerforceCloneDialogComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.clientField = (JBTextField)TextFieldKt.columns((Cell)$this$row.textField(), (int)25).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$4(PerforceCloneDialogComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(PerforceBundle.message("checkout.directory.chooser.title", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withTitle(...)");
        this$0.directoryField = (TextFieldWithBrowseButton)TextFieldWithBrowseButtonKt.columns((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)fileChooserDescriptor, (Project)this$0.project, null, (int)4, null), (int)25).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$5(PerforceCloneDialogComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PerforceBundle.message("checkout.test.connection", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.button(string, arg_0 -> PerforceCloneDialogComponent.panel$lambda$0$5$0(this$0, arg_0)).align((Align)AlignX.LEFT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0(PerforceCloneDialogComponent this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = PerforceBundle.message("checkout.server.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> PerforceCloneDialogComponent.panel$lambda$0$0(this$0, arg_0));
        String string2 = PerforceBundle.message("checkout.user.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> PerforceCloneDialogComponent.panel$lambda$0$1(this$0, arg_0));
        String string3 = PerforceBundle.message("checkout.password.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> PerforceCloneDialogComponent.panel$lambda$0$2(this$0, arg_0));
        String string4 = PerforceBundle.message("checkout.client.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        $this$panel.row(string4, arg_0 -> PerforceCloneDialogComponent.panel$lambda$0$3(this$0, arg_0));
        String string5 = PerforceBundle.message("checkout.directory.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        $this$panel.row(string5, arg_0 -> PerforceCloneDialogComponent.panel$lambda$0$4(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PerforceCloneDialogComponent.panel$lambda$0$5(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ VcsCloneDialogComponentStateListener access$getDialogStateListener$p(PerforceCloneDialogComponent $this) {
        return $this.dialogStateListener;
    }
}

