/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.canvas;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/canvas/TextMetrics;", "", "ascent", "", "descent", "bbox", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(DDLorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;)V", "getAscent", "()D", "getBbox", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getDescent", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "canvas"})
public final class TextMetrics {
    private final double ascent;
    private final double descent;
    @NotNull
    private final DoubleRectangle bbox;

    public TextMetrics(double ascent, double descent, @NotNull DoubleRectangle bbox2) {
        Intrinsics.checkNotNullParameter((Object)bbox2, (String)"bbox");
        this.ascent = ascent;
        this.descent = descent;
        this.bbox = bbox2;
    }

    public final double getAscent() {
        return this.ascent;
    }

    public final double getDescent() {
        return this.descent;
    }

    @NotNull
    public final DoubleRectangle getBbox() {
        return this.bbox;
    }

    public final double component1() {
        return this.ascent;
    }

    public final double component2() {
        return this.descent;
    }

    @NotNull
    public final DoubleRectangle component3() {
        return this.bbox;
    }

    @NotNull
    public final TextMetrics copy(double ascent, double descent, @NotNull DoubleRectangle bbox2) {
        Intrinsics.checkNotNullParameter((Object)bbox2, (String)"bbox");
        return new TextMetrics(ascent, descent, bbox2);
    }

    public static /* synthetic */ TextMetrics copy$default(TextMetrics textMetrics, double d, double d2, DoubleRectangle doubleRectangle, int n, Object object) {
        if ((n & 1) != 0) {
            d = textMetrics.ascent;
        }
        if ((n & 2) != 0) {
            d2 = textMetrics.descent;
        }
        if ((n & 4) != 0) {
            doubleRectangle = textMetrics.bbox;
        }
        return textMetrics.copy(d, d2, doubleRectangle);
    }

    @NotNull
    public String toString() {
        return "TextMetrics(ascent=" + this.ascent + ", descent=" + this.descent + ", bbox=" + this.bbox + ')';
    }

    public int hashCode() {
        int result2 = Double.hashCode(this.ascent);
        result2 = result2 * 31 + Double.hashCode(this.descent);
        result2 = result2 * 31 + this.bbox.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextMetrics)) {
            return false;
        }
        TextMetrics textMetrics = (TextMetrics)other;
        if (Double.compare(this.ascent, textMetrics.ascent) != 0) {
            return false;
        }
        if (Double.compare(this.descent, textMetrics.descent) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bbox, (Object)textMetrics.bbox);
    }
}

