/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.treetable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterfallSupport<T> {
    private final Map<T, T> myWaterfall;
    private final Traverser<T> myTraverser;
    private final Predicate<? super T> myFilter;
    private final T rootsParent;
    private final Consumer<T> empty;

    public WaterfallSupport(@NotNull Traverser<T> traverser, @NotNull Predicate<? super T> filter, @Nullable T root) {
        if (traverser == null) {
            WaterfallSupport.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            WaterfallSupport.$$$reportNull$$$0(1);
        }
        this.myWaterfall = new HashMap<T, T>();
        this.empty = v -> {};
        this.myTraverser = traverser;
        this.myFilter = filter;
        this.rootsParent = root == null ? null : this.myTraverser.getParent(root);
        Object v0 = this.rootsParent;
        if (root != null) {
            this.myWaterfall.put(root, root);
        }
    }

    public WaterfallSupport(@NotNull Traverser<T> traverser, @NotNull Predicate<? super T> filter) {
        if (traverser == null) {
            WaterfallSupport.$$$reportNull$$$0(2);
        }
        if (filter == null) {
            WaterfallSupport.$$$reportNull$$$0(3);
        }
        this(traverser, filter, null);
    }

    public T forward(T element) {
        T forwardValue = this.myWaterfall.get(element);
        if (forwardValue == null) {
            T waterfallValue = this.waterfall(element);
            if (waterfallValue != element) {
                if (this.backward(element) == element) {
                    this.myWaterfall.put(element, waterfallValue);
                }
                return waterfallValue;
            }
            forwardValue = element;
        }
        return forwardValue;
    }

    public T backward(T element) {
        return this.backward(element, this.empty);
    }

    public T backward(T element, Consumer<? super T> consumer) {
        for (Map.Entry entry : this.myWaterfall.entrySet()) {
            if (entry.getValue() != element) continue;
            return this.backward(entry.getValue(), v -> v != entry.getKey(), consumer);
        }
        LinkedList parents = new LinkedList();
        Object backward = this.backward(element, v -> !this.myWaterfall.containsKey(v), v -> parents.add(v));
        if (!parents.contains(this.myWaterfall.get(backward))) {
            parents.forEach(consumer);
            return (T)backward;
        }
        return element;
    }

    private T backward(T element, Predicate<? super T> canContinue, Consumer<? super T> consumer) {
        T backwardValue = element;
        while (canContinue.test(backwardValue)) {
            consumer.accept(backwardValue);
            if ((backwardValue = this.myTraverser.getParent(backwardValue)) != this.rootsParent) continue;
            consumer.accept(this.rootsParent);
            return element;
        }
        consumer.accept(backwardValue);
        return backwardValue;
    }

    public List<T> fold(T start, T end) {
        T current = end;
        ArrayList<T> nodes = new ArrayList<T>();
        T waterfall = this.waterfall(start);
        while (current != start && current != this.rootsParent) {
            nodes.add(0, current);
            if (waterfall == current && current != end) {
                throw new IllegalArgumentException(String.valueOf(start) + " and " + String.valueOf(end) + " cannot be folded");
            }
            current = this.myTraverser.getParent(current);
        }
        if (current != start) {
            throw new IllegalArgumentException(String.valueOf(start) + " isn't parent of " + String.valueOf(end) + " in this chain: ");
        }
        T oldValue = this.myWaterfall.get(current);
        if (oldValue != null && oldValue != current) {
            throw new IllegalArgumentException(String.valueOf(current) + " isn't equal to removed value " + String.valueOf(oldValue));
        }
        this.myWaterfall.keySet().removeAll(nodes);
        if (this.myWaterfall.put(current, end) != oldValue) {
            throw new IllegalStateException("Data changed while processing fold");
        }
        nodes.add(0, oldValue);
        return nodes;
    }

    public List<T> unfold(T start, T end) {
        HashSet parents = new HashSet();
        Object left = this.backward(start, v -> !this.myWaterfall.containsKey(v), parents::add);
        if (!this.contains(left) || parents.contains(this.myWaterfall.get(left))) {
            return Collections.emptyList();
        }
        Object right = this.waterfall(left);
        ArrayList<T> folded = new ArrayList<T>(10);
        T current = end;
        T startParent = this.myTraverser.getParent(start);
        while (current != startParent) {
            this.myWaterfall.put(current, current);
            folded.add(0, current);
            current = this.myTraverser.getParent(current);
        }
        this.myWaterfall.put(end, right);
        this.myWaterfall.put(left, start);
        return folded;
    }

    public boolean contains(T element) {
        return this.myWaterfall.containsKey(element);
    }

    public void clear() {
        this.myWaterfall.clear();
    }

    private T waterfall(T element) {
        List<T> children;
        if (!this.myFilter.test(element) || this.myTraverser.getParent(element) == this.rootsParent) {
            return element;
        }
        T current = element;
        while ((children = this.myTraverser.getChildren(current)).size() == 1 && this.myFilter.test(children.get(0))) {
            current = children.get(0);
        }
        return current;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "traverser";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "filter";
                break;
            }
        }
        objectArray[1] = "com/intellij/profiler/ui/treetable/WaterfallSupport";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Traverser<T> {
        public T getParent(T var1);

        public List<T> getChildren(T var1);
    }
}

