/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.turn.message.request;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.network.turn.TurnError;
import com.intellij.platform.split.connection.network.turn.TurnMessageUtil;
import com.intellij.platform.split.connection.network.turn.message.TurnMessage;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.ice4j.message.Message;
import org.ice4j.message.Request;
import org.ice4j.security.LongTermCredentialSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\r\b&\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010*R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0016\u0010\u0014R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR8\u0010\u001b\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R8\u0010%\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b&\u0010!\"\u0004\b'\u0010#\u00a8\u0006,"}, d2={"Lcom/intellij/platform/split/connection/network/turn/message/request/TurnRequest;", "Lcom/intellij/platform/split/connection/network/turn/message/TurnMessage;", "Lorg/ice4j/message/Request;", "name", "", "responseTimeout", "Ljava/time/Duration;", "successMessages", "", "", "errorMessages", "credentialSession", "Lorg/ice4j/security/LongTermCredentialSession;", "<init>", "(Ljava/lang/String;Ljava/time/Duration;[Ljava/lang/Character;[Ljava/lang/Character;Lorg/ice4j/security/LongTermCredentialSession;)V", "getName", "()Ljava/lang/String;", "getResponseTimeout", "()Ljava/time/Duration;", "getSuccessMessages", "()[Ljava/lang/Character;", "[Ljava/lang/Character;", "getErrorMessages", "getCredentialSession", "()Lorg/ice4j/security/LongTermCredentialSession;", "setCredentialSession", "(Lorg/ice4j/security/LongTermCredentialSession;)V", "onSuccessResponse", "Lkotlin/Function2;", "Lorg/ice4j/message/Message;", "Lkotlin/coroutines/Continuation;", "", "getOnSuccessResponse", "()Lkotlin/jvm/functions/Function2;", "setOnSuccessResponse", "(Lkotlin/jvm/functions/Function2;)V", "Lkotlin/jvm/functions/Function2;", "onErrorResponse", "getOnErrorResponse", "setOnErrorResponse", "handleResponse", "response", "(Lorg/ice4j/message/Message;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nTurnRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurnRequest.kt\ncom/intellij/platform/split/connection/network/turn/message/request/TurnRequest\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,67:1\n60#2,5:68\n60#2,5:73\n13#2:79\n13#3:78\n*S KotlinDebug\n*F\n+ 1 TurnRequest.kt\ncom/intellij/platform/split/connection/network/turn/message/request/TurnRequest\n*L\n52#1:68,5\n55#1:73,5\n31#1:79\n31#1:78\n*E\n"})
public abstract class TurnRequest
implements TurnMessage<Request> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Duration responseTimeout;
    @NotNull
    private final Character[] successMessages;
    @NotNull
    private final Character[] errorMessages;
    @Nullable
    private LongTermCredentialSession credentialSession;
    @NotNull
    private Function2<? super Message, ? super Continuation<? super Message>, ? extends Object> onSuccessResponse;
    @NotNull
    private Function2<? super Message, ? super Continuation<? super Message>, ? extends Object> onErrorResponse;
    @NotNull
    private static final Logger logger;

    public TurnRequest(@NotNull String name, @NotNull Duration responseTimeout, @NotNull Character[] successMessages, @NotNull Character[] errorMessages, @Nullable LongTermCredentialSession credentialSession) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)responseTimeout, (String)"responseTimeout");
        Intrinsics.checkNotNullParameter((Object)successMessages, (String)"successMessages");
        Intrinsics.checkNotNullParameter((Object)errorMessages, (String)"errorMessages");
        this.name = name;
        this.responseTimeout = responseTimeout;
        this.successMessages = successMessages;
        this.errorMessages = errorMessages;
        this.credentialSession = credentialSession;
        this.onSuccessResponse = (Function2)new Function2<Message, Continuation<? super Message>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Message message = (Message)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        return it;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Message p1, Continuation<? super Message> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        };
        this.onErrorResponse = (Function2)new Function2<Message, Continuation<? super Message>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Message message = (Message)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        return it;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Message p1, Continuation<? super Message> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        };
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    @NotNull
    public final Character[] getSuccessMessages() {
        return this.successMessages;
    }

    @NotNull
    public final Character[] getErrorMessages() {
        return this.errorMessages;
    }

    @Nullable
    public final LongTermCredentialSession getCredentialSession() {
        return this.credentialSession;
    }

    public final void setCredentialSession(@Nullable LongTermCredentialSession longTermCredentialSession) {
        this.credentialSession = longTermCredentialSession;
    }

    @NotNull
    public final Function2<Message, Continuation<? super Message>, Object> getOnSuccessResponse() {
        return this.onSuccessResponse;
    }

    public final void setOnSuccessResponse(@NotNull Function2<? super Message, ? super Continuation<? super Message>, ? extends Object> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.onSuccessResponse = function2;
    }

    @NotNull
    public final Function2<Message, Continuation<? super Message>, Object> getOnErrorResponse() {
        return this.onErrorResponse;
    }

    public final void setOnErrorResponse(@NotNull Function2<? super Message, ? super Continuation<? super Message>, ? extends Object> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.onErrorResponse = function2;
    }

    @Nullable
    public Object handleResponse(@NotNull Message response2, @NotNull Continuation<? super Message> $completion) {
        return TurnRequest.handleResponse$suspendImpl(this, response2, $completion);
    }

    static /* synthetic */ Object handleResponse$suspendImpl(TurnRequest $this, Message response2, Continuation<? super Message> $completion) {
        Logger logger;
        char messageType = response2.getMessageType();
        Logger $this$debug_u24default$iv = TurnRequest.logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Start handling '" + $this.getName() + "' TURN response with message type '" + TurnMessageUtil.INSTANCE.toHex(messageType) + "'.", t$iv);
        }
        if (ArraysKt.contains((Object[])$this.successMessages, (Object)Boxing.boxChar((char)messageType))) {
            $this$debug_u24default$iv = TurnRequest.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Got success TURN response: " + TurnMessageUtil.INSTANCE.toHex(messageType), t$iv);
            }
            return $this.onSuccessResponse.invoke((Object)response2, $completion);
        }
        if (ArraysKt.contains((Object[])$this.errorMessages, (Object)Boxing.boxChar((char)messageType))) {
            TurnRequest.logger.info("Got error TURN response: " + TurnMessageUtil.INSTANCE.toHex(messageType));
            return $this.onErrorResponse.invoke((Object)response2, $completion);
        }
        throw new TurnError("Unexpected response message type '" + TurnMessageUtil.INSTANCE.toHex(messageType) + "' for '" + $this.getName() + "' request.", null, 2, null);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TurnRequest.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TurnRequest.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/split/connection/network/turn/message/request/TurnRequest$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.split.connection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

