/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.hash;

import com.intellij.indexing.shared.platform.hash.SharedIndexContentEnumerators;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashEnumerator;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorage;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorageImpl;
import com.intellij.indexing.shared.platform.hash.SharedIndexMainContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexMainContentHashEnumerator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007*\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/platform/hash/SharedIndexHashStorages;", "", "<init>", "()V", "STORAGE_VERSION", "", "getHashPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "sharedIndexRoot", "openHashEnumerator", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashEnumerator;", "hash", "lifetime", "Lcom/intellij/openapi/Disposable;", "createGeneratorStorage", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexHashStorage;", "intellij.indexing.shared"})
public final class SharedIndexHashStorages {
    @NotNull
    private final String STORAGE_VERSION;

    public SharedIndexHashStorages() {
        this.STORAGE_VERSION = "1";
    }

    private final Path getHashPath(SharedIndexContentHash $this$getHashPath, Path sharedIndexRoot) {
        return sharedIndexRoot.resolve("hashes-" + $this$getHashPath.getProviderId() + "-" + $this$getHashPath.getVersion() + "-i" + this.STORAGE_VERSION);
    }

    @Nullable
    public final SharedIndexContentHashEnumerator openHashEnumerator(@NotNull Path sharedIndexRoot, @NotNull SharedIndexContentHash hash, @NotNull Disposable lifetime) {
        Intrinsics.checkNotNullParameter((Object)sharedIndexRoot, (String)"sharedIndexRoot");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (hash instanceof SharedIndexMainContentHash) {
            return new SharedIndexMainContentHashEnumerator(lifetime, SharedIndexContentEnumerators.INSTANCE.openEnumeratorForAttachedSharedIndex(sharedIndexRoot));
        }
        Path indexPath = this.getHashPath(hash, sharedIndexRoot);
        Intrinsics.checkNotNull((Object)indexPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(indexPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        return new SharedIndexHashStorageImpl(indexPath, hash, true, lifetime);
    }

    @Nullable
    public final SharedIndexHashStorage createGeneratorStorage(@NotNull Path sharedIndexRoot, @NotNull SharedIndexContentHash hash, @NotNull Disposable lifetime) {
        Intrinsics.checkNotNullParameter((Object)sharedIndexRoot, (String)"sharedIndexRoot");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (hash instanceof SharedIndexMainContentHash) {
            return null;
        }
        Path indexPath = this.getHashPath(hash, sharedIndexRoot);
        Intrinsics.checkNotNull((Object)indexPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(indexPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException("Indexes hash file for " + hash.getProviderId() + " already exists at " + indexPath);
        }
        return new SharedIndexHashStorageImpl(indexPath, hash, false, lifetime);
    }
}

