/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.api.layout.SharedIndexLocation;
import com.intellij.indexing.shared.platform.api.layout.SharedStubIndexLocation;
import com.intellij.indexing.shared.platform.impl.EmptyIndex;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.HashBasedMapReduceIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndexExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import java.io.Closeable;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u0017*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0003\u0015\u0016\u0017B%\b\u0004\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR(\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u0010\u0012\u0002\b\u00030\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndex;", "K", "V", "Ljava/io/Closeable;", "indexName", "Lcom/intellij/util/indexing/ID;", "chunkId", "", "<init>", "(Lcom/intellij/util/indexing/ID;I)V", "getIndexName", "()Lcom/intellij/util/indexing/ID;", "getChunkId", "()I", "index", "Lcom/intellij/util/indexing/UpdatableIndex;", "Lcom/intellij/util/indexing/FileContent;", "getIndex", "()Lcom/intellij/util/indexing/UpdatableIndex;", "close", "", "Impl", "Empty", "Companion", "Lcom/intellij/indexing/shared/platform/impl/SharedIndex$Empty;", "Lcom/intellij/indexing/shared/platform/impl/SharedIndex$Impl;", "intellij.indexing.shared"})
@ApiStatus.Internal
public abstract sealed class SharedIndex<K, V>
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ID<K, V> indexName;
    private final int chunkId;
    @NotNull
    private static final ConcurrentHashMap<Integer, StorageLockContext> sharedIndexLock = new ConcurrentHashMap();

    private SharedIndex(ID<K, V> indexName, int chunkId) {
        this.indexName = indexName;
        this.chunkId = chunkId;
    }

    @NotNull
    public final ID<K, V> getIndexName() {
        return this.indexName;
    }

    public final int getChunkId() {
        return this.chunkId;
    }

    @NotNull
    public abstract UpdatableIndex<K, V, FileContent, ?> getIndex();

    @Override
    public void close() {
        this.getIndex().dispose();
    }

    @JvmStatic
    public static final <T> T withReadWriteStorageLock(int chunkId, @NotNull Function0<? extends T> operation) {
        return Companion.withReadWriteStorageLock(chunkId, operation);
    }

    public /* synthetic */ SharedIndex(ID indexName, int chunkId, DefaultConstructorMarker $constructor_marker) {
        this(indexName, chunkId);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\b\u001a\u0002H\t\"\u0004\b\u0002\u0010\t2\u0006\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0007\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndex$Companion;", "", "<init>", "()V", "sharedIndexLock", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/util/io/StorageLockContext;", "withReadWriteStorageLock", "T", "chunkId", "operation", "Lkotlin/Function0;", "(ILkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.indexing.shared"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final <T> T withReadWriteStorageLock(int chunkId, @NotNull Function0<? extends T> operation) {
            Intrinsics.checkNotNullParameter(operation, (String)"operation");
            if (PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.get() != null) {
                throw new AssertionError((Object)"reentrant storage lock option set-up");
            }
            try {
                PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.set(sharedIndexLock.computeIfAbsent(chunkId, arg_0 -> Companion.withReadWriteStorageLock$lambda$1(Companion::withReadWriteStorageLock$lambda$0, arg_0)));
                Object object = operation.invoke();
                return (T)object;
            }
            finally {
                PagedFileStorage.THREAD_LOCAL_STORAGE_LOCK_CONTEXT.remove();
            }
        }

        private static final StorageLockContext withReadWriteStorageLock$lambda$0(Integer it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new StorageLockContext(true, false);
        }

        private static final StorageLockContext withReadWriteStorageLock$lambda$1(Function1 $tmp0, Object p0) {
            return (StorageLockContext)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B#\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R,\u0010\n\u001a\u001a\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndex$Empty;", "K", "V", "Lcom/intellij/indexing/shared/platform/impl/SharedIndex;", "indexName", "Lcom/intellij/util/indexing/ID;", "chunkId", "", "<init>", "(Lcom/intellij/util/indexing/ID;I)V", "index", "Lcom/intellij/util/indexing/UpdatableIndex;", "Lcom/intellij/util/indexing/FileContent;", "Ljava/lang/Void;", "getIndex", "()Lcom/intellij/util/indexing/UpdatableIndex;", "toString", "", "intellij.indexing.shared"})
    public static final class Empty<K, V>
    extends SharedIndex<K, V> {
        public Empty(@NotNull ID<K, V> indexName, int chunkId) {
            Intrinsics.checkNotNullParameter(indexName, (String)"indexName");
            super(indexName, chunkId, null);
        }

        @Override
        @NotNull
        public UpdatableIndex<K, V, FileContent, Void> getIndex() {
            EmptyIndex emptyIndex = EmptyIndex.getInstance();
            Intrinsics.checkNotNullExpressionValue(emptyIndex, (String)"getInstance(...)");
            return emptyIndex;
        }

        @NotNull
        public String toString() {
            return "EmptySharedIndexChunk[" + this.getIndexName() + ": #" + this.getChunkId() + "]";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B[\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\n\u0010\u0016\u001a\u00020\u0017H\u0096\u0080\u0004R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndex$Impl;", "K", "V", "Lcom/intellij/indexing/shared/platform/impl/SharedIndex;", "indexLocation", "Lcom/intellij/indexing/shared/platform/api/layout/SharedIndexLocation;", "indexId", "Lcom/intellij/util/indexing/ID;", "chunkId", "", "originalExtension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "hashIndex", "Lcom/intellij/indexing/shared/platform/impl/FileContentHashIndex;", "chunkVersion", "Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;", "<init>", "(Lcom/intellij/indexing/shared/platform/api/layout/SharedIndexLocation;Lcom/intellij/util/indexing/ID;ILcom/intellij/util/indexing/FileBasedIndexExtension;Lcom/intellij/indexing/shared/platform/impl/FileContentHashIndex;Lcom/intellij/indexing/shared/platform/api/SharedIndexInfrastructureVersion;)V", "index", "Lcom/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex;", "getIndex", "()Lcom/intellij/indexing/shared/platform/impl/HashBasedMapReduceIndex;", "toString", "", "intellij.indexing.shared"})
    @SourceDebugExtension(value={"SMAP\nSharedIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndex.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndex$Impl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n23#2:93\n*S KotlinDebug\n*F\n+ 1 SharedIndex.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndex$Impl\n*L\n36#1:93\n*E\n"})
    public static final class Impl<K, V>
    extends SharedIndex<K, V> {
        @NotNull
        private final SharedIndexLocation<K, V> indexLocation;
        @NotNull
        private final FileBasedIndexExtension<K, V> originalExtension;
        @NotNull
        private final FileContentHashIndex hashIndex;
        @NotNull
        private final SharedIndexInfrastructureVersion chunkVersion;
        @NotNull
        private final HashBasedMapReduceIndex<K, V> index;

        public Impl(@NotNull SharedIndexLocation<K, V> indexLocation, @NotNull ID<K, V> indexId, int chunkId, @NotNull FileBasedIndexExtension<K, V> originalExtension, @NotNull FileContentHashIndex hashIndex, @NotNull SharedIndexInfrastructureVersion chunkVersion) {
            Intrinsics.checkNotNullParameter(indexLocation, (String)"indexLocation");
            Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
            Intrinsics.checkNotNullParameter(originalExtension, (String)"originalExtension");
            Intrinsics.checkNotNullParameter((Object)((Object)hashIndex), (String)"hashIndex");
            Intrinsics.checkNotNullParameter((Object)((Object)chunkVersion), (String)"chunkVersion");
            super(indexId, chunkId, null);
            this.indexLocation = indexLocation;
            this.originalExtension = originalExtension;
            this.hashIndex = hashIndex;
            this.chunkVersion = chunkVersion;
            if (Intrinsics.areEqual(indexId, (Object)StubUpdatingIndex.INDEX_ID)) {
                Impl $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(Impl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.assertTrue(this.indexLocation instanceof SharedStubIndexLocation);
            }
            this.index = (HashBasedMapReduceIndex)((Object)Companion.withReadWriteStorageLock(chunkId, () -> Impl.index$lambda$0(this, chunkId)));
        }

        @NotNull
        public HashBasedMapReduceIndex<K, V> getIndex() {
            return this.index;
        }

        @NotNull
        public String toString() {
            return "SharedIndexChunk[" + this.getIndexName() + ": #" + this.getChunkId() + "][" + this.indexLocation + "]";
        }

        private static final long index$lambda$0$0(Impl this$0) {
            return this$0.hashIndex.getModificationStamp();
        }

        private static final HashBasedMapReduceIndex index$lambda$0(Impl this$0, int $chunkId) {
            return new HashBasedMapReduceIndex(this$0.indexLocation, SharedIndexExtension.findExtensionAndOpen(this$0.originalExtension, this$0.indexLocation, true, this$0.chunkVersion), this$0.hashIndex.getHashIdToFileIdsFunction($chunkId), () -> Impl.index$lambda$0$0(this$0));
        }
    }
}

