/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacroProtocolHolder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplacePathToMacroMap
extends PathMacroMap {
    private List<String> pathIndex;
    private final List<String> prefixes;
    private final Map<String, String> myMacroMap;

    public ReplacePathToMacroMap() {
        this.pathIndex = null;
        this.myMacroMap = new LinkedHashMap<String, String>();
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            PathMacroProtocolHolder.loadAppExtensions$intellij_platform_projectModel_impl(app);
        }
        this.prefixes = ContainerUtil.map(PathMacroProtocolHolder.getProtocols(), protocol -> protocol + ":");
    }

    public ReplacePathToMacroMap(@NotNull ReplacePathToMacroMap map) {
        if (map == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(0);
        }
        this();
        this.myMacroMap.putAll(map.myMacroMap);
    }

    public void addMacroReplacement(String path, String macroName) {
        this.addReplacement(FileUtilRt.toSystemIndependentName((String)path), "$" + macroName + "$", true);
    }

    public void addReplacement(String path, String macroExpr, boolean overwrite) {
        this.putIfAbsent(Strings.trimEnd((String)path, (String)"/"), macroExpr, overwrite);
    }

    private void putIfAbsent(String path, String substitution, boolean overwrite) {
        if (overwrite || !this.myMacroMap.containsKey(path)) {
            this.myMacroMap.put(path, substitution);
        }
    }

    @NotNull
    public String substitute(@NotNull String text, boolean caseSensitive) {
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(1);
        }
        for (String path : this.getPathIndex()) {
            text = this.replacePathMacro(text, path, caseSensitive);
        }
        String string = text;
        if (string == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private String replacePathMacro(@NotNull String text, @NotNull String path, boolean caseSensitive) {
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(3);
        }
        if (path == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(4);
        }
        if (text.length() < path.length() || path.isEmpty()) {
            String string = text;
            if (string == null) {
                ReplacePathToMacroMap.$$$reportNull$$$0(5);
            }
            return string;
        }
        String prefix = this.matchPrefix(text, path, caseSensitive);
        if (prefix == null) {
            String string = text;
            if (string == null) {
                ReplacePathToMacroMap.$$$reportNull$$$0(6);
            }
            return string;
        }
        int endOfOccurrence = prefix.length() + path.length();
        boolean isWindowsRoot = path.endsWith(":/");
        if (!(isWindowsRoot || endOfOccurrence >= text.length() || text.charAt(endOfOccurrence) == '/' || text.charAt(endOfOccurrence) == '!' && text.substring(endOfOccurrence).startsWith("!/"))) {
            String string = text;
            if (string == null) {
                ReplacePathToMacroMap.$$$reportNull$$$0(7);
            }
            return string;
        }
        String s = this.myMacroMap.get(path);
        if (text.length() > endOfOccurrence) {
            String string = prefix + s + text.substring(endOfOccurrence);
            if (string == null) {
                ReplacePathToMacroMap.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = prefix + s;
        if (string == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    private String matchPrefix(String text, String path, boolean caseSensitive) {
        if (ReplacePathToMacroMap.startsWith(text, path, caseSensitive, 0)) {
            return "";
        }
        for (String prefix : this.prefixes) {
            if (!ReplacePathToMacroMap.startsWith(text, prefix, caseSensitive, 0)) continue;
            int prefixLength = prefix.length();
            if (ReplacePathToMacroMap.startsWith(text, path, caseSensitive, prefixLength)) {
                return prefix;
            }
            if (text.length() > prefixLength && text.charAt(prefixLength) == '/') {
                if (ReplacePathToMacroMap.startsWith(text, path, caseSensitive, prefixLength + 1)) {
                    return text.substring(0, prefixLength + 1);
                }
                if (text.length() > prefixLength + 1 && text.charAt(prefixLength + 1) == '/' && ReplacePathToMacroMap.startsWith(text, path, caseSensitive, prefixLength + 2)) {
                    return text.substring(0, prefixLength + 2);
                }
            }
            return null;
        }
        return null;
    }

    private static boolean startsWith(@NotNull String text, @NotNull String path, boolean caseSensitive, int offset) {
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(10);
        }
        if (path == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(11);
        }
        return caseSensitive ? text.startsWith(path, offset) : StringUtilRt.startsWithIgnoreCase((String)text, (int)offset, (String)path);
    }

    @NotNull
    public CharSequence substituteRecursively(@NotNull String text, boolean caseSensitive) {
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(12);
        }
        CharSequence result = text;
        for (String path : this.getPathIndex()) {
            result = this.replacePathMacroRecursively(result, path, caseSensitive);
        }
        String string = result;
        if (string == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(13);
        }
        return string;
    }

    private CharSequence replacePathMacroRecursively(@NotNull CharSequence text, @NotNull String path, boolean caseSensitive) {
        if (text == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(14);
        }
        if (path == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(15);
        }
        if (text.length() < path.length() || path.isEmpty()) {
            return text;
        }
        StringBuilder newText = new StringBuilder();
        boolean isWindowsRoot = path.endsWith(":/");
        int i = 0;
        while (i < text.length()) {
            int occurrenceOfPath;
            int n = occurrenceOfPath = caseSensitive ? Strings.indexOf((CharSequence)text, (CharSequence)path, (int)i) : Strings.indexOfIgnoreCase((CharSequence)text, (CharSequence)path, (int)i);
            if (occurrenceOfPath >= 0) {
                char prev;
                int endOfOccurrence = occurrenceOfPath + path.length();
                if (!isWindowsRoot && endOfOccurrence < text.length() && text.charAt(endOfOccurrence) != '/' && text.charAt(endOfOccurrence) != '\"' && text.charAt(endOfOccurrence) != ' ' && !Strings.startsWith((CharSequence)text, (int)endOfOccurrence, (CharSequence)"!/")) {
                    newText.append(text, i, endOfOccurrence);
                    i = endOfOccurrence;
                    continue;
                }
                if (occurrenceOfPath > 0 && (Character.isLetterOrDigit(prev = text.charAt(occurrenceOfPath - 1)) || prev == '_')) {
                    newText.append(text, i, endOfOccurrence);
                    i = endOfOccurrence;
                    continue;
                }
            }
            if (occurrenceOfPath < 0) {
                if (newText.isEmpty()) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            newText.append(text, i, occurrenceOfPath);
            newText.append(this.myMacroMap.get(path));
            i = occurrenceOfPath + path.length();
        }
        return newText;
    }

    private static int getIndex(@NotNull String replacement) {
        if (replacement == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(16);
        }
        if (replacement.contains("..") || replacement.contains("$USER_HOME$") || replacement.contains("$APPLICATION_HOME_DIR$") || replacement.contains("$MAVEN_REPOSITORY$")) {
            return 1;
        }
        if (replacement.contains("$MODULE_DIR$") || replacement.contains("$PROJECT_DIR$")) {
            return 3;
        }
        return 2;
    }

    private static int stripPrefix(@NotNull String key) {
        if (key == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(17);
        }
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        return key.length();
    }

    @NotNull
    private List<String> getPathIndex() {
        if (this.pathIndex != null && this.pathIndex.size() == this.myMacroMap.size()) {
            List<String> list = this.pathIndex;
            if (list == null) {
                ReplacePathToMacroMap.$$$reportNull$$$0(18);
            }
            return list;
        }
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.myMacroMap.entrySet());
        Object2IntOpenHashMap weights = new Object2IntOpenHashMap(entries.size());
        for (Map.Entry entry2 : entries) {
            weights.put((Object)((String)entry2.getKey()), ReplacePathToMacroMap.getIndex((String)entry2.getValue()) * 512 + ReplacePathToMacroMap.stripPrefix((String)entry2.getKey()));
        }
        entries.sort((arg_0, arg_1) -> ReplacePathToMacroMap.lambda$getPathIndex$1((Object2IntMap)weights, arg_0, arg_1));
        this.pathIndex = ContainerUtil.map(entries, entry -> (String)entry.getKey());
        List<String> list = this.pathIndex;
        if (list == null) {
            ReplacePathToMacroMap.$$$reportNull$$$0(19);
        }
        return list;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplacePathToMacroMap)) {
            return false;
        }
        return this.myMacroMap.equals(((ReplacePathToMacroMap)((Object)obj)).myMacroMap);
    }

    public int hashCode() {
        return this.myMacroMap.hashCode();
    }

    public void put(String path, String replacement) {
        this.myMacroMap.put(path, replacement);
    }

    public String toString() {
        return "macroMap: " + String.valueOf(this.myMacroMap) + "\n\npathsIndex: " + StringUtil.join(this.pathIndex, (String)"\n");
    }

    private static /* synthetic */ int lambda$getPathIndex$1(Object2IntMap weights, Map.Entry o1, Map.Entry o2) {
        return weights.getInt(o2.getKey()) - weights.getInt(o1.getKey());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 9, 13, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 3: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/ReplacePathToMacroMap";
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/ReplacePathToMacroMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "replacePathMacro";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteRecursively";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 18: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMacro";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "substituteRecursively";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replacePathMacroRecursively";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 8, 9, 13, 18, 19 -> new IllegalStateException(string);
        };
    }
}

