/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class ProjectRootUtil {
    private static final Logger LOG = Logger.getInstance(ProjectRootUtil.class);

    private ProjectRootUtil() {
    }

    private static PsiDirectory @NotNull [] convertRoots(@NotNull Project project, VirtualFile @NotNull [] roots) {
        if (project == null) {
            ProjectRootUtil.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            ProjectRootUtil.$$$reportNull$$$0(1);
        }
        return ProjectRootUtil.convertRoots(PsiManagerEx.getInstanceEx((Project)project).getFileManager(), roots);
    }

    private static PsiDirectory @NotNull [] convertRoots(@NotNull FileManager fileManager, VirtualFile @NotNull [] roots) {
        if (fileManager == null) {
            ProjectRootUtil.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            ProjectRootUtil.$$$reportNull$$$0(3);
        }
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile root : roots) {
            PsiDirectory dir;
            if (!root.isValid()) {
                LOG.error("Root " + String.valueOf(root) + " is not valid!");
            }
            if ((dir = fileManager.findDirectory(root)) == null) continue;
            dirs.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = dirs.toArray(PsiDirectory.EMPTY_ARRAY);
        if (psiDirectoryArray == null) {
            ProjectRootUtil.$$$reportNull$$$0(4);
        }
        return psiDirectoryArray;
    }

    public static PsiDirectory @NotNull [] getSourceRootDirectories(@NotNull Project project) {
        if (project == null) {
            ProjectRootUtil.$$$reportNull$$$0(5);
        }
        VirtualFile[] files = OrderEnumerator.orderEntries((Project)project).sources().usingCache().getRoots();
        return ProjectRootUtil.convertRoots(project, files);
    }

    public static PsiDirectory @NotNull [] getAllContentRoots(@NotNull Project project) {
        if (project == null) {
            ProjectRootUtil.$$$reportNull$$$0(6);
        }
        VirtualFile[] files = ProjectRootManager.getInstance((Project)project).getContentRootsFromAllModules();
        return ProjectRootUtil.convertRoots(project, files);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/ProjectRootUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectRootUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertRoots";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllContentRoots";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

