/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.CredentialStoreManager;
import com.intellij.credentialStore.PasswordSafeOptions;
import com.intellij.credentialStore.PasswordSafeSettingsListener;
import com.intellij.credentialStore.ProviderType;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PasswordSafe", storages={@Storage(value="security.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false, category=SettingsCategory.SYSTEM, exportable=true)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/intellij/credentialStore/PasswordSafeSettings;", "Lcom/intellij/openapi/components/PersistentStateComponentWithModificationTracker;", "Lcom/intellij/credentialStore/PasswordSafeOptions;", "<init>", "()V", "state", "value", "", "keepassDb", "getKeepassDb", "()Ljava/lang/String;", "setKeepassDb", "(Ljava/lang/String;)V", "Lcom/intellij/credentialStore/ProviderType;", "providerType", "getProviderType", "()Lcom/intellij/credentialStore/ProviderType;", "setProviderType", "(Lcom/intellij/credentialStore/ProviderType;)V", "getState", "loadState", "", "getStateModificationCount", "", "Companion", "intellij.platform.credentialStore.impl"})
@ApiStatus.Internal
public final class PasswordSafeSettings
implements PersistentStateComponentWithModificationTracker<PasswordSafeOptions> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PasswordSafeOptions state = new PasswordSafeOptions();
    @JvmField
    @Topic.AppLevel
    @NotNull
    public static final Topic<PasswordSafeSettingsListener> TOPIC;

    @Nullable
    public final String getKeepassDb() {
        String result = this.state.getKeepassDb();
        return result == null && this.getProviderType() == ProviderType.KEEPASS ? ((Object)KeePassCredentialStoreKt.getDefaultDbFile()).toString() : result;
    }

    public final void setKeepassDb(@Nullable String value) {
        String v = StringKt.nullize((String)value, (boolean)true);
        if (v != null && Intrinsics.areEqual((Object)v, (Object)((Object)KeePassCredentialStoreKt.getDefaultDbFile()).toString())) {
            v = null;
        }
        this.state.setKeepassDb(v);
    }

    @NotNull
    public final ProviderType getProviderType() {
        return SystemInfo.isWindows && this.state.getProvider() == ProviderType.KEYCHAIN ? ProviderType.KEEPASS : this.state.getProvider();
    }

    public final void setProviderType(@NotNull ProviderType value) {
        block2: {
            ProviderType oldValue;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ProviderType newValue = value;
            if (newValue == ProviderType.DO_NOT_STORE) {
                newValue = ProviderType.MEMORY_ONLY;
            }
            if (newValue == (oldValue = this.state.getProvider()) || !CredentialStoreManager.Companion.getInstance().isSupported(newValue)) break block2;
            this.state.setProvider(newValue);
            Object object = ApplicationManager.getApplication();
            if (object != null && (object = object.getMessageBus()) != null && (object = (PasswordSafeSettingsListener)object.syncPublisher(TOPIC)) != null) {
                object.typeChanged(oldValue, newValue);
            }
        }
    }

    @NotNull
    public PasswordSafeOptions getState() {
        return this.state;
    }

    public void loadState(@NotNull PasswordSafeOptions state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        CredentialStoreManager credentialStoreManager = CredentialStoreManager.Companion.getInstance();
        if (state.getProvider() == ProviderType.DO_NOT_STORE && !credentialStoreManager.isSupported(ProviderType.MEMORY_ONLY) || state.getProvider() != ProviderType.DO_NOT_STORE && !credentialStoreManager.isSupported(state.getProvider())) {
            CredentialStoreKt.getLOG().error("Provider " + state.getProvider() + " from loaded credential store config is not supported in this environment");
        }
        this.state = state;
        this.setProviderType(state.getProvider());
        state.setKeepassDb(StringKt.nullize((String)state.getKeepassDb(), (boolean)true));
    }

    public long getStateModificationCount() {
        return this.state.getModificationCount();
    }

    static {
        Topic<PasswordSafeSettingsListener> topic = PasswordSafeSettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        TOPIC = topic;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/credentialStore/PasswordSafeSettings$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/credentialStore/PasswordSafeSettingsListener;", "intellij.platform.credentialStore.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

