/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeEditingManager;
import com.intellij.diagram.components.DiagramNodeContainer;
import com.intellij.diagram.components.DiagramNodeHeaderComponent;
import com.intellij.diagram.components.DiagramNodeItemComponent;
import com.intellij.diagram.components.DiagramNodeQuickDocHintManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.components.BaseGraphStructureViewBuilder;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PopupMode;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramNodeBodyComponent
extends JBList<Object>
implements ListCellRenderer<Object> {
    @NotNull
    private static final Key<Integer> SELECTED_ITEM_INDEX_ON_LAST_FOCUS_KEY = Key.create((String)"com.intellij.diagram.components.DiagramNodeBodyComponent#SELECTED_ITEM_INDEX_ON_LAST_FOCUS_KEY");
    @NotNull
    private static final JComponent OUR_SEPARATOR_COMPONENT = new JPanel();
    @NotNull
    private final DiagramNodeItemComponent myItemComponent;
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private final DiagramNode myNode;
    @NotNull
    private final MyQuickDocHintManager myQuickDocHintManager;

    public DiagramNodeBodyComponent(@NotNull DiagramNode node, @NotNull DiagramBuilder builder) {
        if (node == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(1);
        }
        super(DiagramNodeBodyComponent.getNodeItems(node, builder));
        this.myItemComponent = new DiagramNodeItemComponent();
        this.myNode = node;
        this.myBuilder = builder;
        this.myQuickDocHintManager = new MyQuickDocHintManager(node, builder);
        this.setCellRenderer(this);
        this.setOpaque(true);
        this.setExpandableItemsEnabled(false);
        this.disableEmptyText();
        this.setupMouseListeners();
        this.setupPopupMenu();
    }

    private static Object @NotNull [] getNodeItems(DiagramNode<?> node, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(2);
        }
        Object[] objectArray = BaseGraphStructureViewBuilder.isCompactNodeDisplayModeEnabledFor(builder.getGraphBuilder()) ? ArrayUtil.EMPTY_OBJECT_ARRAY : (Object[])WriteIntentReadAction.compute(() -> DiagramElementManager.getNodeItemsAccordingToCurrentContentSettings(node, builder));
        if (objectArray == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    private void setupPopupMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Uml.NodeCellEditorPopup");
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("StructureViewPopup", group);
        this.setComponentPopupMenu(menu.getComponent());
        menu.setTargetComponent((JComponent)((Object)this));
        menu.getComponent().addPopupMenuListener(new MyPopupMenuListener());
    }

    @NotNull
    protected DiagramNodeContainer getContainerComponent() {
        DiagramNodeContainer diagramNodeContainer = Objects.requireNonNull((DiagramNodeContainer)((Object)ComponentUtil.getParentOfType(DiagramNodeContainer.class, (Component)((Object)this))));
        if (diagramNodeContainer == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(4);
        }
        return diagramNodeContainer;
    }

    @NotNull
    protected DiagramNodeHeaderComponent getNodeHeaderComponent() {
        DiagramNodeHeaderComponent diagramNodeHeaderComponent = (DiagramNodeHeaderComponent)((Object)ComponentUtil.findComponentsOfType((JComponent)((Object)this.getContainerComponent()), DiagramNodeHeaderComponent.class).stream().findFirst().orElseThrow());
        if (diagramNodeHeaderComponent == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(5);
        }
        return diagramNodeHeaderComponent;
    }

    protected void selectItemOnPoint(@NotNull Point p) {
        if (p == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(6);
        }
        if (DiagramNodeEditingManager.getInstance().getCurrentEditorComponent() == this.getContainerComponent().getParent()) {
            this.setSelectedIndex(this.locationToIndex(p));
        }
    }

    protected void setupMouseListeners() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DiagramNodeBodyComponent.this.selectItemOnPoint(e.getPoint());
                DiagramNodeBodyComponent.this.myQuickDocHintManager.onMouseMoved(e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagram/components/DiagramNodeBodyComponent$1", "mouseMoved"));
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DiagramNodeBodyComponent.this.selectItemOnPoint(e.getPoint());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DiagramNodeBodyComponent.this.myQuickDocHintManager.onMouseExited(e);
            }
        });
    }

    public int locationToIndex(Point location) {
        Dimension size = this.getSize();
        if (0 > location.x || !((double)location.x <= size.getWidth()) || 0 > location.y || !((double)location.y <= size.getHeight())) {
            return -1;
        }
        return super.locationToIndex(location);
    }

    @NotNull
    public Rectangle getItemBounds(int itemIndex, boolean doIgnoreSeparators) {
        if (doIgnoreSeparators) {
            itemIndex = (int)((long)itemIndex - IntStream.range(0, itemIndex).filter(it -> this.getModel().getElementAt(it) == null).count());
        }
        Component itemComponent = this.getListCellRendererComponent((JList)((Object)this), this.getModel().getElementAt(itemIndex), itemIndex, true, false);
        int itemHeight = itemComponent.getPreferredSize().height;
        int itemWidth = this.getContainerComponent().getPreferredSize().width + 1;
        int itemVerticalOffset = this.getNodeHeaderComponent().getPreferredSize().height + Math.max(0, itemIndex) * itemHeight;
        return new Rectangle(0, itemVerticalOffset, itemWidth, itemHeight);
    }

    public Dimension getPreferredSize() {
        return this.super_getPreferredSize();
    }

    @Override
    public Component getListCellRendererComponent(JList list, @Nullable Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return this.getSeparatorComponent();
        }
        boolean isSelectedWithoutFocus = Objects.equals(this.myNode.getUserData(SELECTED_ITEM_INDEX_ON_LAST_FOCUS_KEY), index);
        this.myItemComponent.setSelected(isSelected || isSelectedWithoutFocus);
        this.myItemComponent.setUp(this, this.myBuilder, this.myNode, value, isSelected || isSelectedWithoutFocus);
        if (isSelectedWithoutFocus) {
            this.myItemComponent.setForcedBackground(UIUtil.getListSelectionBackground((boolean)false));
            this.myItemComponent.setForeground(NamedColorUtil.getListSelectionForeground((boolean)false));
            this.invalidateParentContainerRenderCache();
        }
        return this.myItemComponent;
    }

    @NotNull
    private JComponent getSeparatorComponent() {
        OUR_SEPARATOR_COMPONENT.setBackground(this.getSeparatorColor());
        Dimension size = new Dimension(-1, Math.max((int)Math.ceil(1.0 / (2.0 * this.myBuilder.getView().getZoom())), 1));
        OUR_SEPARATOR_COMPONENT.setPreferredSize(size);
        OUR_SEPARATOR_COMPONENT.setMaximumSize(size);
        JComponent jComponent = OUR_SEPARATOR_COMPONENT;
        if (jComponent == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @NotNull
    public Point getPopupLocation(@NotNull MouseEvent event) {
        if (event == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(8);
        }
        NodeRealizer realizer = this.myBuilder.getGraph().getRealizer(this.myBuilder.getNode(this.myNode));
        Graph2DView view = this.myBuilder.getView();
        return new Point(view.toViewCoordX(realizer.getX()) + (int)((double)event.getX() * view.getZoom()) + 10, view.toViewCoordY(realizer.getY()) + (int)((double)event.getY() * view.getZoom()));
    }

    @NotNull
    protected Color getSeparatorColor() {
        boolean isSelectedByUser = this.myBuilder.getGraph().isSelected(this.myBuilder.getNode(this.myNode));
        Color color = this.myBuilder.getProvider().getColorManager().getNodeBorderColor(this.myBuilder, this.myNode, isSelectedByUser);
        if (color == null) {
            DiagramNodeBodyComponent.$$$reportNull$$$0(9);
        }
        return color;
    }

    private void invalidateParentContainerRenderCache() {
        DiagramNodeContainer container = (DiagramNodeContainer)((Object)ComponentUtil.getParentOfType(DiagramNodeContainer.class, (Component)((Object)this)));
        if (container != null) {
            container.invalidateRenderCacheForAllRealizersOfThisNode();
            this.myBuilder.getView().updateView();
        }
    }

    public boolean isShowing() {
        return this.myBuilder.getGraph().getRealizer(this.myBuilder.getNode(this.myNode)).isVisible();
    }

    public JPopupMenu getComponentPopupMenu() {
        AWTEvent event = EventQueue.getCurrentEvent();
        if (event instanceof MouseEvent && ((MouseEvent)event).isPopupTrigger() && event.getSource() == this) {
            this.selectItemOnPoint(((MouseEvent)event).getPoint());
        }
        return super.getComponentPopupMenu();
    }

    static {
        OUR_SEPARATOR_COMPONENT.setBackground((Color)JBColor.GRAY);
        OUR_SEPARATOR_COMPONENT.setPreferredSize(new Dimension(-1, 1));
        OUR_SEPARATOR_COMPONENT.putClientProperty("IgnoreListRowHeight", Boolean.TRUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/DiagramNodeBodyComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/DiagramNodeBodyComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeHeaderComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparatorColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeItems";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectItemOnPoint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPopupLocation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 9 -> new IllegalStateException(string);
        };
    }

    protected class MyQuickDocHintManager
    extends DiagramNodeQuickDocHintManager {
        MyQuickDocHintManager(@NotNull DiagramNode<?> node, DiagramBuilder builder) {
            if (node == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(0);
            }
            if (builder == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(1);
            }
            super(node, builder);
        }

        @Override
        protected Object getDocOwnerFor(@NotNull MouseEvent event) {
            if (event == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(2);
            }
            Point eventPoint = event.getComponent() instanceof DiagramNodeBodyComponent ? event.getPoint() : this.convertCanvasPointToThisComponentPoint(event.getPoint());
            int itemIndex = DiagramNodeBodyComponent.this.locationToIndex(eventPoint);
            DiagramElementManager<?> elementManager = this.getBuilder().getProvider().getElementManager();
            return itemIndex != -1 ? elementManager.getItemDocOwner(DiagramNodeBodyComponent.this.getModel().getElementAt(itemIndex), this.getBuilder()) : null;
        }

        @Override
        @NotNull
        protected Rectangle getDocOwnerBounds(Object docOwner) {
            ListModel model = DiagramNodeBodyComponent.this.getModel();
            DiagramElementManager<?> elementManager = this.getBuilder().getProvider().getElementManager();
            for (int i = 0; i < model.getSize(); ++i) {
                if (elementManager.getItemDocOwner(model.getElementAt(i), this.getBuilder()) != docOwner) continue;
                Rectangle rectangle = DiagramNodeBodyComponent.this.getItemBounds(i, true);
                if (rectangle == null) {
                    MyQuickDocHintManager.$$$reportNull$$$0(3);
                }
                return rectangle;
            }
            throw new NoSuchElementException();
        }

        @NotNull
        private Point convertCanvasPointToThisComponentPoint(@NotNull Point canvasPoint) {
            if (canvasPoint == null) {
                MyQuickDocHintManager.$$$reportNull$$$0(4);
            }
            Point nodeCanvasCoords = GraphCanvasLocationService.getInstance().getNodeCoordinatesOnCanvas(Objects.requireNonNull(this.getBuilder().getNode(this.getNode())), this.getBuilder().getGraphBuilder());
            double zoom = this.getBuilder().getView().getZoom();
            return new Point((int)((double)(canvasPoint.x - nodeCanvasCoords.x) / zoom), (int)(((double)(canvasPoint.y - nodeCanvasCoords.y) - DiagramNodeBodyComponent.this.getNodeHeaderComponent().getPreferredSize().getHeight() * zoom) / zoom));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/components/DiagramNodeBodyComponent$MyQuickDocHintManager";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "canvasPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/components/DiagramNodeBodyComponent$MyQuickDocHintManager";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocOwnerBounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDocOwnerFor";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertCanvasPointToThisComponentPoint";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    protected class MyPopupMenuListener
    implements PopupMenuListener {
        protected MyPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            DiagramNodeBodyComponent.this.myBuilder.putUserData(PopupMode.IS_POPUP_ACTIVE_KEY, Boolean.TRUE);
            ApplicationManager.getApplication().invokeLater(() -> {
                CellEditorMode editNodeMode = (CellEditorMode)DiagramNodeBodyComponent.this.myBuilder.getGraphBuilder().getEditMode().getEditNodeMode();
                editNodeMode.stopCellEditing();
                DiagramNodeBodyComponent.this.myNode.putUserData(SELECTED_ITEM_INDEX_ON_LAST_FOCUS_KEY, DiagramNodeBodyComponent.this.getSelectedIndex());
                DiagramNodeBodyComponent.this.invalidateParentContainerRenderCache();
            });
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            DiagramNodeBodyComponent.this.myNode.putUserData(SELECTED_ITEM_INDEX_ON_LAST_FOCUS_KEY, null);
            DiagramNodeBodyComponent.this.myBuilder.putUserData(PopupMode.IS_POPUP_ACTIVE_KEY, null);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.popupMenuWillBecomeInvisible(e);
            EditMode editMode = DiagramNodeBodyComponent.this.myBuilder.getGraphBuilder().getEditMode();
            if (!((CellEditorMode)editMode.getEditNodeMode()).isCellEditing()) {
                Node node = DiagramNodeBodyComponent.this.myBuilder.getNode(DiagramNodeBodyComponent.this.myNode);
                editMode.editNode(node, null);
                Optional.ofNullable(DiagramNodeEditingManager.getInstance().getCurrentNodeEditor()).map(it -> it.getNodeCellEditorComponent(DiagramNodeBodyComponent.this.myBuilder.getView(), DiagramNodeBodyComponent.this.myBuilder.getGraph().getRealizer(node), null, true)).flatMap(it -> ComponentUtil.findComponentsOfType((JComponent)it, DiagramNodeBodyComponent.class).stream().findFirst()).ifPresent(it -> {
                    it.requestFocusInWindow();
                    it.repaint();
                });
            }
        }
    }
}

