/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramBuilderFactory;
import com.intellij.diagram.DiagramDataKeys;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.v2.GraphChartFactory;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.uml.EmptyDiagramProvider;
import com.intellij.uml.ReopenInfo;
import com.intellij.uml.UmlEditorProvider;
import com.intellij.uml.UmlFileEditorImpl;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.v2.GraphChartFactoryImpl;
import com.intellij.uml.v2.handles.GraphChartHandleImpl;
import com.intellij.uml.v2.oldapiadapters.GraphChartAdapterForDiagramElementManager;
import com.intellij.uml.v2.oldapiadapters.GraphChartAdapterForDiagramProvider;
import com.intellij.util.concurrency.EdtScheduler;
import java.io.IOException;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0004\u001a\u00060\fR\u00020\rH\u0002\u001a\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u000f\"\u0004\b\u0000\u0010\u00102\n\u0010\u0004\u001a\u00060\fR\u00020\rH\u0002\u001a\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0004\u001a\u00060\fR\u00020\rH\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00122\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017H\u0002\u001a2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0004\u001a\u00060\fR\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\t2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isNewUmlFormat", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isJourneyUmlFormat", "isOldUmlFormat", "getElementFromFile", "", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/uml/UmlVirtualFileSystem$UmlVirtualFile;", "Lcom/intellij/uml/UmlVirtualFileSystem;", "getProviderFromFile", "Lcom/intellij/diagram/DiagramProvider;", "T", "createEditorFromLocalFileSystem", "Lcom/intellij/openapi/fileEditor/FileEditor;", "createUnknownDiagramEmptyEditor", "createEditorFromPsiElement", "createEditorFromGraphChartBuilder", "chartBuilder", "Lcom/intellij/uml/v2/handles/GraphChartHandleImpl;", "getOrCreateBuilderForNewEditor", "Lcom/intellij/diagram/DiagramBuilder;", "originalElement", "provider", "intellij.diagram.impl"})
@SourceDebugExtension(value={"SMAP\nUmlEditorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UmlEditorProvider.kt\ncom/intellij/uml/UmlEditorProviderKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,337:1\n13#2:338\n*S KotlinDebug\n*F\n+ 1 UmlEditorProvider.kt\ncom/intellij/uml/UmlEditorProviderKt\n*L\n47#1:338\n*E\n"})
public final class UmlEditorProviderKt {
    @NotNull
    private static final Logger LOG;

    private static final boolean isNewUmlFormat(VirtualFile file) {
        try {
            String string = VfsUtilCore.loadText((VirtualFile)file, (int)100);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
            String beginning = string;
            return StringsKt.contains$default((CharSequence)beginning, (CharSequence)"<Diagramm>", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)beginning, (CharSequence)"<Diagram>", (boolean)false, (int)2, null);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private static final boolean isJourneyUmlFormat(VirtualFile file) {
        try {
            String string = VfsUtilCore.loadText((VirtualFile)file, (int)100);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
            String beginning = string;
            return StringsKt.contains$default((CharSequence)beginning, (CharSequence)"<ID>JOURNEY</ID>", (boolean)false, (int)2, null);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static final boolean isOldUmlFormat(VirtualFile file) {
        boolean bl;
        try {
            String string = VfsUtilCore.loadText((VirtualFile)file, (int)100);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
            bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"<ClassDiagramm>", (boolean)false, (int)2, null);
        }
        catch (Exception ignored) {
            bl = false;
        }
        return bl;
    }

    private static final Object getElementFromFile(Project project, UmlVirtualFileSystem.UmlVirtualFile file) {
        Object result;
        DiagramProvider umlProvider = file.getUmlProvider();
        String fileFqn = file.getFQN();
        Object v0 = result = umlProvider != null && fileFqn != null ? umlProvider.getVfsResolver().resolveElementByFQN(fileFqn, project) : null;
        if (result == null && umlProvider != null) {
            Object element = file.getUserData(DiagramDataKeys.ORIGINAL_ELEMENT);
            if (umlProvider.getElementManager().canBeBuiltFrom(element)) {
                if (!(element instanceof PsiElement)) {
                    return element;
                }
                PsiFile psiFile = ((PsiElement)element).getContainingFile();
                if (psiFile != null && ScratchUtil.isScratch((VirtualFile)psiFile.getVirtualFile())) {
                    return element;
                }
            }
        }
        return result;
    }

    private static final <T> DiagramProvider<T> getProviderFromFile(UmlVirtualFileSystem.UmlVirtualFile file) {
        DiagramProvider diagramProvider = file.getUmlProvider();
        if (diagramProvider == null) {
            return null;
        }
        DiagramProvider umlProvider = diagramProvider;
        try {
            Constructor<?> constructor = umlProvider.getClass().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object obj = constructor.newInstance(new Object[0]);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.intellij.diagram.DiagramProvider<T of com.intellij.uml.UmlEditorProviderKt.getProviderFromFile>");
            DiagramProvider provider = (DiagramProvider)obj;
            if (provider instanceof GraphChartAdapterForDiagramProvider) {
                DiagramElementManager<Object> diagramElementManager = ((GraphChartAdapterForDiagramProvider)provider).getElementManager();
                Intrinsics.checkNotNull(diagramElementManager, (String)"null cannot be cast to non-null type com.intellij.uml.v2.oldapiadapters.GraphChartAdapterForDiagramElementManager<kotlin.Any, kotlin.Any>");
                GraphChartAdapterForDiagramElementManager graphChartAdapterForDiagramElementManager = (GraphChartAdapterForDiagramElementManager)diagramElementManager;
                DiagramElementManager diagramElementManager2 = umlProvider.getElementManager();
                Intrinsics.checkNotNull(diagramElementManager2, (String)"null cannot be cast to non-null type com.intellij.uml.v2.oldapiadapters.GraphChartAdapterForDiagramElementManager<kotlin.Any, kotlin.Any>");
                graphChartAdapterForDiagramElementManager.setChart$intellij_diagram_impl(((GraphChartAdapterForDiagramElementManager)diagramElementManager2).getChart$intellij_diagram_impl());
            }
            return provider;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static final FileEditor createEditorFromLocalFileSystem(Project project, VirtualFile file) {
        try {
            DiagramState diagramState = DiagramState.read(file.getInputStream());
            Intrinsics.checkNotNullExpressionValue((Object)diagramState, (String)"read(...)");
            DiagramState state = diagramState;
            DiagramProvider diagramProvider = DiagramProvider.findByID(state.getProviderID());
            Intrinsics.checkNotNull(diagramProvider);
            DiagramProvider provider = diagramProvider;
            String originalFQN = state.getOriginalFQN();
            Object originalElement = originalFQN == null ? null : provider.getVfsResolver().resolveElementByFQN(originalFQN, project);
            DiagramBuilder builder = (DiagramBuilder)WriteAction.computeAndWait(() -> UmlEditorProviderKt.createEditorFromLocalFileSystem$lambda$0(project, provider, originalElement, file));
            UmlFileEditorImpl editor = new UmlFileEditorImpl(builder, file);
            builder.getDataModel().setModelInitializationFinished();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                editor.setUmlState(state);
            } else {
                DumbService.Companion.getInstance(project).runWhenSmart(() -> UmlEditorProviderKt.createEditorFromLocalFileSystem$lambda$1(editor, state));
            }
            return editor;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static final FileEditor createUnknownDiagramEmptyEditor(Project project, VirtualFile file) {
        DiagramBuilder builder = (DiagramBuilder)WriteAction.computeAndWait(() -> UmlEditorProviderKt.createUnknownDiagramEmptyEditor$lambda$0(project, file));
        return new UmlFileEditorImpl(builder, file);
    }

    private static final FileEditor createEditorFromPsiElement(Project project, UmlVirtualFileSystem.UmlVirtualFile file) {
        Object originalElement = UmlEditorProviderKt.getElementFromFile(project, file);
        if (originalElement instanceof GraphChartHandleImpl && file.getBuilder() == null) {
            return UmlEditorProviderKt.createEditorFromGraphChartBuilder((GraphChartHandleImpl)originalElement);
        }
        DiagramProvider providerFromFile = UmlEditorProviderKt.getProviderFromFile(file);
        DiagramProvider diagramProvider = providerFromFile;
        if (diagramProvider == null) {
            diagramProvider = new EmptyDiagramProvider();
        }
        DiagramProvider provider = diagramProvider;
        DiagramBuilder builder = UmlEditorProviderKt.getOrCreateBuilderForNewEditor(project, file, originalElement, provider);
        if (originalElement != null) {
            String title = provider.getElementManager().getElementTitle(originalElement);
            file.setPresentableName(title);
        }
        UmlFileEditorImpl editor = new UmlFileEditorImpl(builder, file);
        ReopenInfo.apply(file, builder, originalElement);
        return editor;
    }

    private static final FileEditor createEditorFromGraphChartBuilder(GraphChartHandleImpl<?, ?> chartBuilder) {
        GraphChartFactory graphChartFactory = GraphChartFactory.Companion.getInstance();
        Intrinsics.checkNotNull((Object)graphChartFactory, (String)"null cannot be cast to non-null type com.intellij.uml.v2.GraphChartFactoryImpl");
        Object object = ((GraphChartFactoryImpl)graphChartFactory).instantiateAndShowInEditorImmediately(chartBuilder).getSecond();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSecond(...)");
        return (FileEditor)object;
    }

    private static final DiagramBuilder getOrCreateBuilderForNewEditor(Project project, UmlVirtualFileSystem.UmlVirtualFile file, Object originalElement, DiagramProvider<?> provider) {
        DiagramBuilder builderFromFile = file.getBuilder();
        if (builderFromFile == null) {
            Object object = WriteAction.computeAndWait(() -> UmlEditorProviderKt.getOrCreateBuilderForNewEditor$lambda$0(project, provider, originalElement, file));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeAndWait(...)");
            return (DiagramBuilder)object;
        }
        if (builderFromFile.getEditor() == null) {
            return builderFromFile;
        }
        DiagramBuilder builder = (DiagramBuilder)WriteAction.computeAndWait(() -> UmlEditorProviderKt.getOrCreateBuilderForNewEditor$lambda$1(project, provider, originalElement, file));
        if (!ReopenInfo.isContains(file)) {
            ApplicationManager.getApplication().invokeLater(() -> UmlEditorProviderKt.getOrCreateBuilderForNewEditor$lambda$2(builderFromFile, builder, originalElement));
        }
        Intrinsics.checkNotNull((Object)builder);
        return builder;
    }

    private static final void createEditorFromLocalFileSystem$lambda$1$0(DiagramState $state, UmlFileEditorImpl $editor) {
        $state.restorePositionsOnlyTo($editor.getModelBuilder());
    }

    private static final DiagramBuilder createEditorFromLocalFileSystem$lambda$0(Project $project, DiagramProvider $provider, Object $originalElement, VirtualFile $file) {
        return DiagramBuilderFactory.getInstance().createBuilder($project, $provider, $originalElement, $file);
    }

    private static final void createEditorFromLocalFileSystem$lambda$1(UmlFileEditorImpl $editor, DiagramState $state) {
        $editor.setUmlState($state);
        EdtScheduler.Companion.getInstance().schedule-VtjQ1oo(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), () -> UmlEditorProviderKt.createEditorFromLocalFileSystem$lambda$1$0($state, $editor));
    }

    private static final DiagramBuilder createUnknownDiagramEmptyEditor$lambda$0(Project $project, VirtualFile $file) {
        return DiagramBuilderFactory.getInstance().create($project, new EmptyDiagramProvider(), null, $file);
    }

    private static final DiagramBuilder getOrCreateBuilderForNewEditor$lambda$0(Project $project, DiagramProvider $provider, Object $originalElement, UmlVirtualFileSystem.UmlVirtualFile $file) {
        return DiagramBuilderFactory.getInstance().create($project, $provider, $originalElement, $file);
    }

    private static final DiagramBuilder getOrCreateBuilderForNewEditor$lambda$1(Project $project, DiagramProvider $provider, Object $originalElement, UmlVirtualFileSystem.UmlVirtualFile $file) {
        return DiagramBuilderFactory.getInstance().create($project, $provider, $originalElement, $file);
    }

    private static final void getOrCreateBuilderForNewEditor$lambda$2(DiagramBuilder $builderFromFile, DiagramBuilder $builder, Object $originalElement) {
        ReopenInfo.apply($builderFromFile, $builder, $originalElement);
        $builder.queryUpdate().withDataReload().withRelayout().run();
        $builder.getGraphBuilder().fitContent(false);
    }

    public static final /* synthetic */ boolean access$isJourneyUmlFormat(VirtualFile file) {
        return UmlEditorProviderKt.isJourneyUmlFormat(file);
    }

    public static final /* synthetic */ boolean access$isNewUmlFormat(VirtualFile file) {
        return UmlEditorProviderKt.isNewUmlFormat(file);
    }

    public static final /* synthetic */ boolean access$isOldUmlFormat(VirtualFile file) {
        return UmlEditorProviderKt.isOldUmlFormat(file);
    }

    public static final /* synthetic */ Object access$getElementFromFile(Project project, UmlVirtualFileSystem.UmlVirtualFile file) {
        return UmlEditorProviderKt.getElementFromFile(project, file);
    }

    public static final /* synthetic */ FileEditor access$createEditorFromLocalFileSystem(Project project, VirtualFile file) {
        return UmlEditorProviderKt.createEditorFromLocalFileSystem(project, file);
    }

    public static final /* synthetic */ FileEditor access$createUnknownDiagramEmptyEditor(Project project, VirtualFile file) {
        return UmlEditorProviderKt.createUnknownDiagramEmptyEditor(project, file);
    }

    public static final /* synthetic */ FileEditor access$createEditorFromPsiElement(Project project, UmlVirtualFileSystem.UmlVirtualFile file) {
        return UmlEditorProviderKt.createEditorFromPsiElement(project, file);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UmlEditorProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

