/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.impl.CssImportImpl;
import com.intellij.psi.css.impl.stubs.CssImportStub;
import com.intellij.psi.css.impl.stubs.CssStubSerializingFactory;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00032\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00142\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/psi/css/impl/stubs/CssImportStubSerializingFactory;", "Lcom/intellij/psi/css/impl/stubs/CssStubSerializingFactory;", "Lcom/intellij/psi/css/impl/stubs/CssImportStub;", "Lcom/intellij/psi/css/CssImport;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "createPsi", "stub", "serialize", "", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "intellij.css.backend"})
public final class CssImportStubSerializingFactory
extends CssStubSerializingFactory<CssImportStub, CssImport> {
    public CssImportStubSerializingFactory(@NotNull IElementType elementType) {
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        super(elementType);
    }

    @NotNull
    public CssImportStub createStub(@NotNull CssImport psi, @Nullable StubElement<? extends PsiElement> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return new CssImportStub(CssResolveUtil.getUriStrings((CssImport)psi), psi.getParent() instanceof CssImportList, psi.getMediaTypes(), parentStub, this.getElementType());
    }

    @NotNull
    public CssImport createPsi(@NotNull CssImportStub stub) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        return (CssImport)new CssImportImpl(stub, this.getElementType());
    }

    public void serialize(@NotNull CssImportStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeUTFFast(StringUtil.join((String[])stub.getPaths(), (String)File.pathSeparator));
        dataStream.writeBoolean(stub.isFromImportList());
        CssIndexUtil.writeMediaTypes((StubOutputStream)dataStream, (Set)stub.getMediaTypes());
    }

    @NotNull
    public CssImportStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        List list = StringUtil.split((String)dataStream.readUTFFast(), (String)File.pathSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
        List paths = list;
        boolean fromImportList = dataStream.readBoolean();
        return new CssImportStub(ArrayUtilRt.toStringArray((Collection)paths), fromImportList, CssIndexUtil.readMediaTypes((StubInputStream)dataStream), parentStub, this.getElementType());
    }
}

