/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.FileHolderComposite;
import com.intellij.openapi.vcs.changes.FoldersCutDownWorker;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.LogicalLock;
import com.intellij.openapi.vcs.changes.SwitchedFileHolder;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class UpdatingChangeListBuilder
implements ChangelistBuilder {
    private static final Logger LOG = Logger.getInstance(UpdatingChangeListBuilder.class);
    @NotNull
    private final VcsDirtyScope myScope;
    @NotNull
    private final ChangeListWorker.ChangeListUpdater myChangeListUpdater;
    @NotNull
    private final FileHolderComposite myComposite;
    @NotNull
    private final Supplier<Boolean> myDisposedGetter;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final FoldersCutDownWorker myFoldersCutDownWorker;
    private final List<Supplier<@Nullable JComponent>> myAdditionalInfo;

    UpdatingChangeListBuilder(@NotNull VcsDirtyScope scope, @NotNull ChangeListWorker.ChangeListUpdater changeListUpdater, @NotNull FileHolderComposite composite, @NotNull Supplier<Boolean> disposedGetter) {
        if (scope == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(0);
        }
        if (changeListUpdater == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(1);
        }
        if (composite == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(2);
        }
        if (disposedGetter == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(3);
        }
        this.myAdditionalInfo = new ArrayList<Supplier<JComponent>>();
        this.myScope = scope;
        this.myChangeListUpdater = changeListUpdater;
        this.myComposite = composite;
        this.myDisposedGetter = disposedGetter;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)changeListUpdater.getProject());
        this.myFoldersCutDownWorker = new FoldersCutDownWorker();
    }

    private void checkIfDisposed() {
        if (this.myDisposedGetter.get().booleanValue()) {
            throw new ProcessCanceledException();
        }
    }

    public void processChange(@NotNull Change change, VcsKey vcsKey) {
        if (change == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(4);
        }
        this.processChangeInList(change, (ChangeList)null, vcsKey);
    }

    public void processChangeInList(@NotNull Change change, @Nullable ChangeList changeList, VcsKey vcsKey) {
        if (change == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(5);
        }
        this.checkIfDisposed();
        LOG.debug("[processChangeInList-1] entering, cl name: " + (changeList == null ? null : changeList.getName()) + " change: " + ChangesUtil.getFilePath((Change)change).getPath());
        String fileName = ChangesUtil.getFilePath((Change)change).getName();
        if (FileTypeManager.getInstance().isFileIgnored(fileName)) {
            LOG.debug("[processChangeInList-1] file type ignored");
            return;
        }
        if (ChangeListManagerImpl.isUnder(change, this.myScope)) {
            AbstractVcs vcs;
            AbstractVcs abstractVcs = vcs = vcsKey != null ? this.myVcsManager.findVcsByName(vcsKey.getName()) : null;
            if (changeList != null) {
                LOG.debug("[processChangeInList-1] to add change to cl");
                this.myChangeListUpdater.addChangeToList(changeList.getName(), change, vcs);
            } else {
                LOG.debug("[processChangeInList-1] to add to corresponding list");
                this.myChangeListUpdater.addChangeToCorrespondingList(change, vcs);
            }
        } else {
            LOG.debug("[processChangeInList-1] not under scope");
        }
    }

    public void processChangeInList(@NotNull Change change, String changeListName2, VcsKey vcsKey) {
        if (change == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(6);
        }
        this.checkIfDisposed();
        LocalChangeList list = null;
        if (changeListName2 != null) {
            list = this.myChangeListUpdater.findOrCreateList(changeListName2, null);
        }
        this.processChangeInList(change, (ChangeList)list, vcsKey);
    }

    public void removeRegisteredChangeFor(FilePath path) {
        this.myChangeListUpdater.removeRegisteredChangeFor(path);
    }

    public void processUnversionedFile(FilePath filePath) {
        if (this.acceptFilePath(filePath, false)) {
            VirtualFile file;
            this.myComposite.getUnversionedFileHolder().addFile(this.myScope.getVcs(), filePath);
            SwitchedFileHolder switchedFileHolder = this.myComposite.getSwitchedFileHolder();
            if (!switchedFileHolder.isEmpty() && (file = filePath.getVirtualFile()) != null) {
                switchedFileHolder.removeFile(file);
            }
        }
    }

    public void processLocallyDeletedFile(FilePath file) {
        this.processLocallyDeletedFile(new LocallyDeletedChange(file));
    }

    public void processLocallyDeletedFile(LocallyDeletedChange locallyDeletedChange) {
        this.checkIfDisposed();
        FilePath file = locallyDeletedChange.getPath();
        if (FileTypeManager.getInstance().isFileIgnored(file.getName())) {
            return;
        }
        if (this.myScope.belongsTo(file)) {
            this.myComposite.getDeletedFileHolder().addFile(locallyDeletedChange);
        }
    }

    public void processModifiedWithoutCheckout(VirtualFile file) {
        if (this.acceptFile(file, false)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("processModifiedWithoutCheckout " + String.valueOf(file));
            }
            this.myComposite.getModifiedWithoutEditingFileHolder().addFile(file);
        }
    }

    public void processIgnoredFile(FilePath filePath) {
        if (this.acceptFilePath(filePath, false)) {
            this.myComposite.getIgnoredFileHolder().addFile(this.myScope.getVcs(), filePath);
        }
    }

    public void processLockedFolder(VirtualFile file) {
        if (this.acceptFile(file, true) && this.myFoldersCutDownWorker.addCurrent(file)) {
            this.myComposite.getLockedFileHolder().addFile(file);
        }
    }

    public void processLogicallyLockedFolder(VirtualFile file, LogicalLock logicalLock) {
        if (this.acceptFile(file, true)) {
            this.myComposite.getLogicallyLockedFileHolder().add(file, logicalLock);
        }
    }

    public void processSwitchedFile(VirtualFile file, String branch, boolean recursive) {
        if (this.acceptFile(file, false)) {
            this.myComposite.getSwitchedFileHolder().addFile(file, branch, recursive);
        }
    }

    public void processRootSwitch(VirtualFile file, String branch) {
        if (this.acceptFile(file, true)) {
            this.myComposite.getRootSwitchFileHolder().addFile(file, branch, false);
        }
    }

    public boolean reportChangesOutsideProject() {
        return false;
    }

    public void reportAdditionalInfo(@NlsContexts.Label String text) {
        this.reportAdditionalInfo(ChangesViewManager.createTextStatusFactory(text, true));
    }

    public void reportAdditionalInfo(@NotNull Factory<@Nullable JComponent> infoComponent) {
        if (infoComponent == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(7);
        }
        this.myAdditionalInfo.add((Supplier<JComponent>)infoComponent);
    }

    public @NotNull List<Supplier<@Nullable JComponent>> getAdditionalInfo() {
        List<Supplier<JComponent>> list = this.myAdditionalInfo;
        if (list == null) {
            UpdatingChangeListBuilder.$$$reportNull$$$0(8);
        }
        return list;
    }

    private boolean acceptFile(@Nullable VirtualFile file, boolean allowIgnored) {
        this.checkIfDisposed();
        if (file == null) {
            return false;
        }
        if (!allowIgnored && ((Boolean)ReadAction.compute(() -> this.myVcsManager.isIgnored(file))).booleanValue()) {
            return false;
        }
        return this.myScope.belongsTo(VcsUtil.getFilePath((VirtualFile)file));
    }

    private boolean acceptFilePath(@Nullable FilePath filePath, boolean allowIgnored) {
        this.checkIfDisposed();
        if (filePath == null) {
            return false;
        }
        if (!allowIgnored && ((Boolean)ReadAction.compute(() -> this.myVcsManager.isIgnored(filePath))).booleanValue()) {
            return false;
        }
        return this.myScope.belongsTo(filePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListUpdater";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposedGetter";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/UpdatingChangeListBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/UpdatingChangeListBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processChange";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processChangeInList";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reportAdditionalInfo";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

