/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFileType;
import com.intellij.database.csv.CsvFileUsageCollector;
import com.intellij.database.editor.CsvTableFileEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/csv/CsvFileOpenedListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "<init>", "()V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.grid.impl"})
public final class CsvFileOpenedListener
implements FileEditorManagerListener {
    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getNewFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)CsvFileType.INSTANCE)) {
            return;
        }
        FileEditor selectedEditor = event.getNewEditor();
        CsvFileUsageCollector.OpenMode mode = selectedEditor instanceof CsvTableFileEditor ? CsvFileUsageCollector.OpenMode.DATA : CsvFileUsageCollector.OpenMode.TEXT;
        Project project = event.getManager().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CsvFileUsageCollector.logFileOpened(project, file, mode);
    }
}

