/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.run.actions.GridAutoRefresher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.progress.CoroutineSuspender;
import com.intellij.openapi.progress.SuspenderKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0012\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0013\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0015J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/run/actions/GridAutoRefresher;", "Lcom/intellij/openapi/Disposable;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "interval", "Lkotlin/time/Duration;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "manualPauseSuspender", "Lcom/intellij/openapi/progress/CoroutineSuspender;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "dispose", "", "processAutoRefreshWhenShown", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processAutoRefresh", "performRefresh", "reloadData", "isManuallyPaused", "", "setManuallyPaused", "pause", "shouldPause", "hasChanges", "Companion", "intellij.grid.impl"})
public final class GridAutoRefresher
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGrid grid;
    private long interval;
    @NotNull
    private final CoroutineSuspender manualPauseSuspender;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private static final Key<GridAutoRefresher> KEY;

    private GridAutoRefresher(DataGrid grid, long interval) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        this.grid = grid;
        this.interval = interval;
        this.manualPauseSuspender = SuspenderKt.coroutineSuspender$default((boolean)false, (int)1, null);
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)SuspenderKt.asContextElement((CoroutineSuspender)this.manualPauseSuspender)));
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GridAutoRefresher this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.processAutoRefreshWhenShown((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, null, (int)1, null);
    }

    private final Object processAutoRefreshWhenShown(Continuation<? super Unit> $completion) {
        Disposable disposable = this;
        JBLoadingPanel jBLoadingPanel = this.grid.getPanel().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jBLoadingPanel, (String)"getComponent(...)");
        Object object = FlowKt.collectLatest((Flow)GridAutoRefresher.Companion.isShowingFlow(disposable, (Component)jBLoadingPanel), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ boolean Z$0;
            final /* synthetic */ GridAutoRefresher this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                boolean bl = this.Z$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void isShowing;
                        ResultKt.throwOnFailure((Object)$result);
                        if (isShowing == false) return Unit.INSTANCE;
                        this.Z$0 = isShowing;
                        this.label = 1;
                        Object object2 = GridAutoRefresher.access$processAutoRefresh(this.this$0, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.Z$0 = (Boolean)value;
                return (Continuation)var3_3;
            }

            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object processAutoRefresh(Continuation<? super Unit> $completion) {
        if (!($completion instanceof processAutoRefresh.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ GridAutoRefresher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GridAutoRefresher.access$processAutoRefresh(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl13:
                // 2 sources

                while (true) {
                    $continuation.label = 1;
                    v0 = DelayKt.delay-VtjQ1oo((long)this.interval, (Continuation)$continuation);
                    if (v0 == var4_4) {
                        return var4_4;
                    }
                    ** GOTO lbl22
                    break;
                }
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                $continuation.label = 2;
                v1 = com.intellij.openapi.progress.CoroutinesKt.checkCanceled((Continuation)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl30
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl30:
                // 2 sources

                $continuation.label = 3;
                v2 = this.performRefresh((Continuation<? super Unit>)$continuation);
                if (v2 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl38
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl38:
                // 2 sources

                ** continue;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object performRefresh(Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GridAutoRefresher this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (GridAutoRefresher.access$shouldPause(this.this$0)) {
                            this.this$0.setManuallyPaused(true);
                            return Unit.INSTANCE;
                        }
                        this.label = 1;
                        Object object2 = GridAutoRefresher.access$reloadData(this.this$0, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (CancellationException ce) {
                            throw ce;
                        }
                        catch (RuntimeException ignored) {
                            this.this$0.setManuallyPaused(true);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object reloadData(Continuation<? super Unit> $completion) {
        GridRequestSource gridRequestSource;
        GridRequestSource it = gridRequestSource = new GridRequestSource(null);
        boolean bl = false;
        this.grid.getDataHookup().getLoader().reloadCurrentPage(it);
        ActionCallback actionCallback = gridRequestSource.getActionCallback();
        Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"getActionCallback(...)");
        Object object = com.intellij.openapi.util.CoroutinesKt.await((ActionCallback)actionCallback, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean isManuallyPaused() {
        return this.manualPauseSuspender.isPaused();
    }

    public final void setManuallyPaused(boolean pause) {
        if (this.isManuallyPaused() == pause) {
            return;
        }
        if (pause) {
            this.manualPauseSuspender.pause();
        } else {
            this.manualPauseSuspender.resume();
        }
    }

    private final boolean shouldPause() {
        if (!this.hasChanges()) {
            return false;
        }
        int res = Messages.showYesNoDialog((Project)this.grid.getProject(), (String)DataGridBundle.message((String)"dialog.message.changes.are.submitted.data.will.be.lost.continue", (Object[])new Object[0]), (String)DataGridBundle.message((String)"dialog.title.auto.refresh", (Object[])new Object[0]), (String)DataGridBundle.message((String)"button.refresh", (Object[])new Object[0]), (String)DataGridBundle.message((String)"button.pause.auto.refresh", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        if (res == 1) {
            return true;
        }
        this.grid.stopEditing();
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasChanges() {
        if (this.grid.isEditing()) return true;
        GridMutator gridMutator = this.grid.getDataHookup().getMutator();
        if (gridMutator == null) return false;
        if (!gridMutator.hasPendingChanges()) return false;
        return true;
    }

    @JvmStatic
    @Nullable
    public static final GridAutoRefresher getRefresher(@Nullable DataGrid dataGrid) {
        return Companion.getRefresher(dataGrid);
    }

    @JvmStatic
    public static final boolean isEnabled(@NotNull DataGrid dataGrid) {
        return Companion.isEnabled(dataGrid);
    }

    @JvmStatic
    public static final int getRefreshInterval(@NotNull DataGrid dataGrid) {
        return Companion.getRefreshInterval(dataGrid);
    }

    @JvmStatic
    public static final void setRefreshInterval(@NotNull DataGrid dataGrid, int intervalSec) {
        Companion.setRefreshInterval(dataGrid, intervalSec);
    }

    public /* synthetic */ GridAutoRefresher(DataGrid grid, long interval, DefaultConstructorMarker $constructor_marker) {
        this(grid, interval);
    }

    public static final /* synthetic */ Object access$processAutoRefresh(GridAutoRefresher $this, Continuation $completion) {
        return $this.processAutoRefresh((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$performRefresh(GridAutoRefresher $this, Continuation $completion) {
        return $this.performRefresh((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ boolean access$shouldPause(GridAutoRefresher $this) {
        return $this.shouldPause();
    }

    public static final /* synthetic */ Object access$reloadData(GridAutoRefresher $this, Continuation $completion) {
        return $this.reloadData((Continuation<? super Unit>)$completion);
    }

    static {
        Key key = Key.create((String)"GridAutoRefresher");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0012H\u0007J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/run/actions/GridAutoRefresher$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/run/actions/GridAutoRefresher;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getRefresher", "dataGrid", "Lcom/intellij/database/datagrid/DataGrid;", "setRefresher", "", "r", "isEnabled", "", "getRefreshInterval", "", "refresher", "setRefreshInterval", "intervalSec", "isShowingFlow", "Lkotlinx/coroutines/flow/Flow;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "component", "Ljava/awt/Component;", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final GridAutoRefresher getRefresher(@Nullable DataGrid dataGrid) {
            return (GridAutoRefresher)KEY.get((UserDataHolder)dataGrid);
        }

        private final void setRefresher(DataGrid dataGrid, GridAutoRefresher r) {
            GridAutoRefresher prev = (GridAutoRefresher)KEY.get((UserDataHolder)dataGrid);
            if (prev != null) {
                Disposer.dispose((Disposable)prev);
            }
            if (r != null) {
                Disposer.register((Disposable)((Disposable)dataGrid), (Disposable)r);
            }
            KEY.set((UserDataHolder)dataGrid, (Object)r);
        }

        @JvmStatic
        public final boolean isEnabled(@NotNull DataGrid dataGrid) {
            Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
            return this.getRefreshInterval(dataGrid) != 0;
        }

        @JvmStatic
        public final int getRefreshInterval(@NotNull DataGrid dataGrid) {
            Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
            GridAutoRefresher refresher = this.getRefresher(dataGrid);
            return this.getRefreshInterval(refresher);
        }

        private final int getRefreshInterval(GridAutoRefresher refresher) {
            GridAutoRefresher gridAutoRefresher = refresher;
            return gridAutoRefresher != null ? Duration.toInt-impl((long)gridAutoRefresher.interval, (DurationUnit)DurationUnit.SECONDS) : 0;
        }

        @JvmStatic
        public final void setRefreshInterval(@NotNull DataGrid dataGrid, int intervalSec) {
            Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
            GridAutoRefresher refresher = this.getRefresher(dataGrid);
            if (this.getRefreshInterval(refresher) == intervalSec) {
                return;
            }
            if (intervalSec == 0) {
                this.setRefresher(dataGrid, null);
            } else if (refresher != null) {
                refresher.interval = DurationKt.toDuration((int)intervalSec, (DurationUnit)DurationUnit.SECONDS);
            } else {
                this.setRefresher(dataGrid, new GridAutoRefresher(dataGrid, DurationKt.toDuration((int)intervalSec, (DurationUnit)DurationUnit.SECONDS), null));
            }
        }

        private final Flow<Boolean> isShowingFlow(Disposable parentDisposable, Component component) {
            MutableStateFlow showing = StateFlowKt.MutableStateFlow((Object)false);
            Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)UiNotifyConnector.Companion.installOn(component, new Activatable((MutableStateFlow<Boolean>)showing){
                final /* synthetic */ MutableStateFlow<Boolean> $showing;
                {
                    this.$showing = $showing;
                }

                public void showNotify() {
                    this.$showing.setValue((Object)true);
                }

                public void hideNotify() {
                    this.$showing.setValue((Object)false);
                }
            })));
            return (Flow)showing;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

