/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.diagnostic.LoadingState;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.system.OS;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BrowserUtil {
    private static final Pattern ourExternalPrefix = Pattern.compile("^[\\w+.\\-]{2,}:");
    private static final Pattern ourAnchorSuffix = Pattern.compile("#(.*)$");

    private BrowserUtil() {
    }

    public static boolean isAbsoluteURL(String url) {
        return ourExternalPrefix.matcher(StringUtil.toLowerCase((String)url)).find();
    }

    public static String getDocURL(String url) {
        Matcher anchorMatcher = ourAnchorSuffix.matcher(url);
        return anchorMatcher.find() ? anchorMatcher.reset().replaceAll("") : url;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static URL getURL(String url) throws MalformedURLException {
        return BrowserUtil.isAbsoluteURL(url) ? VfsUtilCore.convertToURL((String)url) : new URL("file", "", url);
    }

    public static void open(@NotNull String url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(0);
        }
        BrowserUtil.getBrowserLauncher().open(url);
    }

    public static void browse(@NotNull VirtualFile file) {
        if (file == null) {
            BrowserUtil.$$$reportNull$$$0(1);
        }
        BrowserUtil.browse(file.getUrl(), null);
    }

    @ApiStatus.Obsolete
    public static void browse(@NotNull File file) {
        if (file == null) {
            BrowserUtil.$$$reportNull$$$0(2);
        }
        BrowserUtil.getBrowserLauncher().browse(file);
    }

    public static void browse(@NotNull Path file) {
        if (file == null) {
            BrowserUtil.$$$reportNull$$$0(3);
        }
        BrowserUtil.getBrowserLauncher().browse(file);
    }

    public static void browse(@NotNull URL url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(4);
        }
        BrowserUtil.browse(url.toExternalForm(), null);
    }

    public static void browse(@NotNull URI uri) {
        if (uri == null) {
            BrowserUtil.$$$reportNull$$$0(5);
        }
        BrowserUtil.getBrowserLauncher().browse(uri);
    }

    public static void browse(@NotNull String url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(6);
        }
        BrowserUtil.browse(url, null);
    }

    public static void browse(@NotNull String url, @Nullable Project project) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(7);
        }
        BrowserUtil.getBrowserLauncher().browse(url, null, project);
    }

    private static BrowserLauncher getBrowserLauncher() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() ? BrowserLauncher.getInstance() : new BrowserLauncherAppless();
    }

    @NotNull
    public static List<String> getOpenBrowserCommand(@NotNull String browserPathOrName, @Nullable String url, @NotNull List<String> parameters, boolean newWindowIfPossible) {
        if (browserPathOrName == null) {
            BrowserUtil.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            BrowserUtil.$$$reportNull$$$0(9);
        }
        ArrayList<String> command = new ArrayList<String>();
        Path path = NioFiles.toPath((String)browserPathOrName);
        if (path == null || !Files.isRegularFile(path, new LinkOption[0])) {
            if (OS.CURRENT == OS.macOS) {
                command.addAll(List.of(ExecUtil.getOpenCommandPath(), "-a", browserPathOrName));
                if (newWindowIfPossible) {
                    command.add("-n");
                }
                if (url != null) {
                    command.add(url);
                }
                if (!parameters.isEmpty()) {
                    command.add("--args");
                    command.addAll(parameters);
                }
            } else if (OS.CURRENT == OS.Windows) {
                command.addAll(List.of(CommandLineUtil.getWinShellName(), "/c", "start", GeneralCommandLine.inescapableQuote((String)""), browserPathOrName));
                command.addAll(parameters);
                if (url != null) {
                    command.add(url);
                }
            }
        }
        if (command.isEmpty()) {
            command.add(browserPathOrName);
            command.addAll(parameters);
            if (url != null) {
                command.add(url);
            }
        }
        ArrayList<String> arrayList = command;
        if (arrayList == null) {
            BrowserUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Deprecated(forRemoval=true)
    public static void launchBrowser(@NotNull String url) {
        if (url == null) {
            BrowserUtil.$$$reportNull$$$0(11);
        }
        BrowserUtil.browse(url);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserPathOrName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/BrowserUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/BrowserUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenBrowserCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "browse";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOpenBrowserCommand";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "launchBrowser";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

