/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.DelegatingEdtBgtTreeVisitor;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.CachingTreePath;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.TreeNodeDomainModel;
import com.intellij.ui.treeStructure.TreeNodeViewModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Range;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.tree.IndexTreePathState;
import com.intellij.util.ui.tree.LegacyCompatibilityTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class TreeUtil {
    public static final TreePath[] EMPTY_TREE_PATH = new TreePath[0];
    @ApiStatus.Internal
    public static final Key<Boolean> TREE_IS_BUSY = Key.create((String)"Tree is busy doing an async operation");
    private static final Logger LOG = Logger.getInstance(TreeUtil.class);
    private static final String TREE_UTIL_SCROLL_TIME_STAMP = "TreeUtil.scrollTimeStamp";
    private static final JBIterable<Integer> NUMBERS = JBIterable.generate((Object)0, i -> i + 1);
    private static final Key<Function<TreePath, Navigatable>> NAVIGATABLE_PROVIDER = Key.create((String)"TreeUtil: convert TreePath to Navigatable");

    private TreeUtil() {
    }

    @Nullable
    public static Navigatable getNavigatable(@NotNull JTree tree, @Nullable TreePath path) {
        Function supplier;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(0);
        }
        return (supplier = (Function)ClientProperty.get((Component)tree, NAVIGATABLE_PROVIDER)) == null ? TreeUtil.getLastUserObject(Navigatable.class, path) : (Navigatable)supplier.apply(path);
    }

    public static void setNavigatableProvider(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends Navigatable> provider) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            TreeUtil.$$$reportNull$$$0(2);
        }
        tree.putClientProperty(NAVIGATABLE_PROVIDER, provider);
    }

    @NotNull
    public static JBTreeTraverser<Object> treeTraverser(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(3);
        }
        return TreeUtil.modelTraverser(tree.getModel());
    }

    @NotNull
    public static JBTreeTraverser<Object> modelTraverser(@NotNull TreeModel model) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(4);
        }
        Object root = model.getRoot();
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(node -> TreeUtil.nodeChildren(node, model)).withRoot(root);
        if (jBTreeTraverser == null) {
            TreeUtil.$$$reportNull$$$0(5);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static JBTreeTraverser<TreePath> treePathTraverser(@NotNull JTree tree) {
        TreeModel model;
        Object root;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(6);
        }
        CachingTreePath rootPath = (root = (model = tree.getModel()).getRoot()) == null ? null : new CachingTreePath(root);
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(path -> TreeUtil.nodeChildren(path.getLastPathComponent(), model).map(o -> path.pathByAddingChild(o))).withRoot((Object)rootPath);
        if (jBTreeTraverser == null) {
            TreeUtil.$$$reportNull$$$0(7);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static JBIterable<Object> nodeChildren(@Nullable Object node, @NotNull TreeModel model) {
        int count;
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(8);
        }
        JBIterable jBIterable = (count = model.getChildCount(node)) == 0 ? JBIterable.empty() : NUMBERS.take(count).map(index -> model.getChild(node, (int)index));
        if (jBIterable == null) {
            TreeUtil.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    public static JBTreeTraverser<TreeNode> treeNodeTraverser(@Nullable TreeNode treeNode) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)JBTreeTraverser.from(node -> TreeUtil.nodeChildren(node)).withRoot((Object)treeNode);
        if (jBTreeTraverser == null) {
            TreeUtil.$$$reportNull$$$0(10);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static JBIterable<TreeNode> nodeChildren(@Nullable TreeNode treeNode) {
        int count = treeNode == null ? 0 : treeNode.getChildCount();
        JBIterable jBIterable = count == 0 ? JBIterable.empty() : NUMBERS.take(count).map(index -> treeNode.getChildAt((int)index));
        if (jBIterable == null) {
            TreeUtil.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    public static boolean hasManyNodes(@NotNull Tree tree, int threshold) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(12);
        }
        return TreeUtil.hasManyNodes(TreeUtil.treeTraverser(tree), threshold);
    }

    public static boolean hasManyNodes(@NotNull TreeNode node, int threshold) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(13);
        }
        return TreeUtil.hasManyNodes(TreeUtil.treeNodeTraverser(node), threshold);
    }

    private static <T> boolean hasManyNodes(@NotNull JBTreeTraverser<T> traverser, int threshold) {
        if (traverser == null) {
            TreeUtil.$$$reportNull$$$0(14);
        }
        return traverser.traverse().take(threshold).size() >= threshold;
    }

    @Nullable
    public static TreePath getPathForLocation(@NotNull JTree tree, int x, int y) {
        TreePath path;
        Rectangle bounds;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(15);
        }
        return (bounds = tree.getPathBounds(path = tree.getClosestPathForLocation(x, y))) != null && bounds.y <= y && y < bounds.y + bounds.height ? path : null;
    }

    public static int getRowForLocation(@NotNull JTree tree, int x, int y) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(16);
        }
        return Math.max(-1, tree.getRowForPath(TreeUtil.getPathForLocation(tree, x, y)));
    }

    public static void repaintPath(@NotNull JTree tree, @Nullable TreePath path) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(17);
        }
        assert (EventQueue.isDispatchThread());
        TreeUtil.repaintBounds(tree, tree.getPathBounds(path));
    }

    public static void repaintRow(@NotNull JTree tree, int row) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(18);
        }
        assert (EventQueue.isDispatchThread());
        TreeUtil.repaintBounds(tree, tree.getRowBounds(row));
    }

    private static void repaintBounds(@NotNull JTree tree, @Nullable Rectangle bounds) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(19);
        }
        if (bounds != null) {
            tree.repaint(0, bounds.y - 1, tree.getWidth(), bounds.height + 2);
        }
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(20);
        }
        return TreeUtil.collectExpandedObjects(tree, Function.identity());
    }

    @NotNull
    public static List<Object> collectExpandedUserObjects(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(21);
        }
        return TreeUtil.collectExpandedObjects(tree, TreeUtil::getLastUserObject);
    }

    @NotNull
    public static <T> List<T> collectExpandedObjects(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper) {
        int count;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(22);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(23);
        }
        if ((count = tree.getRowCount()) == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(24);
            }
            return list;
        }
        ArrayList list = new ArrayList();
        for (int row = 0; row < count; ++row) {
            if (!tree.isExpanded(row)) continue;
            TreePath path = TreeUtil.getVisiblePathWithValidation(tree, row, count);
            ContainerUtil.addIfNotNull(list, mapper.apply(path));
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @Nullable
    public static <T> T findObjectInPath(@Nullable TreePath path, @NotNull Class<T> clazz) {
        if (clazz == null) {
            TreeUtil.$$$reportNull$$$0(26);
        }
        while (path != null) {
            T object = TreeUtil.getLastUserObject(clazz, path);
            if (object != null) {
                return object;
            }
            path = path.getParentPath();
        }
        return null;
    }

    @NotNull
    public static <T> @Unmodifiable List<T> collectSelectedObjectsOfType(@NotNull JTree tree, @NotNull Class<? extends T> type) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(27);
        }
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(28);
        }
        return TreeUtil.collectSelectedObjects(tree, path -> TreeUtil.getLastUserObject(type, path));
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(29);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(30);
        }
        return TreeUtil.collectExpandedObjects(tree, root, Function.identity());
    }

    @NotNull
    public static List<Object> collectExpandedUserObjects(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(31);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(32);
        }
        return TreeUtil.collectExpandedObjects(tree, root, TreeUtil::getLastUserObject);
    }

    @NotNull
    public static <T> List<T> collectExpandedObjects(@NotNull JTree tree, @NotNull TreePath root, @NotNull Function<? super TreePath, ? extends T> mapper) {
        TreePath path;
        int count;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(33);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(34);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(35);
        }
        if ((count = tree.getRowCount()) == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(36);
            }
            return list;
        }
        int row = tree.getRowForPath(root);
        if (row < 0) {
            List<Object> list = !tree.isRootVisible() && root.equals(TreeUtil.getVisiblePathWithValidation(tree, 0, count).getParentPath()) ? TreeUtil.collectExpandedObjects(tree, mapper) : Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        if (!tree.isExpanded(row)) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        ArrayList list = new ArrayList(count);
        ContainerUtil.addIfNotNull(list, mapper.apply(root));
        int depth = root.getPathCount();
        ++row;
        while (row < count && depth < (path = TreeUtil.getVisiblePathWithValidation(tree, row, count)).getPathCount()) {
            if (tree.isExpanded(row)) {
                ContainerUtil.addIfNotNull(list, mapper.apply(path));
            }
            ++row;
        }
        ArrayList arrayList = list;
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    public static void restoreExpandedPaths(@NotNull JTree tree, @NotNull List<? extends TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(40);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(41);
        }
        if (TreeUtil.isBulkExpandCollapseSupported(tree)) {
            ((Tree)tree).expandPaths(paths);
        } else {
            for (int i = paths.size() - 1; i >= 0; --i) {
                tree.expandPath(paths.get(i));
            }
        }
    }

    @NotNull
    public static TreePath getPath(@NotNull TreeNode aRootNode, @NotNull TreeNode aNode) {
        if (aRootNode == null) {
            TreeUtil.$$$reportNull$$$0(42);
        }
        if (aNode == null) {
            TreeUtil.$$$reportNull$$$0(43);
        }
        Object[] nodes = TreeUtil.getPathFromRootTo(aRootNode, aNode, true);
        return new CachingTreePath(nodes);
    }

    public static boolean isAncestor(@NotNull TreeNode ancestor, @NotNull TreeNode node) {
        if (ancestor == null) {
            TreeUtil.$$$reportNull$$$0(44);
        }
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(45);
        }
        for (TreeNode parent = node; parent != null; parent = parent.getParent()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TreePath getPathFromRoot(@NotNull TreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(46);
        }
        Object[] path = TreeUtil.getPathFromRootTo(null, node, false);
        return new CachingTreePath(path);
    }

    private static TreeNode @NotNull [] getPathFromRootTo(@Nullable TreeNode root, @NotNull TreeNode node, boolean includeRoot) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(47);
        }
        int height = 0;
        for (TreeNode n = node; n != root; n = n.getParent()) {
            ++height;
        }
        TreeNode[] path = new TreeNode[includeRoot ? height + 1 : height];
        int i = path.length - 1;
        TreeNode n = node;
        while (i >= 0) {
            path[i--] = n;
            n = n.getParent();
        }
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(48);
        }
        return path;
    }

    @Nullable
    public static TreeNode findNodeWithObject(Object object, @NotNull TreeModel model, Object parent) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(49);
        }
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(parent, i);
            if (!childNode.getUserObject().equals(object)) continue;
            return childNode;
        }
        return null;
    }

    public static void removeSelected(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(50);
        }
        if ((paths = tree.getSelectionPaths()) == null) {
            return;
        }
        for (TreePath path : paths) {
            TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), path).restoreSelection(tree);
        }
    }

    public static void removeLastPathComponent(@NotNull JTree tree, @NotNull TreePath pathToBeRemoved) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(51);
        }
        if (pathToBeRemoved == null) {
            TreeUtil.$$$reportNull$$$0(52);
        }
        TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), pathToBeRemoved).restoreSelection(tree);
    }

    @Nullable
    public static DefaultMutableTreeNode findNodeWithObject(@NotNull DefaultMutableTreeNode aRoot, Object aObject) {
        if (aRoot == null) {
            TreeUtil.$$$reportNull$$$0(53);
        }
        return TreeUtil.findNode(aRoot, (Condition<? super DefaultMutableTreeNode>)((Condition)node -> Comparing.equal((Object)node.getUserObject(), (Object)aObject)));
    }

    @Nullable
    public static DefaultMutableTreeNode findNode(@NotNull DefaultMutableTreeNode aRoot, @NotNull Condition<? super DefaultMutableTreeNode> condition) {
        if (aRoot == null) {
            TreeUtil.$$$reportNull$$$0(54);
        }
        if (condition == null) {
            TreeUtil.$$$reportNull$$$0(55);
        }
        if (condition.value((Object)aRoot)) {
            return aRoot;
        }
        for (int i = 0; i < aRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode candidate = TreeUtil.findNode((DefaultMutableTreeNode)aRoot.getChildAt(i), condition);
            if (null == candidate) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static ActionCallback selectFirstNode(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(56);
        }
        ActionCallback actionCallback = Promises.toActionCallback(TreeUtil.promiseSelectFirst(tree));
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(57);
        }
        return actionCallback;
    }

    @NotNull
    public static TreePath getFirstNodePath(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(58);
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new CachingTreePath(root);
        if (!tree.isRootVisible() && model.getChildCount(root) > 0) {
            selectionPath = ((TreePath)selectionPath).pathByAddingChild(model.getChild(root, 0));
        }
        CachingTreePath cachingTreePath = selectionPath;
        if (cachingTreePath == null) {
            TreeUtil.$$$reportNull$$$0(59);
        }
        return cachingTreePath;
    }

    public static int getRowForNode(@NotNull JTree tree, @NotNull DefaultMutableTreeNode targetNode) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(60);
        }
        if (targetNode == null) {
            TreeUtil.$$$reportNull$$$0(61);
        }
        Object[] path = targetNode.getPath();
        return tree.getRowForPath(new CachingTreePath(path));
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static TreePath getFirstLeafNodePath(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(62);
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new CachingTreePath(root);
        while (model.getChildCount(root) > 0) {
            Object child = model.getChild(root, 0);
            selectionPath = ((TreePath)selectionPath).pathByAddingChild(child);
            root = child;
        }
        CachingTreePath cachingTreePath = selectionPath;
        if (cachingTreePath == null) {
            TreeUtil.$$$reportNull$$$0(63);
        }
        return cachingTreePath;
    }

    @NotNull
    private static IndexTreePathState removeLastPathComponent(@NotNull DefaultTreeModel model, @NotNull TreePath pathToBeRemoved) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(64);
        }
        if (pathToBeRemoved == null) {
            TreeUtil.$$$reportNull$$$0(65);
        }
        IndexTreePathState selectionState = new IndexTreePathState(pathToBeRemoved);
        if (((MutableTreeNode)pathToBeRemoved.getLastPathComponent()).getParent() == null) {
            IndexTreePathState indexTreePathState = selectionState;
            if (indexTreePathState == null) {
                TreeUtil.$$$reportNull$$$0(66);
            }
            return indexTreePathState;
        }
        model.removeNodeFromParent((MutableTreeNode)pathToBeRemoved.getLastPathComponent());
        IndexTreePathState indexTreePathState = selectionState;
        if (indexTreePathState == null) {
            TreeUtil.$$$reportNull$$$0(67);
        }
        return indexTreePathState;
    }

    public static void sort(@NotNull DefaultTreeModel model, @Nullable Comparator comparator) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(68);
        }
        TreeUtil.sort((DefaultMutableTreeNode)model.getRoot(), comparator);
    }

    public static void sort(@NotNull DefaultMutableTreeNode node, @Nullable Comparator comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(69);
        }
        TreeUtil.sortRecursively(node, comparator);
    }

    public static <T extends MutableTreeNode> void sortRecursively(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(70);
        }
        TreeUtil.sortChildren(node, comparator);
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeUtil.sortRecursively((MutableTreeNode)node.getChildAt(i), comparator);
        }
    }

    public static <T extends MutableTreeNode> void sortChildren(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(71);
        }
        List<TreeNode> children = TreeUtil.listChildren(node);
        children.sort(comparator);
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            node.remove(i);
        }
        TreeUtil.addChildrenTo(node, children);
    }

    public static void addChildrenTo(@NotNull MutableTreeNode node, @NotNull List<? extends TreeNode> children) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(72);
        }
        if (children == null) {
            TreeUtil.$$$reportNull$$$0(73);
        }
        for (TreeNode treeNode : children) {
            MutableTreeNode child = (MutableTreeNode)treeNode;
            node.insert(child, node.getChildCount());
        }
    }

    @Deprecated(forRemoval=true)
    public static boolean traverse(@NotNull TreeNode node, @NotNull Traverse traverse) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(74);
        }
        if (traverse == null) {
            TreeUtil.$$$reportNull$$$0(75);
        }
        return TreeUtil.treeNodeTraverser(node).traverse(TreeTraversal.POST_ORDER_DFS).processEach(traverse::accept);
    }

    @Deprecated(forRemoval=true)
    public static boolean traverseDepth(@NotNull TreeNode node, @NotNull Traverse traverse) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(76);
        }
        if (traverse == null) {
            TreeUtil.$$$reportNull$$$0(77);
        }
        return TreeUtil.treeNodeTraverser(node).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(traverse::accept);
    }

    public static void selectRow(@NotNull JTree tree, int index) {
        TreePath path;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(78);
        }
        if ((path = tree.getPathForRow(index)) != null) {
            TreeUtil.internalSelect(tree, path);
        }
    }

    @ApiStatus.Internal
    public static void selectPaths(@NotNull JTree tree, @NotNull Collection<? extends TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(79);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(80);
        }
        if (!paths.isEmpty()) {
            TreeUtil.selectPaths(tree, paths.toArray(EMPTY_TREE_PATH));
        }
    }

    @ApiStatus.Internal
    public static void selectPaths(@NotNull JTree tree, TreePath ... paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(81);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(82);
        }
        if (paths.length == 0) {
            return;
        }
        for (TreePath path : paths) {
            tree.makeVisible(path);
        }
        TreeUtil.internalSelect(tree, paths);
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(83);
        }
        return TreeUtil.selectPath(tree, path, true);
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(84);
        }
        tree.makeVisible(path);
        Rectangle bounds = tree.getPathBounds(path);
        if (bounds == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(85);
            }
            return actionCallback;
        }
        if (center) {
            Rectangle visible = tree.getVisibleRect();
            if (visible.y < bounds.y + bounds.height && bounds.y < visible.y + visible.height) {
                center = false;
            }
        }
        if (center) {
            return TreeUtil.showRowCentred(tree, tree.getRowForPath(path));
        }
        int row = tree.getRowForPath(path);
        return TreeUtil.showAndSelect(tree, row - 2, row + 2, row, -1);
    }

    @NotNull
    public static ActionCallback moveDown(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(86);
        }
        int size = tree.getRowCount();
        int row = tree.getLeadSelectionRow();
        if (row < size - 1) {
            return TreeUtil.showAndSelect(tree, ++row, row + 2, row, TreeUtil.getSelectedRow(tree), false, true, true);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(87);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback moveUp(@NotNull JTree tree) {
        int row;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(88);
        }
        if ((row = tree.getLeadSelectionRow()) > 0) {
            return TreeUtil.showAndSelect(tree, --row - 2, row, row, TreeUtil.getSelectedRow(tree), false, true, true);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(89);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback movePageUp(@NotNull JTree tree) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(90);
        }
        if ((visible = TreeUtil.getVisibleRowCount(tree)) <= 0) {
            return TreeUtil.moveHome(tree);
        }
        int decrement = visible - 1;
        int row = Math.max(TreeUtil.getSelectedRow(tree) - decrement, 0);
        int top = TreeUtil.getFirstVisibleRow(tree) - decrement;
        int bottom = top + visible - 1;
        return TreeUtil.showAndSelect(tree, top, bottom, row, TreeUtil.getSelectedRow(tree));
    }

    @NotNull
    public static ActionCallback movePageDown(@NotNull JTree tree) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(91);
        }
        if ((visible = TreeUtil.getVisibleRowCount(tree)) <= 0) {
            return TreeUtil.moveEnd(tree);
        }
        int size = tree.getRowCount();
        int increment = visible - 1;
        int index = Math.min(TreeUtil.getSelectedRow(tree) + increment, size - 1);
        int top = TreeUtil.getFirstVisibleRow(tree) + increment;
        int bottom = top + visible - 1;
        return TreeUtil.showAndSelect(tree, top, bottom, index, TreeUtil.getSelectedRow(tree));
    }

    @NotNull
    private static ActionCallback moveHome(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(92);
        }
        return TreeUtil.showRowCentred(tree, 0);
    }

    @NotNull
    private static ActionCallback moveEnd(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(93);
        }
        return TreeUtil.showRowCentred(tree, tree.getRowCount() - 1);
    }

    @NotNull
    private static ActionCallback showRowCentred(@NotNull JTree tree, int row) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(94);
        }
        return TreeUtil.showRowCentered(tree, row, true);
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(95);
        }
        return TreeUtil.showRowCentered(tree, row, centerHorizontally, true);
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally, boolean scroll) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(96);
        }
        int top = (visible = TreeUtil.getVisibleRowCount(tree)) > 0 ? row - (visible - 1) / 2 : row;
        int bottom = visible > 0 ? top + visible - 1 : row;
        return TreeUtil.showAndSelect(tree, top, bottom, row, -1, false, scroll, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(97);
        }
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(98);
        }
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, true, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(99);
        }
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, scroll, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll, boolean resetSelection) {
        Rectangle bottomBounds;
        TreePath path;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(100);
        }
        if ((path = tree.getPathForRow(row)) == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(101);
            }
            return actionCallback;
        }
        int size = tree.getRowCount();
        if (size == 0) {
            tree.clearSelection();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(102);
            }
            return actionCallback;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if (row >= tree.getRowCount()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(103);
            }
            return actionCallback;
        }
        boolean okToScroll = true;
        if (tree.isShowing()) {
            if (!tree.isValid()) {
                tree.validate();
            }
        } else {
            Application app = ApplicationManager.getApplication();
            if (app != null && app.isUnitTestMode()) {
                okToScroll = false;
            }
        }
        Runnable selectRunnable = () -> {
            if (!tree.isRowSelected(row)) {
                if (addToSelection) {
                    tree.getSelectionModel().addSelectionPath(tree.getPathForRow(row));
                } else {
                    tree.setSelectionRow(row);
                }
            } else if (resetSelection && !addToSelection) {
                tree.setSelectionRow(row);
            }
        };
        if (!okToScroll || !scroll) {
            selectRunnable.run();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(104);
            }
            return actionCallback;
        }
        Rectangle rowBounds = tree.getRowBounds(row);
        if (rowBounds == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(105);
            }
            return actionCallback;
        }
        Rectangle topBounds = tree.getRowBounds(top);
        if (topBounds == null) {
            topBounds = rowBounds;
        }
        if ((bottomBounds = tree.getRowBounds(bottom)) == null) {
            bottomBounds = rowBounds;
        }
        Rectangle bounds = topBounds.union(bottomBounds);
        bounds.x = rowBounds.x;
        bounds.width = rowBounds.width;
        Rectangle visible = tree.getVisibleRect();
        if (visible.contains(bounds)) {
            selectRunnable.run();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(106);
            }
            return actionCallback;
        }
        Component comp = tree.getCellRenderer().getTreeCellRendererComponent(tree, path.getLastPathComponent(), true, true, false, row, false);
        if (comp instanceof SimpleColoredComponent) {
            SimpleColoredComponent renderer = (SimpleColoredComponent)comp;
            Dimension scrollableSize = renderer.computePreferredSize(true);
            bounds.width = scrollableSize.width;
        }
        ActionCallback callback = new ActionCallback();
        selectRunnable.run();
        Range<Integer> range = TreeUtil.getExpandControlRange(tree, path);
        if (range != null) {
            int delta = bounds.x - (Integer)range.getFrom();
            bounds.x -= delta;
            bounds.width -= delta;
        }
        if (visible.width < bounds.width) {
            bounds.width = visible.width;
        }
        if (tree instanceof Tree && !((Tree)tree).isHorizontalAutoScrollingEnabled()) {
            bounds.x = tree.getVisibleRect().x;
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("tree scroll: ", new Object[]{path});
        }
        tree.scrollRectToVisible(bounds);
        Object property = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
        long stamp = property instanceof Long ? (Long)property + 1L : Long.MIN_VALUE;
        tree.putClientProperty(TREE_UTIL_SCROLL_TIME_STAMP, stamp);
        ClientProperty.put((JComponent)tree, TREE_IS_BUSY, (Object)true);
        int offset = rowBounds.y - bounds.y;
        TreeUtil.scrollToVisible(tree, path, bounds, offset, stamp, () -> ((ActionCallback)callback).setDone(), 3);
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(107);
        }
        return actionCallback;
    }

    private static void scrollToVisible(JTree tree, TreePath path, Rectangle bounds, int offset, long expected, Runnable done, int attempt) {
        Runnable scroll = () -> {
            Rectangle pathBounds;
            Rectangle rectangle = pathBounds = attempt <= 0 ? null : tree.getPathBounds(path);
            if (pathBounds != null) {
                long stamp;
                Object property = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
                long l = stamp = property instanceof Long ? (Long)property : Long.MAX_VALUE;
                if (LOG.isTraceEnabled()) {
                    LOG.debug("tree scroll ", new Object[]{attempt, stamp == expected ? ": try again: " : ": ignore: ", path});
                }
                if (stamp == expected) {
                    bounds.y = pathBounds.y - offset;
                    Rectangle visible = tree.getVisibleRect();
                    if (bounds.y < visible.y || bounds.y > visible.y + Math.max(0, visible.height - bounds.height)) {
                        tree.scrollRectToVisible(bounds);
                        TreeUtil.scrollToVisible(tree, path, bounds, offset, expected, done, attempt - 1);
                        return;
                    }
                }
            }
            ClientProperty.remove((JComponent)tree, TREE_IS_BUSY);
            done.run();
        };
        SwingUtilities.invokeLater(scroll);
    }

    private static int getSelectedRow(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(108);
        }
        return tree.getRowForPath(tree.getSelectionPath());
    }

    private static int getFirstVisibleRow(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(109);
        }
        Rectangle visible = tree.getVisibleRect();
        int row = -1;
        for (int i = 0; i < tree.getRowCount(); ++i) {
            Rectangle bounds = tree.getRowBounds(i);
            if (visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            row = i;
            break;
        }
        return row;
    }

    public static int getVisibleRowCount(@NotNull JTree tree) {
        int lastRow;
        int firstRow;
        Rectangle visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(110);
        }
        if ((visible = tree.getVisibleRect()) == null) {
            return 0;
        }
        int rowCount = tree.getRowCount();
        if (rowCount <= 0) {
            return 0;
        }
        int rowHeight = tree.getRowHeight();
        if (rowHeight > 0) {
            Insets insets = tree.getInsets();
            int top = visible.y - insets.top;
            int bottom = visible.y + visible.height - insets.top;
            firstRow = Math.max(0, Math.min(top / rowHeight, rowCount - 1));
            lastRow = Math.max(0, Math.min(bottom / rowHeight, rowCount - 1));
        } else {
            firstRow = tree.getClosestRowForLocation(visible.x, visible.y);
            lastRow = tree.getClosestRowForLocation(visible.x, visible.y + visible.height);
        }
        return lastRow - firstRow + 1;
    }

    public static void installActions(final @NotNull JTree tree) {
        TreeUI ui;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(111);
        }
        if ((ui = tree.getUI()) != null && ui.getClass().getName().equals("com.intellij.ui.tree.ui.DefaultTreeUI")) {
            return;
        }
        tree.getActionMap().put("scrollUpChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageUp(tree);
            }
        });
        tree.getActionMap().put("scrollDownChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageDown(tree);
            }
        });
        tree.getActionMap().put("selectPrevious", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveUp(tree);
            }
        });
        tree.getActionMap().put("selectNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveDown(tree);
            }
        });
        TreeUtil.copyAction(tree, "selectLast", "selectLastChangeLead");
        TreeUtil.copyAction(tree, "selectFirst", "selectFirstChangeLead");
        InputMap inputMap = tree.getInputMap(0);
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollUpChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(33, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollDownChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(34, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectNext", (KeyStroke)KeyStroke.getKeyStroke(40, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectPrevious", (KeyStroke)KeyStroke.getKeyStroke(38, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectLast", (KeyStroke)KeyStroke.getKeyStroke(35, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectFirst", (KeyStroke)KeyStroke.getKeyStroke(36, 0));
    }

    private static void copyAction(@NotNull JTree tree, String original, String copyTo) {
        Action action;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(112);
        }
        if ((action = tree.getActionMap().get(original)) != null) {
            tree.getActionMap().put(copyTo, action);
        }
    }

    public static void collapseAll(@NotNull JTree tree, int keepSelectionLevel) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(113);
        }
        TreeUtil.collapseAll(tree, false, keepSelectionLevel);
    }

    public static void collapseAll(@NotNull JTree tree, boolean strict, int keepSelectionLevel) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(114);
        }
        assert (EventQueue.isDispatchThread());
        int row = tree.getRowCount();
        if (row <= 1) {
            return;
        }
        TreePath leadSelectionPath = tree.getLeadSelectionPath();
        int minCount = 1;
        if (!tree.isRootVisible()) {
            ++minCount;
        }
        if (!tree.getShowsRootHandles()) {
            ++minCount;
            strict = true;
        }
        TreePath prohibited = leadSelectionPath == null ? null : TreeUtil.normalize(leadSelectionPath, minCount, keepSelectionLevel).getParentPath();
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        while (0 < row-- && (strict || row != 0)) {
            TreePath path = tree.getPathForRow(row);
            assert (path != null) : "path is not found at row " + row;
            int pathCount = path.getPathCount();
            if (pathCount < minCount) continue;
            if (pathCount == minCount && row > 0) {
                strict = true;
            }
            if (TreeUtil.isAlwaysExpand(path) || path.isDescendant(prohibited)) continue;
            paths.add(path);
        }
        TreeUtil.collapsePaths(tree, paths);
        if (leadSelectionPath == null) {
            return;
        }
        if (!strict) {
            ++minCount;
        }
        TreeUtil.internalSelect(tree, TreeUtil.normalize(leadSelectionPath, minCount, keepSelectionLevel));
    }

    public static boolean isBulkExpandCollapseSupported(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(115);
        }
        return Tree.isBulkExpandCollapseSupported() && tree instanceof Tree;
    }

    public static void expandPaths(@NotNull JTree tree, @Nullable Iterable<TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(116);
        }
        if (paths == null) {
            return;
        }
        if (Tree.isBulkExpandCollapseSupported() && tree instanceof Tree) {
            Tree jbTree = (Tree)tree;
            jbTree.expandPaths(paths);
        } else {
            paths.forEach(tree::expandPath);
        }
    }

    public static void collapsePaths(@NotNull JTree tree, @Nullable Iterable<TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(117);
        }
        if (paths == null) {
            return;
        }
        if (Tree.isBulkExpandCollapseSupported() && tree instanceof Tree) {
            Tree jbTree = (Tree)tree;
            jbTree.collapsePaths(paths);
        } else {
            paths.forEach(tree::collapsePath);
        }
    }

    @NotNull
    private static TreePath normalize(@NotNull TreePath path, int minCount, int keepSelectionLevel) {
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(118);
        }
        if (keepSelectionLevel < 0) {
            TreePath treePath = path;
            if (treePath == null) {
                TreeUtil.$$$reportNull$$$0(119);
            }
            return treePath;
        }
        if (keepSelectionLevel > minCount) {
            minCount = keepSelectionLevel;
        }
        int pathCount = path.getPathCount();
        while (minCount < pathCount--) {
            path = path.getParentPath();
        }
        assert (path != null) : "unexpected minCount: " + minCount;
        TreePath treePath = path;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(120);
        }
        return treePath;
    }

    private static boolean isAlwaysExpand(@NotNull TreePath path) {
        AbstractTreeNode<?> node;
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(121);
        }
        return (node = TreeUtil.getAbstractTreeNode(path)) != null && node.isAlwaysExpand();
    }

    public static void selectNode(@NotNull JTree tree, TreeNode node) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(122);
        }
        TreeUtil.selectPath(tree, TreeUtil.getPathFromRoot(node));
    }

    public static void moveSelectedRow(@NotNull JTree tree, int direction) {
        TreePath selectionPath;
        DefaultMutableTreeNode treeNode;
        DefaultMutableTreeNode parent;
        int idx;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(123);
        }
        if ((idx = (parent = (DefaultMutableTreeNode)(treeNode = (DefaultMutableTreeNode)(selectionPath = tree.getSelectionPath()).getLastPathComponent()).getParent()).getIndex(treeNode)) + direction < 0 || idx + direction >= parent.getChildCount()) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        model.removeNodeFromParent(treeNode);
        model.insertNodeInto(treeNode, parent, idx + direction);
        TreeUtil.selectNode(tree, treeNode);
    }

    @NotNull
    public static List<TreeNode> listChildren(@NotNull TreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(124);
        }
        int size = node.getChildCount();
        ArrayList<TreeNode> result2 = new ArrayList<TreeNode>(size);
        for (int i = 0; i < size; ++i) {
            TreeNode child = node.getChildAt(i);
            LOG.assertTrue(child != null);
            result2.add(child);
        }
        ArrayList<TreeNode> arrayList = result2;
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(125);
        }
        return arrayList;
    }

    public static void expandRootChildIfOnlyOne(@Nullable JTree tree) {
        if (tree == null) {
            return;
        }
        Runnable runnable = () -> {
            TreeModel model = tree.getModel();
            Object root = model.getRoot();
            if (root == null) {
                return;
            }
            CachingTreePath rootPath = new CachingTreePath(root);
            tree.expandPath(rootPath);
            if (model.getChildCount(root) == 1) {
                Object firstChild = model.getChild(root, 0);
                tree.expandPath(((TreePath)rootPath).pathByAddingChild(firstChild));
            }
        };
        EdtInvocationManager.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void expandAll(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(126);
        }
        TreeUtil.promiseExpandAll(tree);
    }

    public static void expandAll(@NotNull JTree tree, @NotNull Runnable onDone) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(127);
        }
        if (onDone == null) {
            TreeUtil.$$$reportNull$$$0(128);
        }
        TreeUtil.promiseExpandAll(tree).onSuccess(result2 -> EdtInvocationManager.invokeLaterIfNeeded((Runnable)onDone));
    }

    @NotNull
    public static Promise<?> promiseExpandAll(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(129);
        }
        return TreeUtil.promiseExpand(tree, Integer.MAX_VALUE);
    }

    public static void expand(@NotNull JTree tree, int levels) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(130);
        }
        TreeUtil.promiseExpand(tree, levels);
    }

    public static void expand(@NotNull JTree tree, int depth, @NotNull Runnable onDone) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(131);
        }
        if (onDone == null) {
            TreeUtil.$$$reportNull$$$0(132);
        }
        TreeUtil.promiseExpand(tree, depth).onSuccess(result2 -> EdtInvocationManager.invokeLaterIfNeeded((Runnable)onDone));
    }

    @NotNull
    public static Promise<?> promiseExpand(@NotNull JTree tree, int depth) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(133);
        }
        return TreeUtil.promiseExpand(tree, depth, path -> depth < Integer.MAX_VALUE || TreeUtil.isIncludedInExpandAll(path));
    }

    @ApiStatus.Internal
    @NotNull
    public static Promise<?> promiseExpand(@NotNull JTree tree, final int depth, final @NotNull @NotNull Predicate<@NotNull TreePath> predicate2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(134);
        }
        if (predicate2 == null) {
            TreeUtil.$$$reportNull$$$0(135);
        }
        AsyncPromise promise = new AsyncPromise();
        TreeUtil.promiseMakeVisible(tree, new TreeVisitor(){

            @NotNull
            public TreeVisitor.VisitThread visitThread() {
                TreeVisitor.VisitThread visitThread = Registry.is((String)"ide.tree.background.expand", (boolean)true) ? TreeVisitor.VisitThread.BGT : TreeVisitor.VisitThread.EDT;
                if (visitThread == null) {
                    5.$$$reportNull$$$0(0);
                }
                return visitThread;
            }

            @NotNull
            public TreeVisitor.Action visit(@NotNull TreePath path) {
                if (path == null) {
                    5.$$$reportNull$$$0(1);
                }
                TreeVisitor.Action action = depth < path.getPathCount() ? TreeVisitor.Action.SKIP_SIBLINGS : (predicate2.test(path) ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.SKIP_CHILDREN);
                if (action == null) {
                    5.$$$reportNull$$$0(2);
                }
                return action;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/ui/tree/TreeUtil$5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitThread";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/ui/tree/TreeUtil$5";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visit";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visit";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        }, promise).onError(arg_0 -> ((AsyncPromise)promise).setError(arg_0)).onSuccess(path -> {
            if (promise.isCancelled()) {
                return;
            }
            promise.setResult(null);
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(136);
        }
        return asyncPromise;
    }

    private static boolean isIncludedInExpandAll(@NotNull TreePath path) {
        Object value2;
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(137);
        }
        if ((value2 = TreeUtil.getLastUserObject(path)) instanceof AbstractTreeNode) {
            AbstractTreeNode node = (AbstractTreeNode)value2;
            return node.isIncludedInExpandAll();
        }
        return true;
    }

    @NotNull
    public static ActionCallback selectInTree(DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(138);
        }
        return TreeUtil.selectInTree(node, requestFocus, tree, true);
    }

    @NotNull
    public static ActionCallback selectInTree(@Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(139);
        }
        if (node == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(140);
            }
            return actionCallback;
        }
        CachingTreePath treePath = new CachingTreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)tree, true));
        }
        return TreeUtil.selectPath(tree, treePath, center);
    }

    @NotNull
    public static ActionCallback selectInTree(Project project, @Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(141);
        }
        if (node == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(142);
            }
            return actionCallback;
        }
        CachingTreePath treePath = new CachingTreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            ActionCallback result2 = new ActionCallback(2);
            IdeFocusManager.getInstance((Project)project).requestFocus((Component)tree, true).notifyWhenDone(result2);
            TreeUtil.selectPath(tree, treePath, center).notifyWhenDone(result2);
            ActionCallback actionCallback = result2;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(143);
            }
            return actionCallback;
        }
        return TreeUtil.selectPath(tree, treePath, center);
    }

    private static boolean isViewable(@NotNull JTree tree, @NotNull TreePath path) {
        TreePath parent;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(144);
        }
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(145);
        }
        return (parent = path.getParentPath()) != null ? tree.isExpanded(parent) : tree.isRootVisible();
    }

    @NotNull
    public static @Unmodifiable List<TreePath> collectSelectedPaths(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(146);
        }
        return TreeUtil.collectSelectedObjects(tree, Function.identity());
    }

    @NotNull
    public static @Unmodifiable List<Object> collectSelectedUserObjects(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(147);
        }
        return TreeUtil.collectSelectedObjects(tree, TreeUtil::getLastUserObject);
    }

    public static <T> @Unmodifiable @NotNull List<T> collectSelectedObjects(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(148);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(149);
        }
        return TreeUtil.getSelection(tree, path -> TreeUtil.isViewable(tree, path), mapper);
    }

    public static @Unmodifiable @NotNull List<TreePath> collectSelectedPaths(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(150);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(151);
        }
        return TreeUtil.collectSelectedObjects(tree, root, Function.identity());
    }

    public static @Unmodifiable @NotNull List<Object> collectSelectedUserObjects(@NotNull JTree tree, @NotNull TreePath root) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(152);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(153);
        }
        return TreeUtil.collectSelectedObjects(tree, root, TreeUtil::getLastUserObject);
    }

    public static <T> @Unmodifiable @NotNull List<T> collectSelectedObjects(@NotNull JTree tree, @NotNull TreePath root, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(154);
        }
        if (root == null) {
            TreeUtil.$$$reportNull$$$0(155);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(156);
        }
        if (!tree.isVisible(root)) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(157);
            }
            return list;
        }
        return TreeUtil.getSelection(tree, path -> TreeUtil.isViewable(tree, path) && root.isDescendant((TreePath)path), mapper);
    }

    private static <T> @Unmodifiable @NotNull List<T> getSelection(@NotNull JTree tree, @NotNull Predicate<? super TreePath> filter, @NotNull Function<? super TreePath, ? extends T> mapper) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(158);
        }
        if (filter == null) {
            TreeUtil.$$$reportNull$$$0(159);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(160);
        }
        if ((paths = tree.getSelectionPaths()) == null || paths.length == 0) {
            List list = Collections.emptyList();
            if (list == null) {
                TreeUtil.$$$reportNull$$$0(161);
            }
            return list;
        }
        List list = Stream.of(paths).filter(filter).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(162);
        }
        return list;
    }

    public static void unselectPath(@NotNull JTree tree, @Nullable TreePath path) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(163);
        }
        if (path == null) {
            return;
        }
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        for (TreePath selectionPath : selectionPaths) {
            if (selectionPath.getPathCount() <= path.getPathCount() || !path.isDescendant(selectionPath)) continue;
            tree.removeSelectionPath(selectionPath);
        }
    }

    @Nullable
    public static Range<Integer> getExpandControlRange(@NotNull JTree aTree, @Nullable TreePath path) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(164);
        }
        TreeModel treeModel = aTree.getModel();
        BasicTreeUI basicTreeUI = (BasicTreeUI)aTree.getUI();
        Icon expandedIcon = basicTreeUI.getExpandedIcon();
        Range box = null;
        if (path != null && !treeModel.isLeaf(path.getLastPathComponent())) {
            Insets i = aTree.getInsets();
            int boxWidth = expandedIcon != null ? expandedIcon.getIconWidth() : 8;
            int boxLeftX = i != null ? i.left : 0;
            boolean leftToRight = aTree.getComponentOrientation().isLeftToRight();
            int depthOffset = TreeUtil.getDepthOffset(aTree);
            int totalChildIndent = basicTreeUI.getLeftChildIndent() + basicTreeUI.getRightChildIndent();
            if (leftToRight) {
                boxLeftX += (path.getPathCount() + depthOffset - 2) * totalChildIndent + basicTreeUI.getLeftChildIndent() - boxWidth / 2;
            }
            int boxRightX = boxLeftX + boxWidth;
            box = new Range((Comparable)Integer.valueOf(boxLeftX), (Comparable)Integer.valueOf(boxRightX));
        }
        return box;
    }

    public static int getDepthOffset(@NotNull JTree aTree) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(165);
        }
        if (aTree.isRootVisible()) {
            return aTree.getShowsRootHandles() ? 1 : 0;
        }
        return aTree.getShowsRootHandles() ? 0 : -1;
    }

    public static int getNodeDepth(@NotNull JTree tree, @NotNull TreePath path) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(166);
        }
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(167);
        }
        int depth = path.getPathCount();
        if (!tree.isRootVisible()) {
            --depth;
        }
        if (!tree.getShowsRootHandles()) {
            --depth;
        }
        return depth;
    }

    @ApiStatus.Experimental
    public static int getNodeRowX(@NotNull JTree tree, int row) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(168);
        }
        if (LazyRowX.METHOD == null) {
            return -1;
        }
        TreePath path = tree.getPathForRow(row);
        if (path == null) {
            return -1;
        }
        int depth = TreeUtil.getNodeDepth(tree, path);
        if (depth < 0) {
            return -1;
        }
        try {
            return (Integer)LazyRowX.METHOD.invoke((Object)tree.getUI(), row, depth);
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return -1;
        }
    }

    @ApiStatus.Experimental
    public static boolean isLocationInExpandControl(@NotNull JTree tree, int x, int y) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(169);
        }
        if (LazyLocationInExpandControl.METHOD == null) {
            return false;
        }
        return TreeUtil.isLocationInExpandControl(tree, tree.getClosestPathForLocation(x, y), x, y);
    }

    @ApiStatus.Experimental
    public static boolean isLocationInExpandControl(@NotNull JTree tree, @Nullable TreePath path, int x, int y) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(170);
        }
        if (LazyLocationInExpandControl.METHOD == null || path == null) {
            return false;
        }
        try {
            return (Boolean)LazyLocationInExpandControl.METHOD.invoke((Object)tree.getUI(), path, x, y);
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return false;
        }
    }

    @ApiStatus.Experimental
    public static void invalidateCacheAndRepaint(@Nullable TreeUI ui) {
        if (ui instanceof BasicTreeUI) {
            BasicTreeUI basic = (BasicTreeUI)ui;
            if (null == ReflectionUtil.getField(BasicTreeUI.class, (Object)ui, JTree.class, (String)"tree")) {
                LOG.warn((Throwable)new IllegalStateException("tree is not properly initialized yet"));
                return;
            }
            EdtInvocationManager.invokeLaterIfNeeded(() -> basic.setLeftChildIndent(basic.getLeftChildIndent()));
        }
    }

    @NotNull
    public static RelativePoint getPointForSelection(@NotNull JTree aTree) {
        int[] rows;
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(171);
        }
        if ((rows = aTree.getSelectionRows()) == null || rows.length == 0) {
            RelativePoint relativePoint = RelativePoint.getCenterOf((JComponent)aTree);
            if (relativePoint == null) {
                TreeUtil.$$$reportNull$$$0(172);
            }
            return relativePoint;
        }
        return TreeUtil.getPointForRow(aTree, rows[rows.length - 1]);
    }

    @NotNull
    public static RelativePoint getPointForRow(@NotNull JTree aTree, int aRow) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(173);
        }
        return TreeUtil.getPointForPath(aTree, aTree.getPathForRow(aRow));
    }

    @NotNull
    public static RelativePoint getPointForPath(@NotNull JTree aTree, TreePath path) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(174);
        }
        Rectangle rowBounds = aTree.getPathBounds(path);
        rowBounds.x += 20;
        return TreeUtil.getPointForBounds(aTree, rowBounds);
    }

    @NotNull
    public static RelativePoint getPointForBounds(JComponent aComponent, @NotNull Rectangle aBounds) {
        if (aBounds == null) {
            TreeUtil.$$$reportNull$$$0(175);
        }
        return new RelativePoint((Component)aComponent, new Point(aBounds.x, (int)aBounds.getMaxY()));
    }

    public static boolean isOverSelection(@NotNull JTree tree, @NotNull Point point) {
        TreePath path;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(176);
        }
        if (point == null) {
            TreeUtil.$$$reportNull$$$0(177);
        }
        return (path = tree.getPathForLocation(point.x, point.y)) != null && tree.getSelectionModel().isPathSelected(path);
    }

    public static void dropSelectionButUnderPoint(@NotNull JTree tree, @NotNull Point treePoint) {
        TreePath toRetain;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(178);
        }
        if (treePoint == null) {
            TreeUtil.$$$reportNull$$$0(179);
        }
        if ((toRetain = tree.getPathForLocation(treePoint.x, treePoint.y)) == null) {
            return;
        }
        TreePath[] selection = tree.getSelectionModel().getSelectionPaths();
        for (TreePath each : selection = selection == null ? EMPTY_TREE_PATH : selection) {
            if (toRetain.equals(each)) continue;
            tree.getSelectionModel().removeSelectionPath(each);
        }
    }

    public static boolean isLoadingPath(@Nullable TreePath path) {
        return path != null && TreeUtil.isLoadingNode(path.getLastPathComponent());
    }

    public static boolean isLoadingNode(@Nullable Object node) {
        while (node != null) {
            if (node instanceof LoadingNode) {
                return true;
            }
            if (!(node instanceof DefaultMutableTreeNode)) {
                return false;
            }
            node = ((DefaultMutableTreeNode)node).getUserObject();
        }
        return false;
    }

    @Nullable
    public static Object getUserObject(@Nullable Object node) {
        TreeNodeViewModel nodeModel;
        TreeNodeDomainModel treeNodeDomainModel;
        if (node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            return treeNode.getUserObject();
        }
        if (node instanceof TreeNodeViewModel && (treeNodeDomainModel = (nodeModel = (TreeNodeViewModel)node).getDomainModel()) instanceof LegacyCompatibilityTreeNode) {
            LegacyCompatibilityTreeNode legacyNode = (LegacyCompatibilityTreeNode)((Object)treeNodeDomainModel);
            return legacyNode.getUserObject();
        }
        return node;
    }

    @Nullable
    public static <T> T getUserObject(@NotNull Class<T> type, @Nullable Object node) {
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(180);
        }
        return type.isInstance(node = TreeUtil.getUserObject(node)) ? (T)type.cast(node) : null;
    }

    @Nullable
    public static Object getLastUserObject(@Nullable TreePath path) {
        return path == null ? null : TreeUtil.getUserObject(path.getLastPathComponent());
    }

    @Nullable
    public static <T> T getLastUserObject(@NotNull Class<T> type, @Nullable TreePath path) {
        if (type == null) {
            TreeUtil.$$$reportNull$$$0(181);
        }
        return path == null ? null : (T)TreeUtil.getUserObject(type, path.getLastPathComponent());
    }

    @Nullable
    public static AbstractTreeNode<?> getAbstractTreeNode(@Nullable Object node) {
        return TreeUtil.getUserObject(AbstractTreeNode.class, node);
    }

    @Nullable
    public static AbstractTreeNode<?> getAbstractTreeNode(@Nullable TreePath path) {
        return TreeUtil.getLastUserObject(AbstractTreeNode.class, path);
    }

    @Nullable
    public static <T> T getParentNodeOfType(@Nullable AbstractTreeNode<?> node, @NotNull Class<T> aClass) {
        if (aClass == null) {
            TreeUtil.$$$reportNull$$$0(182);
        }
        for (AbstractTreeNode cur = node; cur != null; cur = cur.getParent()) {
            if (!aClass.isInstance(cur)) continue;
            return (T)cur;
        }
        return null;
    }

    @Nullable
    public static TreePath getSelectedPathIfOne(@Nullable JTree tree) {
        TreePath[] paths = tree == null ? null : tree.getSelectionPaths();
        return paths != null && paths.length == 1 ? paths[0] : null;
    }

    public static void ensureSelection(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(183);
        }
        if ((paths = tree.getSelectionPaths()) != null) {
            for (TreePath each : paths) {
                if (tree.getRowForPath(each) < 0 || !tree.isVisible(each)) continue;
                return;
            }
        }
        for (int eachRow = 0; eachRow < tree.getRowCount(); ++eachRow) {
            TreePath eachPath = tree.getPathForRow(eachRow);
            if (eachPath == null || !tree.isVisible(eachPath)) continue;
            tree.setSelectionPath(eachPath);
            break;
        }
    }

    public static <T extends MutableTreeNode> void insertNode(@NotNull T child, @NotNull T parent, @Nullable DefaultTreeModel model, @NotNull Comparator<? super T> comparator) {
        if (child == null) {
            TreeUtil.$$$reportNull$$$0(184);
        }
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(185);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(186);
        }
        TreeUtil.insertNode(child, parent, model, false, comparator);
    }

    public static <T extends MutableTreeNode> void insertNode(@NotNull T child, @NotNull T parent, @Nullable DefaultTreeModel model, boolean allowDuplication, @NotNull Comparator<? super T> comparator) {
        int insertionPoint;
        int index;
        if (child == null) {
            TreeUtil.$$$reportNull$$$0(187);
        }
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(188);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(189);
        }
        if ((index = TreeUtil.indexedBinarySearch(parent, child, comparator)) >= 0 && !allowDuplication) {
            LOG.error("Node " + String.valueOf(child) + " is already added to " + String.valueOf(parent));
            return;
        }
        int n = insertionPoint = index >= 0 ? index : -(index + 1);
        if (model != null) {
            model.insertNodeInto(child, parent, insertionPoint);
        } else {
            parent.insert(child, insertionPoint);
        }
    }

    public static <T extends TreeNode> int indexedBinarySearch(@NotNull T parent, @NotNull T key, @NotNull Comparator<? super T> comparator) {
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(190);
        }
        if (key == null) {
            TreeUtil.$$$reportNull$$$0(191);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(192);
        }
        return ObjectUtils.binarySearch((int)0, (int)parent.getChildCount(), mid -> comparator.compare(parent.getChildAt(mid), key));
    }

    @NotNull
    public static Comparator<TreePath> getDisplayOrderComparator(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(193);
        }
        Comparator<TreePath> comparator = Comparator.comparingInt(tree::getRowForPath);
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(194);
        }
        return comparator;
    }

    private static void expandPathWithDebug(@NotNull JTree tree, @NotNull TreePath path) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(195);
        }
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(196);
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("tree expand path: ", new Object[]{path});
        }
        tree.expandPath(path);
    }

    public static void expand(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(197);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(198);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(199);
        }
        TreeUtil.promiseMakeVisibleOne(tree, visitor, path -> {
            TreeUtil.expandPathWithDebug(tree, path);
            consumer.accept((TreePath)path);
        });
    }

    @NotNull
    public static @NotNull Promise<@NotNull TreePath> promiseExpand(@NotNull JTree tree, @NotNull TreePath path) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(200);
        }
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(201);
        }
        return TreeUtil.promiseExpand(tree, (TreeVisitor)new TreeVisitor.ByTreePath(path, node -> node));
    }

    @NotNull
    public static @NotNull Promise<@NotNull TreePath> promiseExpand(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(202);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(203);
        }
        return TreeUtil.promiseMakeVisibleOne(tree, visitor, path -> TreeUtil.expandPathWithDebug(tree, path));
    }

    @NotNull
    public static Promise<List<TreePath>> promiseExpand(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(204);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(205);
        }
        Promise<List<TreePath>> promise = TreeUtil.promiseMakeVisibleAll(tree, visitors, paths -> TreeUtil.expandPaths(tree, paths));
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(206);
        }
        return promise;
    }

    public static void makeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(207);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(208);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(209);
        }
        TreeUtil.promiseMakeVisibleOne(tree, visitor, consumer);
    }

    @NotNull
    public static @NotNull Promise<@NotNull TreePath> promiseMakeVisible(@NotNull JTree tree, @NotNull TreePath path) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(210);
        }
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(211);
        }
        return TreeUtil.promiseMakeVisible(tree, (TreeVisitor)new TreeVisitor.ByTreePath(path, node -> node));
    }

    @NotNull
    public static @NotNull Promise<@NotNull TreePath> promiseMakeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(212);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(213);
        }
        return TreeUtil.promiseMakeVisibleOne(tree, visitor, null);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static @NotNull Promise<@NotNull TreePath> promiseMakeVisibleOne(@NotNull JTree tree, @NotNull TreeVisitor visitor, @Nullable Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(214);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(215);
        }
        @NotNull AsyncPromise promise = new AsyncPromise();
        TreeUtil.promiseMakeVisible(tree, visitor, promise).onError(arg_0 -> ((AsyncPromise)promise).setError(arg_0)).onSuccess(path -> {
            if (promise.isCancelled()) {
                return;
            }
            EdtInvocationManager.invokeLaterIfNeeded(() -> WriteIntentReadAction.run(() -> {
                if (promise.isCancelled()) {
                    return;
                }
                if (tree.isVisible((TreePath)path)) {
                    if (consumer != null) {
                        consumer.accept((TreePath)path);
                    }
                    promise.setResult(path);
                } else {
                    promise.cancel();
                }
            }));
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(216);
        }
        return asyncPromise;
    }

    @NotNull
    public static Promise<List<TreePath>> promiseMakeVisible(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(217);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(218);
        }
        Promise<List<TreePath>> promise = TreeUtil.promiseMakeVisibleAll(tree, visitors, null);
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(219);
        }
        return promise;
    }

    private static Promise<List<TreePath>> promiseMakeVisibleAll(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors, @Nullable Consumer<? super List<TreePath>> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(220);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(221);
        }
        AsyncPromise promise = new AsyncPromise();
        return TreeUtil.promiseVisitAll(tree, visitors, (AsyncPromise<List<TreePath>>)promise, visitor -> TreeUtil.promiseMakeVisible(tree, visitor, promise), consumer);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Promise<List<TreePath>> promiseVisitAll(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors, @NotNull AsyncPromise<List<TreePath>> promise, @NotNull Function<? super TreeVisitor, Promise<@Nullable TreePath>> visitAction, @Nullable Consumer<? super List<TreePath>> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(222);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(223);
        }
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(224);
        }
        if (visitAction == null) {
            TreeUtil.$$$reportNull$$$0(225);
        }
        List<@Nullable T> promises = visitors.filter(Objects::nonNull).map(visitAction).collect(Collectors.toList());
        Promises.collectResults(promises, (boolean)true).onError(arg_0 -> promise.setError(arg_0)).onSuccess(paths -> {
            if (promise.isCancelled()) {
                return;
            }
            if (!ContainerUtil.isEmpty((Collection)paths)) {
                EdtInvocationManager.invokeLaterIfNeeded(() -> {
                    if (promise.isCancelled()) {
                        return;
                    }
                    List visible = ContainerUtil.filter((Collection)paths, tree::isVisible);
                    if (!ContainerUtil.isEmpty((Collection)visible)) {
                        if (consumer != null) {
                            consumer.accept(visible);
                        }
                        promise.setResult((Object)visible);
                    } else {
                        promise.cancel();
                    }
                });
            } else {
                promise.cancel();
            }
        });
        return promise;
    }

    private static @NotNull Promise<@Nullable TreePath> promiseMakeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull AsyncPromise<?> promise) {
        MakeVisibleVisitor makeVisibleVisitor;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(226);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(227);
        }
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(228);
        }
        MakeVisibleVisitor makeVisibleVisitor2 = makeVisibleVisitor = !(tree.getModel() instanceof TreeVisitor.Acceptor) && Tree.isBulkExpandCollapseSupported() ? new BulkMakeVisibleVisitor(tree, visitor, promise) : new BackgroundMakeVisibleVisitor(tree, visitor, promise);
        if (tree instanceof Tree) {
            Tree jbTree = (Tree)tree;
            jbTree.suspendExpandCollapseAccessibilityAnnouncements();
        }
        Promise promise2 = TreeUtil.promiseVisit(tree, (TreeVisitor)makeVisibleVisitor).onProcessed(path -> makeVisibleVisitor.finish());
        if (promise2 == null) {
            TreeUtil.$$$reportNull$$$0(229);
        }
        return promise2;
    }

    @NotNull
    public static Promise<TreePath> promiseSelect(@NotNull JTree tree, @NotNull TreePath path) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(230);
        }
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(231);
        }
        return TreeUtil.promiseSelect(tree, (TreeVisitor)new TreeVisitor.ByTreePath(path, node -> node));
    }

    @NotNull
    public static Promise<TreePath> promiseSelect(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(232);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(233);
        }
        return TreeUtil.promiseMakeVisibleOne(tree, visitor, path -> TreeUtil.internalSelect(tree, path));
    }

    @NotNull
    public static Promise<List<TreePath>> promiseSelect(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(234);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(235);
        }
        Promise<List<TreePath>> promise = TreeUtil.promiseMakeVisibleAll(tree, visitors, paths -> TreeUtil.internalSelect(tree, paths.toArray(EMPTY_TREE_PATH)));
        if (promise == null) {
            TreeUtil.$$$reportNull$$$0(236);
        }
        return promise;
    }

    private static void internalSelect(@NotNull JTree tree, TreePath ... paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(237);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(238);
        }
        assert (EventQueue.isDispatchThread());
        if (paths.length == 0) {
            return;
        }
        tree.setSelectionPaths(paths);
        for (TreePath path : paths) {
            if (TreeUtil.scrollToVisible(tree, path, Registry.is((String)"ide.tree.autoscrollToVCenter", (boolean)false))) break;
        }
    }

    public static boolean scrollToVisible(@NotNull JTree tree, @NotNull TreePath path, boolean centered) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(239);
        }
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(240);
        }
        assert (EventQueue.isDispatchThread());
        Rectangle bounds = tree.getPathBounds(path);
        if (bounds == null) {
            if (LOG.isTraceEnabled()) {
                LOG.debug("cannot scroll to: ", new Object[]{path});
            }
            return false;
        }
        TreeUtil.internalScroll(tree, bounds, centered);
        AccessibleContext context = tree.getAccessibleContext();
        if (context != null) {
            context.firePropertyChange("AccessibleVisibleData", false, true);
        }
        long stamp = 1L + TreeUtil.getScrollTimeStamp(tree);
        tree.putClientProperty(TREE_UTIL_SCROLL_TIME_STAMP, stamp);
        ClientProperty.put((JComponent)tree, TREE_IS_BUSY, (Object)true);
        EdtScheduler.getInstance().schedule(5, () -> {
            Rectangle boundsLater;
            Rectangle rectangle = boundsLater = stamp != TreeUtil.getScrollTimeStamp(tree) ? null : tree.getPathBounds(path);
            if (boundsLater != null) {
                TreeUtil.internalScroll(tree, boundsLater, centered);
            }
            ClientProperty.remove((JComponent)tree, TREE_IS_BUSY);
        });
        return true;
    }

    private static void internalScroll(@NotNull JTree tree, @NotNull Rectangle bounds, boolean centered) {
        JViewport viewport;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(241);
        }
        if (bounds == null) {
            TreeUtil.$$$reportNull$$$0(242);
        }
        if ((viewport = ComponentUtil.getViewport((Component)tree)) != null) {
            int width = viewport.getWidth();
            if (!centered && tree instanceof Tree && !((Tree)tree).isHorizontalAutoScrollingEnabled()) {
                bounds.x = -tree.getX();
                bounds.width = width;
            } else {
                int control = JBUIScale.scale((int)20);
                bounds.x = Math.max(0, bounds.x - control);
                bounds.width = bounds.x > 0 ? Math.min(bounds.width + control, centered ? width : width / 2) : width;
            }
            int height = viewport.getHeight();
            if (height > bounds.height && height < tree.getHeight()) {
                int y;
                if (centered || height < bounds.height * 5) {
                    bounds.y -= (height - bounds.height) / 2;
                    bounds.height = height;
                } else {
                    bounds.y -= bounds.height * 2;
                    bounds.height *= 5;
                }
                if (bounds.y < 0) {
                    bounds.height += bounds.y;
                    bounds.y = 0;
                }
                if ((y = bounds.y + bounds.height - tree.getHeight()) > 0) {
                    bounds.height -= y;
                }
            }
        }
        tree.scrollRectToVisible(bounds);
    }

    private static long getScrollTimeStamp(@NotNull JTree tree) {
        Object property;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(243);
        }
        return (property = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP)) instanceof Long ? (Long)property : Long.MIN_VALUE;
    }

    @NotNull
    public static Promise<TreePath> promiseSelectFirst(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(244);
        }
        return TreeUtil.promiseSelect(tree, path -> TreeUtil.isHiddenRoot(tree, path) ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.INTERRUPT);
    }

    private static boolean isHiddenRoot(@NotNull JTree tree, @NotNull TreePath path) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(245);
        }
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(246);
        }
        return !tree.isRootVisible() && path.getParentPath() == null;
    }

    @NotNull
    public static @NotNull Promise<@NotNull TreePath> promiseSelectFirstLeaf(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(247);
        }
        AtomicReference reference = new AtomicReference();
        AsyncPromise promise = new AsyncPromise();
        TreeUtil.promiseMakeVisible(tree, path -> {
            TreePath parent = reference.getAndSet(path);
            if (TreeUtil.getPathCount(parent) == TreeUtil.getPathCount(path.getParentPath())) {
                return TreeVisitor.Action.CONTINUE;
            }
            TreeUtil.internalSelect(tree, parent);
            promise.setResult((Object)parent);
            return TreeVisitor.Action.INTERRUPT;
        }, promise).onError(arg_0 -> ((AsyncPromise)promise).setError(arg_0)).onSuccess(path -> {
            if (!promise.isDone()) {
                TreePath tail = (TreePath)reference.get();
                if (tail == null || TreeUtil.isHiddenRoot(tree, tail)) {
                    promise.cancel();
                } else {
                    TreeUtil.internalSelect(tree, tail);
                    promise.setResult((Object)tail);
                }
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(248);
        }
        return asyncPromise;
    }

    private static int getPathCount(@Nullable TreePath path) {
        return path == null ? 0 : path.getPathCount();
    }

    public static void visit(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(249);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(250);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(251);
        }
        TreeUtil.promiseVisit(tree, visitor).onSuccess(path -> EdtInvocationManager.invokeLaterIfNeeded(() -> consumer.accept((TreePath)path)));
    }

    public static @NotNull Promise<@Nullable TreePath> promiseVisit(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        TreeModel model;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(252);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(253);
        }
        if ((model = tree.getModel()) instanceof TreeVisitor.Acceptor) {
            TreeVisitor.Acceptor acceptor = (TreeVisitor.Acceptor)model;
            Promise promise = acceptor.accept(visitor);
            if (promise == null) {
                TreeUtil.$$$reportNull$$$0(254);
            }
            return promise;
        }
        if (model == null) {
            Promise promise = Promises.rejectedPromise((String)"tree model is not set");
            if (promise == null) {
                TreeUtil.$$$reportNull$$$0(255);
            }
            return promise;
        }
        AsyncPromise promise = new AsyncPromise();
        EdtInvocationManager.invokeLaterIfNeeded(() -> ReadAction.run(() -> promise.setResult((Object)TreeUtil.visitModel(model, visitor))));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            TreeUtil.$$$reportNull$$$0(256);
        }
        return asyncPromise;
    }

    @ApiStatus.Internal
    public static Promise<List<TreePath>> promiseVisit(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors, @Nullable Consumer<? super List<TreePath>> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(257);
        }
        if (visitors == null) {
            TreeUtil.$$$reportNull$$$0(258);
        }
        AsyncPromise promise = new AsyncPromise();
        return TreeUtil.promiseVisitAll(tree, visitors, (AsyncPromise<List<TreePath>>)promise, visitor -> TreeUtil.promiseVisit(tree, visitor), consumer);
    }

    @Nullable
    private static TreePath visitModel(@NotNull TreeModel model, @NotNull TreeVisitor visitor) {
        Object root;
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(259);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(260);
        }
        if ((root = model.getRoot()) == null) {
            return null;
        }
        TreePath path = new CachingTreePath(root);
        switch (visitor.visit(path)) {
            case INTERRUPT: {
                return path;
            }
            case CONTINUE: {
                break;
            }
            default: {
                return null;
            }
        }
        ArrayDeque<Deque<TreePath>> stack = new ArrayDeque<Deque<TreePath>>();
        stack.push(TreeUtil.children(model, path));
        while (path != null) {
            Deque siblings = (Deque)stack.peek();
            if (siblings == null) {
                return null;
            }
            TreePath next = (TreePath)siblings.poll();
            if (next == null) {
                LOG.assertTrue(siblings == stack.poll());
                path = path.getParentPath();
                continue;
            }
            switch (visitor.visit(next)) {
                case INTERRUPT: {
                    return next;
                }
                case CONTINUE: {
                    path = next;
                    stack.push(TreeUtil.children(model, path));
                    break;
                }
                case SKIP_SIBLINGS: {
                    siblings.clear();
                    break;
                }
            }
        }
        LOG.assertTrue(stack.isEmpty());
        return null;
    }

    @NotNull
    private static Deque<TreePath> children(@NotNull TreeModel model, @NotNull TreePath path) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(261);
        }
        if (path == null) {
            TreeUtil.$$$reportNull$$$0(262);
        }
        Object object = path.getLastPathComponent();
        int count = model.getChildCount(object);
        ArrayDeque<TreePath> deque = new ArrayDeque<TreePath>(count);
        for (int i = 0; i < count; ++i) {
            deque.add(path.pathByAddingChild(model.getChild(object, i)));
        }
        ArrayDeque<TreePath> arrayDeque = deque;
        if (arrayDeque == null) {
            TreeUtil.$$$reportNull$$$0(263);
        }
        return arrayDeque;
    }

    public static TreePath visitVisibleRows(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(264);
        }
        if (visitor == null) {
            TreeUtil.$$$reportNull$$$0(265);
        }
        TreePath parent = null;
        int count = tree.getRowCount();
        block6: for (int row = 0; row < count; ++row) {
            TreePath path = TreeUtil.getVisiblePathWithValidation(tree, row, count);
            if (parent != null && parent.isDescendant(path)) continue;
            switch (visitor.visit(path)) {
                case INTERRUPT: {
                    return path;
                }
                case CONTINUE: {
                    parent = null;
                    continue block6;
                }
                case SKIP_CHILDREN: {
                    parent = path;
                    continue block6;
                }
                case SKIP_SIBLINGS: {
                    parent = path.getParentPath();
                    if (parent != null) continue block6;
                    return null;
                }
            }
        }
        return null;
    }

    public static <T> void visitVisibleRows(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper, @NotNull Consumer<? super T> consumer) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(266);
        }
        if (mapper == null) {
            TreeUtil.$$$reportNull$$$0(267);
        }
        if (consumer == null) {
            TreeUtil.$$$reportNull$$$0(268);
        }
        TreeUtil.visitVisibleRows(tree, path -> {
            Object object = mapper.apply(path);
            if (object != null) {
                consumer.accept((Object)object);
            }
            return TreeVisitor.Action.CONTINUE;
        });
    }

    @Nullable
    public static TreePath nextVisibleSibling(@NotNull JTree tree, @Nullable TreePath lead) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(269);
        }
        TreePath parent = lead == null ? null : lead.getParentPath();
        return parent == null ? null : TreeUtil.nextVisiblePath(tree, lead, (? super TreePath path) -> parent.equals(path.getParentPath()));
    }

    @Nullable
    public static TreePath nextVisiblePath(@NotNull JTree tree, TreePath path, @NotNull Predicate<? super TreePath> predicate2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(270);
        }
        if (predicate2 == null) {
            TreeUtil.$$$reportNull$$$0(271);
        }
        return TreeUtil.nextVisiblePath(tree, tree.getRowForPath(path), predicate2);
    }

    @Nullable
    public static TreePath nextVisiblePath(@NotNull JTree tree, int row, @NotNull Predicate<? super TreePath> predicate2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(272);
        }
        if (predicate2 == null) {
            TreeUtil.$$$reportNull$$$0(273);
        }
        return TreeUtil.nextVisiblePath(tree, row, TreeUtil.isCyclicScrollingAllowed(), predicate2);
    }

    @Nullable
    public static TreePath nextVisiblePath(@NotNull JTree tree, int row, boolean cyclic, @NotNull Predicate<? super TreePath> predicate2) {
        TreePath path;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(274);
        }
        if (predicate2 == null) {
            TreeUtil.$$$reportNull$$$0(275);
        }
        assert (EventQueue.isDispatchThread());
        if (row < 0) {
            return null;
        }
        int count = tree.getRowCount();
        if (count <= row) {
            return null;
        }
        int stop = row;
        do {
            if (++row == count && cyclic) {
                row = 0;
            }
            if (row == count) {
                return null;
            }
            if (row != stop) continue;
            return null;
        } while ((path = tree.getPathForRow(row)) == null || !predicate2.test(path));
        return path;
    }

    @Nullable
    public static TreePath previousVisibleSibling(@NotNull JTree tree, @Nullable TreePath lead) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(276);
        }
        TreePath parent = lead == null ? null : lead.getParentPath();
        return parent == null ? null : TreeUtil.previousVisiblePath(tree, lead, (? super TreePath path) -> parent.equals(path.getParentPath()));
    }

    @Nullable
    public static TreePath previousVisiblePath(@NotNull JTree tree, TreePath path, @NotNull Predicate<? super TreePath> predicate2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(277);
        }
        if (predicate2 == null) {
            TreeUtil.$$$reportNull$$$0(278);
        }
        return TreeUtil.previousVisiblePath(tree, tree.getRowForPath(path), predicate2);
    }

    @Nullable
    public static TreePath previousVisiblePath(@NotNull JTree tree, int row, @NotNull Predicate<? super TreePath> predicate2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(279);
        }
        if (predicate2 == null) {
            TreeUtil.$$$reportNull$$$0(280);
        }
        return TreeUtil.previousVisiblePath(tree, row, TreeUtil.isCyclicScrollingAllowed(), predicate2);
    }

    @Nullable
    public static TreePath previousVisiblePath(@NotNull JTree tree, int row, boolean cyclic, @NotNull Predicate<? super TreePath> predicate2) {
        TreePath path;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(281);
        }
        if (predicate2 == null) {
            TreeUtil.$$$reportNull$$$0(282);
        }
        assert (EventQueue.isDispatchThread());
        if (row < 0) {
            return null;
        }
        int count = tree.getRowCount();
        if (count <= row) {
            return null;
        }
        int stop = row;
        do {
            if (row == 0 && cyclic) {
                row = count;
            }
            if (row == 0) {
                return null;
            }
            if (--row != stop) continue;
            return null;
        } while ((path = tree.getPathForRow(row)) == null || !predicate2.test(path));
        return path;
    }

    public static boolean isCyclicScrollingAllowed() {
        if (ScreenReader.isActive()) {
            return false;
        }
        if (!Registry.is((String)"ide.tree.ui.cyclic.scrolling.allowed")) {
            return false;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        return settings != null && settings.getCycleScrolling();
    }

    @NotNull
    private static TreePath getVisiblePathWithValidation(@NotNull JTree tree, int row, int count) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(283);
        }
        if (count != tree.getRowCount()) {
            throw new ConcurrentModificationException("tree is modified");
        }
        TreePath path = tree.getPathForRow(row);
        if (path == null) {
            throw new NullPointerException("path is not found at row " + row);
        }
        TreePath treePath = path;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(284);
        }
        return treePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9, 10, 11, 24, 25, 36, 37, 38, 39, 48, 57, 59, 63, 66, 67, 85, 87, 89, 101, 102, 103, 104, 105, 106, 107, 119, 120, 125, 136, 140, 142, 143, 157, 161, 162, 172, 194, 206, 216, 219, 229, 236, 248, 254, 255, 256, 263, 284 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 8: 
            case 49: 
            case 64: 
            case 68: 
            case 259: 
            case 261: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 24: 
            case 25: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 48: 
            case 57: 
            case 59: 
            case 63: 
            case 66: 
            case 67: 
            case 85: 
            case 87: 
            case 89: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 119: 
            case 120: 
            case 125: 
            case 136: 
            case 140: 
            case 142: 
            case 143: 
            case 157: 
            case 161: 
            case 162: 
            case 172: 
            case 194: 
            case 206: 
            case 216: 
            case 219: 
            case 229: 
            case 236: 
            case 248: 
            case 254: 
            case 255: 
            case 256: 
            case 263: 
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/tree/TreeUtil";
                break;
            }
            case 13: 
            case 45: 
            case 46: 
            case 47: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 76: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverser";
                break;
            }
            case 23: 
            case 35: 
            case 149: 
            case 156: 
            case 160: 
            case 267: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 28: 
            case 180: 
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 30: 
            case 32: 
            case 34: 
            case 151: 
            case 153: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 41: 
            case 80: 
            case 82: 
            case 238: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aRootNode";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aNode";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 52: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBeRemoved";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aRoot";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 75: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverse";
                break;
            }
            case 118: 
            case 121: 
            case 137: 
            case 145: 
            case 167: 
            case 196: 
            case 201: 
            case 211: 
            case 231: 
            case 240: 
            case 246: 
            case 262: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 128: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onDone";
                break;
            }
            case 135: 
            case 271: 
            case 273: 
            case 275: 
            case 278: 
            case 280: 
            case 282: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 164: 
            case 165: 
            case 171: 
            case 173: 
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aTree";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aBounds";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 179: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePoint";
                break;
            }
            case 182: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 184: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 185: 
            case 188: 
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 186: 
            case 189: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 198: 
            case 203: 
            case 208: 
            case 213: 
            case 215: 
            case 227: 
            case 233: 
            case 250: 
            case 253: 
            case 260: 
            case 265: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 199: 
            case 209: 
            case 251: 
            case 268: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 205: 
            case 218: 
            case 221: 
            case 223: 
            case 235: 
            case 258: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitors";
                break;
            }
            case 224: 
            case 228: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitAction";
                break;
            }
            case 242: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/tree/TreeUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "modelTraverser";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "treePathTraverser";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeChildren";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "treeNodeTraverser";
                break;
            }
            case 24: 
            case 25: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExpandedObjects";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFromRootTo";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFirstNode";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstNodePath";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstLeafNodePath";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastPathComponent";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "selectPath";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "moveDown";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "moveUp";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "showAndSelect";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "listChildren";
                break;
            }
            case 136: 
            case 206: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseExpand";
                break;
            }
            case 140: 
            case 142: 
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "selectInTree";
                break;
            }
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedObjects";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 172: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointForSelection";
                break;
            }
            case 194: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayOrderComparator";
                break;
            }
            case 216: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseMakeVisibleOne";
                break;
            }
            case 219: 
            case 229: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseMakeVisible";
                break;
            }
            case 236: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseSelect";
                break;
            }
            case 248: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseSelectFirstLeaf";
                break;
            }
            case 254: 
            case 255: 
            case 256: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseVisit";
                break;
            }
            case 263: {
                objectArray = objectArray2;
                objectArray2[1] = "children";
                break;
            }
            case 284: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisiblePathWithValidation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setNavigatableProvider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "treeTraverser";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "modelTraverser";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 24: 
            case 25: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 48: 
            case 57: 
            case 59: 
            case 63: 
            case 66: 
            case 67: 
            case 85: 
            case 87: 
            case 89: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 119: 
            case 120: 
            case 125: 
            case 136: 
            case 140: 
            case 142: 
            case 143: 
            case 157: 
            case 161: 
            case 162: 
            case 172: 
            case 194: 
            case 206: 
            case 216: 
            case 219: 
            case 229: 
            case 236: 
            case 248: 
            case 254: 
            case 255: 
            case 256: 
            case 263: 
            case 284: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "treePathTraverser";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "nodeChildren";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasManyNodes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPathForLocation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRowForLocation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "repaintPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "repaintRow";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "repaintBounds";
                break;
            }
            case 20: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectExpandedPaths";
                break;
            }
            case 21: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectExpandedUserObjects";
                break;
            }
            case 22: 
            case 23: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collectExpandedObjects";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findObjectInPath";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedObjectsOfType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "restoreExpandedPaths";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromRoot";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromRootTo";
                break;
            }
            case 49: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findNodeWithObject";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "removeSelected";
                break;
            }
            case 51: 
            case 52: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "removeLastPathComponent";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findNode";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "selectFirstNode";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNodePath";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getRowForNode";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLeafNodePath";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "sortRecursively";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "sortChildren";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenTo";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "traverseDepth";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "selectRow";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "selectPaths";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "selectPath";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "moveDown";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "moveUp";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "movePageUp";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "movePageDown";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "moveHome";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "moveEnd";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "showRowCentred";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "showRowCentered";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "showAndSelect";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRow";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "getFirstVisibleRow";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRowCount";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "installActions";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "copyAction";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "collapseAll";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isBulkExpandCollapseSupported";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "expandPaths";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "collapsePaths";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysExpand";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "selectNode";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedRow";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "listChildren";
                break;
            }
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "expandAll";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "promiseExpandAll";
                break;
            }
            case 130: 
            case 131: 
            case 132: 
            case 197: 
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "promiseExpand";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "isIncludedInExpandAll";
                break;
            }
            case 138: 
            case 139: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "selectInTree";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "isViewable";
                break;
            }
            case 146: 
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedPaths";
                break;
            }
            case 147: 
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedUserObjects";
                break;
            }
            case 148: 
            case 149: 
            case 154: 
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedObjects";
                break;
            }
            case 158: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "getSelection";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "unselectPath";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "getExpandControlRange";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "getDepthOffset";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray;
                objectArray[2] = "getNodeDepth";
                break;
            }
            case 168: {
                objectArray = objectArray;
                objectArray[2] = "getNodeRowX";
                break;
            }
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "isLocationInExpandControl";
                break;
            }
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "getPointForSelection";
                break;
            }
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "getPointForRow";
                break;
            }
            case 174: {
                objectArray = objectArray;
                objectArray[2] = "getPointForPath";
                break;
            }
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "getPointForBounds";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "isOverSelection";
                break;
            }
            case 178: 
            case 179: {
                objectArray = objectArray;
                objectArray[2] = "dropSelectionButUnderPoint";
                break;
            }
            case 180: {
                objectArray = objectArray;
                objectArray[2] = "getUserObject";
                break;
            }
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "getLastUserObject";
                break;
            }
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "getParentNodeOfType";
                break;
            }
            case 183: {
                objectArray = objectArray;
                objectArray[2] = "ensureSelection";
                break;
            }
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "insertNode";
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "indexedBinarySearch";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayOrderComparator";
                break;
            }
            case 195: 
            case 196: {
                objectArray = objectArray;
                objectArray[2] = "expandPathWithDebug";
                break;
            }
            case 207: 
            case 208: 
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "makeVisible";
                break;
            }
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 217: 
            case 218: 
            case 226: 
            case 227: 
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "promiseMakeVisible";
                break;
            }
            case 214: 
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "promiseMakeVisibleOne";
                break;
            }
            case 220: 
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "promiseMakeVisibleAll";
                break;
            }
            case 222: 
            case 223: 
            case 224: 
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "promiseVisitAll";
                break;
            }
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "promiseSelect";
                break;
            }
            case 237: 
            case 238: {
                objectArray = objectArray;
                objectArray[2] = "internalSelect";
                break;
            }
            case 239: 
            case 240: {
                objectArray = objectArray;
                objectArray[2] = "scrollToVisible";
                break;
            }
            case 241: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "internalScroll";
                break;
            }
            case 243: {
                objectArray = objectArray;
                objectArray[2] = "getScrollTimeStamp";
                break;
            }
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "promiseSelectFirst";
                break;
            }
            case 245: 
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "isHiddenRoot";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "promiseSelectFirstLeaf";
                break;
            }
            case 249: 
            case 250: 
            case 251: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 252: 
            case 253: 
            case 257: 
            case 258: {
                objectArray = objectArray;
                objectArray[2] = "promiseVisit";
                break;
            }
            case 259: 
            case 260: {
                objectArray = objectArray;
                objectArray[2] = "visitModel";
                break;
            }
            case 261: 
            case 262: {
                objectArray = objectArray;
                objectArray[2] = "children";
                break;
            }
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "visitVisibleRows";
                break;
            }
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "nextVisibleSibling";
                break;
            }
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: {
                objectArray = objectArray;
                objectArray[2] = "nextVisiblePath";
                break;
            }
            case 276: {
                objectArray = objectArray;
                objectArray[2] = "previousVisibleSibling";
                break;
            }
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: {
                objectArray = objectArray;
                objectArray[2] = "previousVisiblePath";
                break;
            }
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "getVisiblePathWithValidation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9, 10, 11, 24, 25, 36, 37, 38, 39, 48, 57, 59, 63, 66, 67, 85, 87, 89, 101, 102, 103, 104, 105, 106, 107, 119, 120, 125, 136, 140, 142, 143, 157, 161, 162, 172, 194, 206, 216, 219, 229, 236, 248, 254, 255, 256, 263, 284 -> new IllegalStateException(string);
        };
    }

    @Deprecated(forRemoval=true)
    @FunctionalInterface
    public static interface Traverse {
        public boolean accept(Object var1);
    }

    private static final class LazyRowX {
        static final Method METHOD = ReflectionUtil.getDeclaredMethod(BasicTreeUI.class, (String)"getRowX", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});

        private LazyRowX() {
        }
    }

    private static final class LazyLocationInExpandControl {
        static final Method METHOD = ReflectionUtil.getDeclaredMethod(BasicTreeUI.class, (String)"isLocationInExpandControl", (Class[])new Class[]{TreePath.class, Integer.TYPE, Integer.TYPE});

        private LazyLocationInExpandControl() {
        }
    }

    private static class BulkMakeVisibleVisitor
    extends MakeVisibleVisitor {
        @NotNull
        private final @NotNull List<@NotNull TreePath> pathsToExpand;

        private BulkMakeVisibleVisitor(@NotNull JTree tree, @NotNull TreeVisitor delegate, @NotNull AsyncPromise<?> promise) {
            if (tree == null) {
                BulkMakeVisibleVisitor.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                BulkMakeVisibleVisitor.$$$reportNull$$$0(1);
            }
            if (promise == null) {
                BulkMakeVisibleVisitor.$$$reportNull$$$0(2);
            }
            super(tree, delegate, promise);
            this.pathsToExpand = new ArrayList<TreePath>();
        }

        @Override
        protected boolean checkCancelled(@NotNull TreePath path) {
            if (path == null) {
                BulkMakeVisibleVisitor.$$$reportNull$$$0(3);
            }
            return false;
        }

        @Override
        protected void doExpand(@NotNull TreePath path) {
            if (path == null) {
                BulkMakeVisibleVisitor.$$$reportNull$$$0(4);
            }
            this.pathsToExpand.add(path);
        }

        @Override
        void finishExpanding() {
            TreeUtil.expandPaths(this.tree, this.pathsToExpand);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "promise";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/tree/TreeUtil$BulkMakeVisibleVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkCancelled";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExpand";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BackgroundMakeVisibleVisitor
    extends MakeVisibleVisitor {
        private BackgroundMakeVisibleVisitor(@NotNull JTree tree, @NotNull TreeVisitor delegate, @NotNull AsyncPromise<?> promise) {
            if (tree == null) {
                BackgroundMakeVisibleVisitor.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                BackgroundMakeVisibleVisitor.$$$reportNull$$$0(1);
            }
            if (promise == null) {
                BackgroundMakeVisibleVisitor.$$$reportNull$$$0(2);
            }
            super(tree, delegate, promise);
        }

        @Override
        protected boolean checkCancelled(@NotNull TreePath path) {
            if (path == null) {
                BackgroundMakeVisibleVisitor.$$$reportNull$$$0(3);
            }
            if (this.tree.isVisible(path)) {
                return false;
            }
            if (!this.promise.isCancelled()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("tree expand canceled");
                }
                this.promise.cancel();
            }
            return true;
        }

        @Override
        protected void doExpand(@NotNull TreePath path) {
            if (path == null) {
                BackgroundMakeVisibleVisitor.$$$reportNull$$$0(4);
            }
            TreeUtil.expandPathWithDebug(this.tree, path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "promise";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/tree/TreeUtil$BackgroundMakeVisibleVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkCancelled";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExpand";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MakeVisibleVisitor
    extends DelegatingEdtBgtTreeVisitor {
        protected final JTree tree;
        @NotNull
        protected final AsyncPromise<?> promise;
        @NotNull
        private final @NotNull Set<@NotNull TreePath> expandRoots;

        private MakeVisibleVisitor(@NotNull JTree tree, @NotNull TreeVisitor delegate, @NotNull AsyncPromise<?> promise) {
            if (tree == null) {
                MakeVisibleVisitor.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                MakeVisibleVisitor.$$$reportNull$$$0(1);
            }
            if (promise == null) {
                MakeVisibleVisitor.$$$reportNull$$$0(2);
            }
            super(delegate);
            this.expandRoots = new LinkedHashSet<TreePath>();
            this.tree = tree;
            this.promise = promise;
        }

        @Nullable
        public TreeVisitor.Action preVisitEDT(@NotNull TreePath path) {
            if (path == null) {
                MakeVisibleVisitor.$$$reportNull$$$0(3);
            }
            return this.promise.isCancelled() ? TreeVisitor.Action.SKIP_SIBLINGS : null;
        }

        @NotNull
        public TreeVisitor.Action postVisitEDT(@NotNull TreePath path, @NotNull TreeVisitor.Action action) {
            if (path == null) {
                MakeVisibleVisitor.$$$reportNull$$$0(4);
            }
            if (action == null) {
                MakeVisibleVisitor.$$$reportNull$$$0(5);
            }
            if (action == TreeVisitor.Action.CONTINUE || action == TreeVisitor.Action.INTERRUPT) {
                if (this.checkCancelled(path)) {
                    TreeVisitor.Action action2 = TreeVisitor.Action.SKIP_SIBLINGS;
                    if (action2 == null) {
                        MakeVisibleVisitor.$$$reportNull$$$0(6);
                    }
                    return action2;
                }
                TreeModel model = this.tree.getModel();
                if (action == TreeVisitor.Action.CONTINUE && model != null && !model.isLeaf(path.getLastPathComponent()) && !this.tree.isExpanded(path)) {
                    if (!this.isUnderExpandRoot(path)) {
                        this.expandRoots.add(path);
                    }
                    this.doExpand(path);
                }
            }
            TreeVisitor.Action action3 = action;
            if (action3 == null) {
                MakeVisibleVisitor.$$$reportNull$$$0(7);
            }
            return action3;
        }

        protected abstract boolean checkCancelled(@NotNull TreePath var1);

        protected abstract void doExpand(@NotNull TreePath var1);

        private boolean isUnderExpandRoot(@NotNull TreePath path) {
            if (path == null) {
                MakeVisibleVisitor.$$$reportNull$$$0(8);
            }
            for (TreePath parent = path.getParentPath(); parent != null; parent = parent.getParentPath()) {
                if (!this.expandRoots.contains(parent)) continue;
                return true;
            }
            return false;
        }

        final void finish() {
            this.finishExpanding();
            this.announceExpanded();
        }

        void finishExpanding() {
        }

        void announceExpanded() {
            JTree jTree = this.tree;
            if (jTree instanceof Tree) {
                Tree jbTree = (Tree)jTree;
                jbTree.resumeExpandCollapseAccessibilityAnnouncements();
                for (TreePath expandRoot : this.expandRoots) {
                    jbTree.fireAccessibleTreeExpanded(expandRoot);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "promise";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/tree/TreeUtil$MakeVisibleVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/tree/TreeUtil$MakeVisibleVisitor";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "postVisitEDT";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "preVisitEDT";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "postVisitEDT";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnderExpandRoot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

