/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypeParameterList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/quickfix/PyRemoveTypeParameterQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.python.psi.impl"})
public final class PyRemoveTypeParameterQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.remove.type.parameter", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        PyTypeParameter pyTypeParameter = (PyTypeParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PyTypeParameter.class, (boolean)false);
        if (pyTypeParameter == null) {
            return;
        }
        PyTypeParameter typeParameter = pyTypeParameter;
        PyTypeParameterList pyTypeParameterList = (PyTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)typeParameter), PyTypeParameterList.class, (boolean)false);
        if (pyTypeParameterList == null) {
            return;
        }
        PyTypeParameterList list = pyTypeParameterList;
        PsiElement prev = typeParameter.getPrevSibling();
        PsiElement next = typeParameter.getNextSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = ((PsiWhiteSpace)prev).getPrevSibling();
        }
        if (next instanceof PsiWhiteSpace) {
            next = ((PsiWhiteSpace)next).getNextSibling();
        }
        if (prev != null && Intrinsics.areEqual((Object)prev.getNode().getElementType(), (Object)PyTokenTypes.COMMA)) {
            prev.delete();
            PsiElement afterComma = typeParameter.getPrevSibling();
            if (afterComma instanceof PsiWhiteSpace) {
                ((PsiWhiteSpace)afterComma).delete();
            }
        } else if (next != null && Intrinsics.areEqual((Object)next.getNode().getElementType(), (Object)PyTokenTypes.COMMA)) {
            PsiElement ws = next.getNextSibling();
            next.delete();
            if (ws instanceof PsiWhiteSpace) {
                ((PsiWhiteSpace)ws).delete();
            }
        }
        typeParameter.delete();
        if (list.getTypeParameters().isEmpty()) {
            ((PyElement)list).delete();
        }
    }
}

