/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.python.extensions.PyClassExtKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.pyTestFixtures.PyTestFixtureUtilsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"isTestFunction", "", "function", "Lcom/jetbrains/python/psi/PyFunction;", "isUnitTestCaseClass", "clazz", "Lcom/jetbrains/python/psi/PyClass;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "isTestClass", "isTestFile", "file", "Lcom/jetbrains/python/psi/PyFile;", "isTestElement", "element", "Lcom/intellij/psi/PsiElement;", "typeEvalContext", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPythonUnitTestDetectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonUnitTestDetectors.kt\ncom/jetbrains/python/testing/PythonUnitTestDetectorsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n13225#2,2:104\n13225#2,2:106\n13225#2,2:114\n1807#3,3:108\n1807#3,3:111\n*S KotlinDebug\n*F\n+ 1 PythonUnitTestDetectors.kt\ncom/jetbrains/python/testing/PythonUnitTestDetectorsKt\n*L\n27#1:104,2\n70#1:106,2\n94#1:114,2\n81#1:108,3\n87#1:111,3\n*E\n"})
public final class PythonUnitTestDetectorsKt {
    public static final boolean isTestFunction(@NotNull PyFunction function) {
        boolean bl;
        block3: {
            PyDecorator[] decoratorList;
            boolean isTestNamed;
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            String string = function.getName();
            boolean bl2 = string != null ? StringsKt.startsWith$default((String)string, (String)"test", (boolean)false, (int)2, null) : (isTestNamed = false);
            if (!isTestNamed) {
                return false;
            }
            PyDecorator[] pyDecoratorArray = (PyDecorator[])function.getDecoratorList();
            if (pyDecoratorArray == null || (pyDecoratorArray = pyDecoratorArray.getDecorators()) == null) {
                return true;
            }
            PyDecorator[] $this$any$iv = decoratorList = pyDecoratorArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String decoratorName;
                PyDecorator element$iv;
                PyDecorator decorator = element$iv = $this$any$iv[i];
                boolean bl3 = false;
                PyExpression pyExpression = decorator.getCallee();
                String string2 = decoratorName = pyExpression != null ? pyExpression.getText() : null;
                if (!CollectionsKt.contains((Iterable)PyTestFixtureUtilsKt.getTEST_FIXTURE_DECORATOR_NAMES(), (Object)decoratorName)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        boolean isPytestFixture = bl;
        return !isPytestFixture;
    }

    public static final boolean isUnitTestCaseClass(@NotNull PyClass clazz, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String[] stringArray = new String[]{"unittest.TestCase", "unittest.case.TestCase"};
        return PyClassExtKt.inherits(clazz, context, stringArray);
    }

    public static final boolean isTestClass(@NotNull PyClass clazz, @NotNull TypeEvalContext context) {
        boolean bl;
        Ref.BooleanRef hasTestMethod;
        block6: {
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (PythonUnitTestDetectorsKt.isUnitTestCaseClass(clazz, context)) {
                return true;
            }
            String string = clazz.getName();
            if (string == null) {
                return false;
            }
            String className = string;
            if (!StringsKt.startsWith$default((String)className, (String)"Test", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)className, (String)"Test", (boolean)false, (int)2, null)) {
                return false;
            }
            hasTestMethod = new Ref.BooleanRef();
            clazz.visitMethods((Processor)new Processor<PyFunction>(hasTestMethod){
                final /* synthetic */ Ref.BooleanRef $hasTestMethod;
                {
                    this.$hasTestMethod = $hasTestMethod;
                }

                public boolean process(PyFunction function) {
                    block4: {
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                            if (PythonUnitTestDetectorsKt.isTestFunction(function)) break block3;
                            String string = function.getName();
                            boolean bl = string != null ? string.equals("setUp") : false;
                            if (!bl) break block4;
                        }
                        this.$hasTestMethod.element = true;
                        return false;
                    }
                    return true;
                }
            }, true, context);
            PyStatement[] pyStatementArray = clazz.getStatementList().getStatements();
            if (pyStatementArray != null) {
                PyStatement[] $this$any$iv = pyStatementArray;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    PyStatement element$iv;
                    PyStatement stmt = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!(stmt instanceof PyClass && PythonUnitTestDetectorsKt.isTestClass((PyClass)stmt, context))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        boolean hasTestInNested = bl;
        return hasTestMethod.element || hasTestInNested;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTestFile(@NotNull PyFile file, @NotNull TypeEvalContext context) {
        PyClass o;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List list = file.getTopLevelClasses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTopLevelClasses(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                o = (PyClass)element$iv;
                boolean bl2 = false;
                if (!PythonUnitTestDetectorsKt.isTestClass(o, context)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) {
            return true;
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string, (String)"test_", (boolean)false, (int)2, null)) return true;
        List list2 = file.getTopLevelFunctions();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTopLevelFunctions(...)");
        $this$any$iv = list2;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            o = (PyFunction)element$iv;
            boolean bl3 = false;
        } while (!PythonUnitTestDetectorsKt.isTestFunction((PyFunction)o));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTestElement(@NotNull PsiElement element, @NotNull TypeEvalContext typeEvalContext) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)typeEvalContext, (String)"typeEvalContext");
        PsiElement psiElement = element;
        if (psiElement instanceof PyFile) {
            bl = PythonUnitTestDetectorsKt.isTestFile((PyFile)element, typeEvalContext);
            return bl;
        } else {
            if (psiElement instanceof PsiDirectory) {
                String string = ((PsiDirectory)element).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.contains((CharSequence)string, (CharSequence)"test", (boolean)true)) return true;
                PsiElement[] psiElementArray = ((PsiDirectory)element).getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                Object[] $this$any$iv = psiElementArray;
                boolean $i$f$any = false;
                int n = 0;
                int n2 = $this$any$iv.length;
                while (n < n2) {
                    Object element$iv = $this$any$iv[n];
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (it instanceof PyFile && PythonUnitTestDetectorsKt.isTestFile((PyFile)it, typeEvalContext)) {
                        return true;
                    }
                    boolean bl3 = false;
                    if (bl3) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            if (psiElement instanceof PyFunction) {
                bl = PythonUnitTestDetectorsKt.isTestFunction((PyFunction)element);
                return bl;
            } else {
                if (!(psiElement instanceof PyClass)) return false;
                bl = PythonUnitTestDetectorsKt.isTestClass((PyClass)element, typeEvalContext);
            }
        }
        return bl;
    }
}

