/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.core.engine;

import com.intellij.dataWrangler.executor.DataWranglerContext;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.BaseObjectFormatter;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u001a\u0012\u0016\u0012\u0014 \t*\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00150\r\u00a2\u0006\u0002\b\u00150\u0014H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J'\u0010\u001b\u001a#\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n0\u0007\u00a2\u0006\u0002\b\u000bR/\u0010\u0006\u001a#\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/dataWrangler/core/engine/DataWranglerCoreContext;", "Lcom/intellij/dataWrangler/executor/DataWranglerContext;", "dataGrid", "Lcom/intellij/database/datagrid/DataGrid;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;)V", "gridDataHookUp", "Lcom/intellij/database/datagrid/GridDataHookUp;", "Lcom/intellij/database/datagrid/GridRow;", "kotlin.jvm.PlatformType", "Lcom/intellij/database/datagrid/GridColumn;", "Lorg/jetbrains/annotations/NotNull;", "getText", "", "rowId", "", "colId", "getProject", "Lcom/intellij/openapi/project/Project;", "getColumnNames", "", "Lcom/intellij/openapi/util/NlsSafe;", "getTableName", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "", "getGridDataHookUp", "Companion", "intellij.dataWrangler.core"})
@SourceDebugExtension(value={"SMAP\nDataWranglerCoreContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataWranglerCoreContext.kt\ncom/intellij/dataWrangler/core/engine/DataWranglerCoreContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1586#2:66\n1661#2,3:67\n*S KotlinDebug\n*F\n+ 1 DataWranglerCoreContext.kt\ncom/intellij/dataWrangler/core/engine/DataWranglerCoreContext\n*L\n22#1:66\n22#1:67,3\n*E\n"})
public final class DataWranglerCoreContext
implements DataWranglerContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GridDataHookUp<GridRow, GridColumn> gridDataHookUp;
    @NotNull
    private static final Logger LOG;

    public DataWranglerCoreContext(@NotNull DataGrid dataGrid) {
        Intrinsics.checkNotNullParameter((Object)dataGrid, (String)"dataGrid");
        GridDataHookUp gridDataHookUp = dataGrid.getDataHookup();
        Intrinsics.checkNotNullExpressionValue((Object)gridDataHookUp, (String)"getDataHookup(...)");
        this.gridDataHookUp = gridDataHookUp;
    }

    @NotNull
    public final String getText(int rowId, int colId) {
        return Companion.getText(rowId, colId, this.gridDataHookUp);
    }

    @NotNull
    public Project getProject() {
        Project project = this.gridDataHookUp.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getColumnNames() {
        void $this$mapTo$iv$iv;
        List list = this.gridDataHookUp.getDataModel().getColumns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColumns(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GridColumn gridColumn = (GridColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String getTableName() {
        return "";
    }

    @Nullable
    public VirtualFile getFile() {
        return null;
    }

    public void dispose() {
    }

    @NotNull
    public final GridDataHookUp<GridRow, GridColumn> getGridDataHookUp() {
        return this.gridDataHookUp;
    }

    static {
        Logger logger = Logger.getInstance(Companion.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rJ \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J/\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0000\u00a2\u0006\u0002\b\u0018R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/dataWrangler/core/engine/DataWranglerCoreContext$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getText", "", "rowId", "", "colId", "gridDataHookUp", "Lcom/intellij/database/datagrid/GridDataHookUp;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "row", "column", "config", "Lcom/intellij/database/extractors/ObjectFormatterConfig;", "deleteRows", "", "ids", "", "deleteRows$intellij_dataWrangler_core", "intellij.dataWrangler.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getText(int rowId, int colId, @NotNull GridDataHookUp<GridRow, GridColumn> gridDataHookUp) {
            Intrinsics.checkNotNullParameter(gridDataHookUp, (String)"gridDataHookUp");
            ModelIndex rowIdx = ModelIndex.forRow((GridModel)gridDataHookUp.getMutationModel(), (int)rowId);
            ModelIndex columnIdx = ModelIndex.forColumn((GridModel)gridDataHookUp.getMutationModel(), (int)colId);
            GridModel gridModel = gridDataHookUp.getDataModel();
            Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
            GridModel model = gridModel;
            GridRow gridRow = (GridRow)model.getRow(rowIdx);
            if (gridRow == null) {
                return "null";
            }
            GridRow row = gridRow;
            GridColumn gridColumn = (GridColumn)model.getColumn(columnIdx);
            if (gridColumn == null) {
                return "null";
            }
            GridColumn column = gridColumn;
            ObjectFormatterConfig objectFormatterConfig = DatabaseObjectFormatterConfig.get((ObjectFormatterMode)ObjectFormatterMode.DEFAULT);
            Intrinsics.checkNotNullExpressionValue((Object)objectFormatterConfig, (String)"get(...)");
            return this.getText(row, column, objectFormatterConfig);
        }

        private final String getText(GridRow row, GridColumn column, ObjectFormatterConfig config) {
            String value = new BaseObjectFormatter().objectToString(column.getValue(row), column, config);
            String string = value;
            if (string == null) {
                string = "null";
            }
            return string;
        }

        public final void deleteRows$intellij_dataWrangler_core(@NotNull List<Integer> ids, @NotNull GridDataHookUp<GridRow, GridColumn> gridDataHookUp) {
            GridMutator.RowsMutator mutator;
            Intrinsics.checkNotNullParameter(ids, (String)"ids");
            Intrinsics.checkNotNullParameter(gridDataHookUp, (String)"gridDataHookUp");
            Object object = gridDataHookUp.getMutator();
            GridMutator.RowsMutator rowsMutator = mutator = object instanceof GridMutator.RowsMutator ? (GridMutator.RowsMutator)object : null;
            if (mutator == null) {
                LOG.error("Unsupported instance of mutator in GridDataHookUp");
                return;
            }
            object = CollectionsKt.toIntArray((Collection)ids);
            mutator.deleteRows(new GridRequestSource(null), ModelIndexSet.forRows((GridModel)gridDataHookUp.getMutationModel(), (int[])Arrays.copyOf((int[])object, ((GridMutator)object).length)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

