/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.impl.action;

import com.intellij.dataWrangler.DataWranglerSession;
import com.intellij.dataWrangler.DataWranglerSessionKt;
import com.intellij.dataWrangler.executor.DataWranglerContext;
import com.intellij.dataWrangler.executor.DataWranglerTransformationStepsManager;
import com.intellij.dataWrangler.impl.view.steps.TransformationStepsPanel;
import com.intellij.dataWrangler.operations.TransformationStep;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J6\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/dataWrangler/impl/action/RemoveTransformationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "isInitialCommand", "", "C", "Lcom/intellij/dataWrangler/executor/DataWranglerContext;", "session", "Lcom/intellij/dataWrangler/DataWranglerSession;", "step", "Lcom/intellij/dataWrangler/operations/TransformationStep;", "intellij.dataWrangler.impl"})
public final class RemoveTransformationAction
extends AnAction
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataWranglerSession dataWranglerSession = (DataWranglerSession)e.getData(DataWranglerSessionKt.getDW_SESSION());
        if (dataWranglerSession == null) {
            return;
        }
        DataWranglerSession session2 = dataWranglerSession;
        TransformationStep transformationStep = (TransformationStep)e.getData(TransformationStepsPanel.Companion.getSELECTED_DW_STEP());
        if (transformationStep == null) {
            return;
        }
        TransformationStep selectedElement = transformationStep;
        DataWranglerTransformationStepsManager transformationManager = session2.getTransformationStepsManager();
        transformationManager.removeTransformation(selectedElement);
        session2.rerunSession();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataWranglerSession session2 = (DataWranglerSession)e.getData(DataWranglerSessionKt.getDW_SESSION());
        TransformationStep selectedElement = (TransformationStep)e.getData(TransformationStepsPanel.Companion.getSELECTED_DW_STEP());
        e.getPresentation().setEnabledAndVisible(!this.isInitialCommand(session2, selectedElement));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final <C extends DataWranglerContext> boolean isInitialCommand(@Nullable DataWranglerSession<C> session2, @Nullable TransformationStep<?, ? extends DataWranglerContext> step) {
        if (session2 == null) return false;
        if (step == null) {
            return false;
        }
        if (session2.getEngine().getInitialStep(session2.getContext()) == null) return false;
        Integer n = session2.getTransformationStepsManager().findIndexByStep(step);
        if (n == null) return false;
        if (n != 0) return false;
        return true;
    }
}

