/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.common.TreeDisambiguator;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.List;

class GermanTreeDisambiguator
extends TreeDisambiguator {
    GermanTreeDisambiguator(Tree tree) {
        super(tree);
    }

    @Override
    public Tree disambiguateByTree() {
        for (Node dep : this.currentNodes()) {
            Node head;
            if ((dep = this.removeReadings(dep, GermanTreeDisambiguator.findUnconventionalReadings(dep))).hasLemma("Bild") && GermanTreePatterns.bildPicture.matches(dep)) {
                this.removeIfPossible(dep, "EIG.*");
            }
            if ((head = dep.head()) == null) continue;
            String rel = dep.headRelation();
            if ("amod".equals(rel)) {
                dep = this.removeIfPossible(dep, "VER.*");
                AdjDeclination decl = AdjDeclination.fromNPHead(head);
                if (decl == null) continue;
                this.removeIfPossible(dep, decl == AdjDeclination.DEF ? ".*:(SOL|IND).*" : (decl == AdjDeclination.IND ? ".*:(SOL|DEF).*" : ".*:(IND|DEF).*"));
                continue;
            }
            if (!rel.startsWith("det")) continue;
            this.removeIfPossible(dep, "VER.*");
        }
        return this.tree;
    }

    private static List<Tree.Reading> findUnconventionalReadings(Node node) {
        ArrayList<Tree.Reading> list = new ArrayList<Tree.Reading>();
        for (Tree.Reading r : node.tokenReadings()) {
            if (r.lemma() != null && r.lemma().contains(" ")) {
                list.add(r);
            }
            if (!"_english_ignore_".equals(r.pos())) continue;
            list.add(r);
        }
        return list;
    }
}

