/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.NegativePhrases;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.TagQuestions;
import ai.grazie.rules.en.ToggleContraction;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;

class PolarityItemViolations {
    private static final NodePattern onesXs = NodePattern.N.pos("NNS").withDependent("nmod:poss", NodePattern.N.form("his|her|its|my|their").noDependents(".*").markAs("Ones").includeIntoReport()).noDependents("amod");
    private static final NodePattern asCondition = NodePattern.N.inFormSequence(0, "as", "though|if");
    static final NodePattern conditionClause = NodePattern.N.withDependent("mark|advmod", NodePattern.or(NodePattern.N.form("if|whether|lest|without|when|until"), asCondition)).noDependents("mark", NodePattern.N.inFormSequence(1, "like", "if"));
    private static final NodePattern complexConditionClause = NodePattern.N.withHead("acl:relcl", NodePattern.N.withHead("obj|iobj|obl|nsubj.*", NodePattern.N.withHead(conditionClause)));
    private static final NodePattern infinitiveWithSubj = NodePattern.N.withHeadRelation("advcl").withPhraseStart(NodePattern.N.form("for")).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").withDependent("mark", NodePattern.N.form("to").beforeHead());
    static final NodePattern npiLicensingClause = NodePattern.or(NegativePhrases.negativeClause, Questions.possiblyQuestion, conditionClause);
    static final NodePattern without = NodePattern.N.form("without");
    private static final NodePattern withoutClause = NodePattern.N.withDependent("mark|case", without);
    private static final NodePattern atMost = NodePattern.N.form("most").withDependent("case", NodePattern.N.form("at"));
    private static final NodePattern atMostClause = NodePattern.N.withDependent(".*", NodePattern.or(atMost, NodePattern.N.withDependent("amod", atMost), NodePattern.N.withDependent("nummod", NodePattern.N.withDependent("nmod|advmod", atMost))));
    private static final String GENERAL_NPI_MSG = "This phrase implies a negative phrase, condition, or question";
    private static final NodeCorrector.Relative someToAny = NodeCorrector.regexReplace("some(.*)", "any$1");
    private static final String CLAUSE_MEMBER = "ClauseMember";
    private static final NodePattern anymore = NodePattern.N.form("anymore");
    private static final NodePattern whatsoever = NodePattern.N.form("whatsoever");
    static final NodePattern preventLexicalNegation = NodePattern.N.markAs("ScopeStart").before(NodePattern.or(anymore, whatsoever, EnglishTreePatterns.atAll).inPhrase(NodePattern.N.alreadyMarkedAs("ScopeStart")));

    PolarityItemViolations() {
    }

    static NodePattern pattern() {
        return NodePattern.or(PolarityItemViolations.negative(), PolarityItemViolations.positive()).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations));
    }

    static NodePattern negative() {
        NodePattern nonNpiContext = NodePattern.not(PolarityItemViolations.includeParentClauses(npiLicensingClause, Polarity.negative)).andNot(EnglishTreePatterns.withNegatedAdvmod).andNot(withoutClause).and(CommonPatterns.touchHierarchy);
        NodePattern anymore = PolarityItemViolations.anymore.includeIntoReport(ReportingKind.Hover).markAs(CLAUSE_MEMBER).withHead("advmod", EnglishTreePatterns.clause.and(nonNpiContext).and(PolarityItemViolations.addNegation()));
        NodePattern any = NodePattern.N.form("any").includeIntoReport().withDependent("advmod", NodePattern.N.form("only")).correct(NodeCorrector.replace("some"));
        NodePattern beWithoutOnesXs = onesXs.withDependent("cop", NodePattern.N.lemma("be")).and(NodePattern.or(NodePattern.N.noDependents("advmod", NodePattern.N.lemma("not")).withDependent("case", without.includeIntoReport()).and(PolarityItemViolations.addNegation()), EnglishTreePatterns.negated.withDependent("case", NodePattern.N.form("with").markAs("With").includeIntoReport()).correct(NodeCorrector.replace(NodePointer.marked("With"), "without"))));
        NodePattern allThat = NodePattern.N.inFormSequence(0, "all", "that").noDependents().reportEverythingTouched().directlyBefore(NodePattern.N.withHead("advmod", EnglishTreePatterns.clause.and(nonNpiContext).and(PolarityItemViolations.addNegation())));
        NodePattern slightest = NodePattern.N.form("slightest").includeIntoReport(ReportingKind.Hover).withHead("amod", NodePattern.N.form("idea").withHead(EnglishTreePatterns.clause.and(nonNpiContext).and(PolarityItemViolations.addNegation())));
        NodePattern whatsoever = PolarityItemViolations.whatsoever.withHead("advmod", NodePattern.or(EnglishTreePatterns.clause.and(nonNpiContext), NodePattern.N.withHead("obl", nonNpiContext))).correct(NodeCorrector.replace("completely"));
        NodePattern thinkMuch = NodePattern.N.lemma("think").includeIntoReport().markAs("Think").withDependent("obj", NodePattern.N.form("much").directlyAfter("Think").includeIntoReport().markAs("Much")).and(nonNpiContext).correct(NodeCorrector.replace(NodePointer.marked("Much"), "highly"));
        NodePattern phrasalVerbs = NodePattern.or(PolarityItemViolations.verbDetObj("lift", "a", "finger"), PolarityItemViolations.verbDetObj("sleep", "a", "wink"), PolarityItemViolations.verbDetObj("bat", "an", "eye"), NodePattern.or(NodePattern.N.lemma("last").message(PolarityItemViolations.npiMessage("to last long")), NodePattern.N.lemma("take").noPos("VB[DN]").message(PolarityItemViolations.npiMessage("to take long"))).withDependent("advmod", NodePattern.N.form("long").afterHead().noDependents().includeIntoReport().correct(NodeCorrector.replace("a long time"))).noDependents("obl.*").andNot(CommonPatterns.insideQuotes).includeIntoReport(ReportingKind.Hover)).and(nonNpiContext).andNot(atMostClause).and(PolarityItemViolations.addNegation());
        NodePattern soMuchAs = NodePattern.N.inFormSequence(0, 1, "so", "much", "as").reportEverythingTouched(ReportingKind.Hover).andNot(NodePattern.N.withNeighbor(-2, EnglishTreePatterns.negation)).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.beforeAposOrQuote)).andOr(NodePattern.N.beforeHead().withHead("advmod", EnglishTreePatterns.clause.pos("VB").and(nonNpiContext).and(PolarityItemViolations.addNegation())), NodePattern.N.afterHead().withDependent("advcl", NodePattern.N.pos("VB")).withHead(EnglishTreePatterns.clause.and(nonNpiContext).and(PolarityItemViolations.addNegation())));
        NodePattern possibly = NodePattern.N.form("possibly").includeIntoReport(ReportingKind.Hover).withHead("advmod", NodePattern.N.form("expect").and(nonNpiContext).and(PolarityItemViolations.addNegation()));
        NodePattern haveAClue = NodePattern.N.lemma("have").markAs("Have").withDependent("obj", NodePattern.N.lemma("clue").reportRangeTo("Have").directlyBefore(NodePattern.N.form("about"))).and(nonNpiContext).and(PolarityItemViolations.addNegation());
        NodePattern redCent = NodePattern.N.inFormSequence(2, "a", "red", "cent").reportEverythingTouched(ReportingKind.Hover).withHead(EnglishTreePatterns.clause.and(nonNpiContext).and(PolarityItemViolations.addNegation()));
        return NodePattern.or(NodePattern.or(any, anymore, PolarityItemViolations.yet(), PolarityItemViolations.either(), possibly, slightest, whatsoever).message(PolarityItemViolations.npiMessage("$_")), redCent.message(PolarityItemViolations.npiMessage("a red cent")), soMuchAs.message(PolarityItemViolations.npiMessage("so much as")), PolarityItemViolations.inTime().message(PolarityItemViolations.npiMessage("in $_")), allThat.message(PolarityItemViolations.npiMessage("all that")), phrasalVerbs, NodePattern.or(PolarityItemViolations.atAllViolation(), beWithoutOnesXs, haveAClue, thinkMuch).message(GENERAL_NPI_MSG));
    }

    private static String npiMessage(String phrase) {
        return "'" + phrase + "' implies a negative phrase, condition, or question";
    }

    private static NodePattern yet() {
        NodePattern allowsYet = NodePattern.or(NodePattern.N.inPhrase(NegativePhrases.negativeClause), Questions.question, atMostClause, EnglishTreePatterns.withNegatedAdvmod);
        NodePattern headBefore = NodePattern.N.pos("VB[GN]|JJ").withDependent("aux.*|cop", NodePattern.N.lemma("be").markAs("Aux")).noDependents("amod|expl", NodePattern.or(NodePattern.N.pos("JJ[RS]"), NodePattern.N.form("there"))).andNot(allowsYet);
        NodePattern copulaBeforeYet = NodePattern.N.before("Yet").withDependent("cop").withDependent("cop|aux|aux:pass", NodePattern.N.markAs("Aux")).andNot(CommonPatterns.possiblySkipDown("compound", CommonPatterns.possiblySkipDown("amod", NodePattern.N.pos("JJS")))).andNot(allowsYet);
        NodePattern yet = NodePattern.N.form("yet").markAs("Yet").includeIntoReport().directlyAfter(NodePattern.not(NodePattern.N.form("just"))).directlyBefore(NodePattern.not(NodePattern.N.form("to|another"))).andOr(NodePattern.N.withHead("advmod", NodePattern.or(NodePattern.N.pos("VB[GN]").withDependent("aux.*|cop", NodePattern.N.lemma("have").markAs("Aux")).andNot(allowsYet), NodePattern.N.lemma("be").markAs("Aux").andNot(allowsYet), headBefore.before("Yet"), NodePattern.N.before("Yet").pos("VB").withHead("xcomp", headBefore.before("Yet")).andNot(allowsYet))), NodePattern.N.withHead("advmod|cc", NodePattern.or(copulaBeforeYet, NodePattern.N.before("Yet").withHead("advcl", copulaBeforeYet).andNot(allowsYet)))).andNot(NodePattern.N.withPrevSibling(EnglishTreePatterns.clause)).withHead(PolarityItemViolations.addNegation()).andOr(NodePattern.N.withHead(NodePattern.custom(n -> PolarityItemViolations.adjWithoutNegativePrefix(n) != null)).correct(NodeCorrector.replace("so far", "for now")), NodePattern.N.correct(NodeCorrector.insertAfter(NodePointer.marked("Aux"), " already").join(NodeCorrector.removeNodes(NodePointer.phraseStart(), NodePointer.phraseEnd()))));
        NodePattern justYet = NodePattern.N.form("just").withHead("advmod", NodePattern.N.form("yet").markAs("Yet").markAs(CLAUSE_MEMBER).withHead(EnglishTreePatterns.clause.andNot(PolarityItemViolations.includeParentClauses(NodePattern.or(NegativePhrases.negativeClause, Questions.question), Polarity.negative)))).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("Yet"), "for now"));
        return NodePattern.or(yet, justYet);
    }

    private static NodePattern addNegation() {
        ActionSuggestion.ChangeParameter changeContractionSetting = new ActionSuggestion.ChangeParameter(EnglishParameters.CONTRACTION_USE, null, "Configure contraction settings");
        NodePattern reportAux = NodePattern.N.includeIntoReport().andOptionally(NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.includeIntoReport()));
        return NodePattern.or(NodePattern.N.withDependent("cop|aux|aux:pass", reportAux.and((aux, match) -> {
            Node pred = Objects.requireNonNull(aux.head());
            String positiveAdj = pred.hasPos("JJ.*") ? PolarityItemViolations.adjWithoutNegativePrefix(pred) : null;
            NodeCorrector negatePredicate = positiveAdj == null ? null : NodeCorrector.replace(pred, positiveAdj);
            return match.withCorrectors(PolarityItemViolations.addNegationAfter(aux).stream().map(c -> c.join(negatePredicate)).toList());
        })).suggestActions(changeContractionSetting), NodePattern.N.lemma("be").noDependents("cop|aux|aux:pass").and(reportAux).and((be, match) -> match.withCorrectors(PolarityItemViolations.addNegationAfter(be))).suggestActions(changeContractionSetting), NodePattern.N.pos("VB").noDependents("nsubj").withDependent("mark", NodePattern.N.form("to").includeIntoReport().correct(NodeCorrector.insertBefore("not "))), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").includeIntoReport().and((verb, match) -> {
            String doForm = VerbInflectionNumber.from(verb, EnglishTreePatterns.findSubject(verb)).sameTense(verb).inflectDo();
            if (EnglishParameters.suggestContractedForms.matches(verb)) {
                match = match.withCorrector(NodeCorrector.inflect(verb, "VB.*", "VB").join(NodeCorrector.insertBefore(verb, doForm + "n\u2019t ")));
            }
            if (EnglishParameters.suggestFullForms.matches(verb)) {
                match = match.withCorrector(NodeCorrector.inflect(verb, "VB.*", "VB").join(NodeCorrector.insertBefore(verb, doForm + " not ")));
            }
            return match.withActions(changeContractionSetting);
        }), NodePattern.N);
    }

    private static List<NodeCorrector> addNegationAfter(Node aux) {
        ArrayList<NodeCorrector> correctors = new ArrayList<NodeCorrector>();
        if (EnglishParameters.suggestContractedForms.matches(aux)) {
            String contracted = ToggleContraction.contractNegation(aux.lowForm());
            if (contracted != null) {
                correctors.add(NodeCorrector.replace(aux, contracted));
            } else if (EnglishTreePatterns.startsWithApostrophe.matches(aux)) {
                correctors.add(NodeCorrector.insertAfter(aux, " not"));
            }
        }
        if (EnglishParameters.suggestFullForms.matches(aux)) {
            correctors.add(NodeCorrector.insertAfter(aux, aux.hasForm("can") ? "not" : " not"));
        }
        return correctors;
    }

    private static String adjWithoutNegativePrefix(Node n) {
        String form = n.lowForm();
        String stem = Semantics.removeNegativePrefix(form);
        return stem != null && n.tree().treeSupport().tagToken(stem).hasPos("JJ.*") ? stem : null;
    }

    private static NodePattern either() {
        NodePattern context = EnglishTreePatterns.clause.andNot(PolarityItemViolations.includeParentClauses(NodePattern.or(NegativePhrases.negativeClause, withoutClause), Polarity.negative)).and(CommonPatterns.touchHierarchy);
        return NodePattern.N.form("either").andNot(NodePattern.N.directlyBefore(CommonPatterns.colon)).withHead("advmod", CommonPatterns.skipUp("obl", context)).noDependents().and((node, match) -> node.forward().noneMatch(n -> n.hasForm("or")) ? match.withTouchedNodes((Iterable<Node>)node.forward()) : null).correct(NodeCorrector.replace("too"));
    }

    private static NodePattern verbDetObj(String verbLemma, String detForm, String objForm) {
        return NodePattern.N.lemma(verbLemma).withDependent("obj|obl:npmod", NodePattern.N.inFormSequence(1, detForm, objForm).noDependents("case").andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations))).reportEverythingTouched().message(PolarityItemViolations.npiMessage("to " + verbLemma + " " + detForm + " " + objForm));
    }

    private static NodePattern atAllViolation() {
        NodePattern context = EnglishTreePatterns.clause.andNot(PolarityItemViolations.includeParentClauses(NodePattern.or(npiLicensingClause, infinitiveWithSubj, EnglishTreePatterns.misparsedPassiveAcl, NodePattern.N.lemma("regret")), Polarity.negative)).noDependents("advcl", conditionClause.beforeHead().andNot(CommonPatterns.phraseEndsWithComma).trace("ccomp head misparsed as advcl")).markAs("AtAllClause").and(CommonPatterns.touchHierarchy);
        NodePointer lastAux = match -> (Node)Iterables.getLast(match.getMarkedNode("AtAllClause").findDependents("cop|aux|aux:pass"));
        NodePointer at = NodePointer.marked("at");
        NodePattern excludedNominal = NodePattern.or(NodePattern.N.withDependent("det", NodePattern.N.form("any")), PolarityItemViolations.quantifiedX("any"));
        NodePattern arg = NodePattern.N.withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", context).andNot(excludedNominal);
        return EnglishTreePatterns.atAll.reportEverythingTouched().withPhraseStart(NodePattern.not(NodePattern.N.directlyAfter(NodePattern.N.form("if")))).andOr(NodePattern.N.withHead("obl", context).andNot(NodePattern.N.withPrevSibling(excludedNominal.afterHead())), NodePattern.N.withHead("nmod", arg), NodePattern.N.withHead("nmod", NodePattern.N.withHead("nmod", arg).andNot(excludedNominal))).andOr(NodePattern.markedNodeMatches("AtAllClause", NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.lemma("do")).and(PolarityItemViolations.addNegation())).correct(NodeCorrector.replaceNodes(at, NodePointer.anchor(), "indeed")), NodePattern.markedNodeMatches("AtAllClause", NodePattern.N.withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", CommonPatterns.possiblySkipDown("det", NodePattern.N.form("some.*").markAs("Some")))).correct(NodeCorrector.removeNodes(at, NodePointer.anchor()).join(NodeCorrector.insertBefore(NodePointer.marked("Some"), "at least "))), NodePattern.markedNodeMatches("AtAllClause", NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N)).correct(NodeCorrector.removeNodes(at, NodePointer.anchor()).join(NodeCorrector.insertAfter(lastAux, " completely"))), NodePattern.N.correct(NodeCorrector.replaceNodes(at, NodePointer.anchor(), "completely")));
    }

    private static NodePattern inTime() {
        NodePattern licensor = NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.form("first|second|third|fourth"), NodePattern.N.pos("JJR|JJS"), NodePattern.N.withDependent("advmod", NodePattern.N.form("most|least").directlyAfter(NodePattern.N.form("the")))));
        NodePattern context = PolarityItemViolations.includeParentClauses(NodePattern.or(npiLicensingClause, licensor, NodePattern.N.withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", licensor)), Polarity.negative);
        return NodePattern.N.form("hours|days|weeks|months|years|decades|ages|eons|yonks").markAs("Time").includeIntoReport().andNot(NodePattern.N.directlyBefore(NodePattern.N.form("past"))).withDependent("case", NodePattern.N.form("in").directlyBefore("Time").includeIntoReport()).noDependents("amod|nmod|nummod", NodePattern.N).noDependents("conj|appos", NodePattern.N.form("hours|days|weeks|months|years|decades|ages|eons|yonks").afterHead().withDependent("advmod", NodePattern.N.form("not").beforeHead())).and(CommonPatterns.possiblySkipUp("nmod", NodePattern.N.withHead("obl", EnglishTreePatterns.clause.andNot(context).noLemma("show|display|present").and(PolarityItemViolations.addNegation())))).and(CommonPatterns.touchHierarchy).correct(NodeCorrector.insertBefore("the past "));
    }

    static NodePattern positive() {
        NodePattern nonPPIContext = PolarityItemViolations.includeParentClauses(NegativePhrases.negativeClause, Polarity.positive);
        NodePattern lexicallyNegativeClauseCoordinatedWithPositive = NegativePhrases.lexicallyNegativePredicate.withHead("conj", NodePattern.not(NegativePhrases.negativeClause));
        NodePattern too = CommonPatterns.lastWord.form("too").andOr(NodePattern.N.noDependents().markAs(CLAUSE_MEMBER).withHead("advmod|xcomp", NodePattern.N.anyPos().and(nonPPIContext).andNot(NodePattern.N.withHeadRelation("advcl|acl.*|advmod").noDependents(NegativePhrases.negativeClause))).andNot(NodePattern.N.directlyAfter("Negation").withHead(NodePattern.N.noLemma("be"))), NodePattern.N.withDependent("cop").and(nonPPIContext)).after("Negation").unmark("Negation").andNot(NodePattern.N.inFormSequence(1, ",", "too")).andNot(NodePattern.N.inPhrase(lexicallyNegativeClauseCoordinatedWithPositive)).andOr(NodePattern.N.directlyAfter(NodePattern.N.lemma("have|want|able|need|suppose")).correct(NodeCorrector.replace("to")), NodePattern.N.correct(NodeCorrector.replace("either")));
        NodePattern already = NodePattern.N.form("already").markAs("Already").markAs(CLAUSE_MEMBER).withHead("advmod", NodePattern.not(NodePattern.N.withHeadRelation("advcl|acl.*").andNot(NegativePhrases.negativeClause)).and(nonPPIContext).and(NodePattern.markedNodeMatches("Negation", NodePattern.N.before("Already"))).andOr(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.before("Already")), NodePattern.N.before("Already")).andNot(NodePattern.or(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"), Questions.possiblyQuestion, conditionClause, complexConditionClause, NodePattern.N.withDependent("aux", NodePattern.N.lemma("do")), NodePattern.N.lemma("remember"), NodePattern.N.withDependent("parataxis", TagQuestions.attachedTagQuestion)))).correct(NodeCorrector.replace("yet"));
        NodePattern somewhat = NodePattern.N.form("somewhat").withHead("advmod", nonPPIContext).after("Negation").correct(NodeCorrector.replace("at all"));
        NodeCorrector.Relative removeRather = NodeCorrector.removeNodes(NodePointer.marked("Rather"), NodePointer.marked("Rather"));
        NodePattern would = NodePattern.N.form("would|['\u2019`\u2018]d");
        NodePattern rather = NodePattern.N.form("rather").includeIntoReport().markAs("Rather").markAs(CLAUSE_MEMBER).withHead("advmod", NodePattern.or(NodePattern.N.withDependent("aux.*", would.directlyBefore(NodePattern.N.form("n.t").markAs("Neg"))).correct(NodeCorrector.replace(NodePointer.marked("Neg"), " rather not").join(removeRather)), NodePattern.N.withDependent("aux.*", would.markAs("Would").directlyBefore(NegativePhrases.negativeAdverb)).correct(NodeCorrector.insertAfter(NodePointer.marked("Would"), " rather").join(removeRather)), NodePattern.N.pos("JJ.*|RB.*").markAs("Adj").and(nonPPIContext).correct(NodeCorrector.insertAfter(NodePointer.marked("Adj"), " at all").join(removeRather))));
        NodePattern haveOnesXs = NodePattern.N.lemma("have").includeIntoReport().withDependent("obj", onesXs).and(nonPPIContext).after("Negation").correct(NodeCorrector.replace(NodePointer.marked("Ones"), "any"));
        return NodePattern.or(NodePattern.or(too, already, somewhat, PolarityItemViolations.someConfident(), rather).message("'$_' implies a non-negative phrase"), PolarityItemViolations.someLowConfidence(), haveOnesXs.message("'Have one\u2019s X' implies a non-negative phrase"));
    }

    private static NodePattern someConfident() {
        NodePattern atAllParent = NodePattern.N.withDependent("nmod|obl", EnglishTreePatterns.atAll);
        NodePattern context = NodePattern.or(atAllParent, withoutClause);
        return NodePattern.or(PolarityItemViolations.quantifiedX("some").withHeadRelation("obj").and(NodePattern.or(NodePattern.N.withHead(context), atAllParent)).correct(someToAny), NodePattern.N.form("some").withHeadRelation("det").andOr(NodePattern.N.withHead(NodePattern.N.withHead("obj", context)), NodePattern.N.directlyAfter(without).withHead(NodePattern.N.noDependents("amod").noDependents("advmod", EnglishTreePatterns.negation)).andOptionally(NodePattern.N.inPhrase(EnglishTreePatterns.clause.markAs("Clause"))).andNot(NodePattern.markedNodeMatches("Clause", EnglishTreePatterns.negated)), NodePattern.N.directlyAfter(NodePattern.N.inFormSequence(1, "lack", "of"))).correct(someToAny), NodePattern.N.form("some").withDependent("advmod", NodePattern.N.form("scarcely|barely|hardly")).correct(someToAny));
    }

    private static NodePattern someLowConfidence() {
        NodePattern modal = NodePattern.or(NodePattern.N.withDependent("aux", NodePattern.N.form("must")), NodePattern.N.inFormSequence(0, "have|need", "to"));
        return PolarityItemViolations.quantifiedX("some").markAs("SomeX").withHead("nsubj", NodePattern.ROOT.andOr(Questions.question.andNot(modal).markAs("Question"), NegativePhrases.adverbNegatedClause)).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("like"))).and((someX, match) -> {
            String presentable = someX.presentableText();
            String clauseKind = match.findMarkedNode("Condition") != null ? "conditions" : (match.findMarkedNode("Question") != null ? "questions" : "negative sentences");
            String msg = "'" + presentable + "' isn\u2019t used in " + clauseKind + " unless it\u2019s a specific " + presentable + " known from the context";
            match = match.withLowConfidence().withMessage(msg);
            String x = someX.lowForm().substring("some".length());
            Node negation = match.findMarkedNode("Negation");
            if (EnglishTreePatterns.negation.matches(negation)) {
                Object noX = someX.hasForm("someone") ? "no one" : "no" + x;
                return match.withCorrector(NodeCorrector.replace(someX, new String[]{noX}).join(EnglishTreePatterns.removeNegation(negation)));
            }
            return match.withCorrector(NodeCorrector.replace(someX, "any" + x));
        });
    }

    private static NodePattern quantifiedX(String quantifier) {
        return NodePattern.N.form(quantifier + "(body|thing|one)");
    }

    private static NodePattern includeParentClauses(NodePattern licensingClause, Polarity itemPolarity) {
        return NodePattern.custom((node, match) -> {
            Node clauseMember = match.findMarkedNode(CLAUSE_MEMBER);
            boolean possibleDeepAmbiguity = CommonPatterns.lastChildPhrase.matches(clauseMember);
            ArrayList<Node> touched = new ArrayList<Node>();
            while (node != null) {
                touched.add(node);
                NodeMatch licensorMatch = licensingClause.match(node, match);
                if (licensorMatch != null) {
                    return licensorMatch.withTouchedNodes(touched);
                }
                Node head = node.head();
                if (head != null && node.headRelation().equals("conj")) {
                    licensorMatch = licensingClause.match(head, match);
                    if (licensorMatch != null) {
                        return itemPolarity == Polarity.negative ? licensorMatch.withTouchedNodes(touched) : null;
                    }
                    node = head;
                    continue;
                }
                if (node.hasHeadRelation("xcomp|advcl|csubj|nmod|i?obj")) {
                    if (NodePattern.N.withDependent("mark", NodePattern.N.form("so|because|if")).matches(node)) {
                        return null;
                    }
                    node = head;
                    continue;
                }
                if (!node.hasHeadRelation("ccomp|acl|acl:relcl")) break;
                if (node.hasHeadRelation("ccomp|acl") && itemPolarity == Polarity.positive) {
                    return null;
                }
                node = head;
                if (node != null && node.head() != null && !EnglishTreePatterns.clause.matches(node)) {
                    node = node.head();
                }
                if (!possibleDeepAmbiguity || node == null) continue;
                node = ((StreamEx)node.hierarchy().takeWhile(n -> n.isBefore(clauseMember))).findFirst(n -> !n.hasHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound")).orElse(null);
            }
            return null;
        });
    }

    private static enum Polarity {
        positive,
        negative;

    }
}

