/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JT\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u00062\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120 J\n\u0010!\u001a\u00020\u0006*\u00020\tJ\n\u0010\"\u001a\u00020\u0006*\u00020\tJ\n\u0010#\u001a\u00020\u0006*\u00020$J\u000e\u0010%\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u0015\u0010\r\u001a\u00020\u000e*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/intellij/notebooks/ui/visualization/NotebookUtil;", "", "<init>", "()V", "IS_JUPYTER_CONSOLE_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "", "value", "isJupyterConsoleEditor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)Z", "setJupyterConsoleEditor", "(Lcom/intellij/openapi/editor/Editor;Z)V", "notebookAppearance", "Lcom/intellij/notebooks/ui/visualization/NotebookEditorAppearance;", "getNotebookAppearance", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/notebooks/ui/visualization/NotebookEditorAppearance;", "paintNotebookCellBackgroundGutter", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "top", "", "height", "presentationModeMasking", "customColor", "Ljava/awt/Color;", "actionBetweenBackgroundAndStripe", "Lkotlin/Function0;", "isOrdinaryNotebookEditor", "isDiffKind", "isDiff", "Lcom/intellij/openapi/editor/EditorKind;", "getJupyterCellSpacing", "intellij.notebooks.ui"})
public final class NotebookUtil {
    @NotNull
    public static final NotebookUtil INSTANCE = new NotebookUtil();
    @NotNull
    private static final Key<Boolean> IS_JUPYTER_CONSOLE_EDITOR_KEY;

    private NotebookUtil() {
    }

    public final boolean isJupyterConsoleEditor(@NotNull Editor $this$isJupyterConsoleEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$isJupyterConsoleEditor, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isJupyterConsoleEditor.getUserData(IS_JUPYTER_CONSOLE_EDITOR_KEY), (Object)true);
    }

    public final void setJupyterConsoleEditor(@NotNull Editor $this$isJupyterConsoleEditor, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$isJupyterConsoleEditor, (String)"<this>");
        $this$isJupyterConsoleEditor.putUserData(IS_JUPYTER_CONSOLE_EDITOR_KEY, (Object)value);
    }

    @NotNull
    public final NotebookEditorAppearance getNotebookAppearance(@NotNull Editor $this$notebookAppearance) {
        Intrinsics.checkNotNullParameter((Object)$this$notebookAppearance, (String)"<this>");
        Object object = NotebookEditorAppearance.Companion.getNOTEBOOK_APPEARANCE_KEY().get((UserDataHolder)$this$notebookAppearance);
        Intrinsics.checkNotNull((Object)object);
        return (NotebookEditorAppearance)object;
    }

    public final void paintNotebookCellBackgroundGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, int top, int height, boolean presentationModeMasking, @Nullable Color customColor, @NotNull Function0<Unit> actionBetweenBackgroundAndStripe) {
        Triple triple;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter(actionBetweenBackgroundAndStripe, (String)"actionBetweenBackgroundAndStripe");
        int diffViewOffset = 6;
        NotebookEditorAppearance appearance = this.getNotebookAppearance((Editor)editor);
        int borderWidth = appearance.getLeftBorderWidth();
        int gutterWidth = editor.getGutterComponentEx().getWidth();
        if (!presentationModeMasking) {
            Integer n = r.width - borderWidth;
            Integer n2 = borderWidth;
            Color color = customColor;
            if (color == null) {
                color = (Color)appearance.getCodeCellBackgroundColor().get();
            }
            triple = new Triple((Object)n, (Object)n2, (Object)color);
        } else {
            triple = new Triple((Object)(r.width - borderWidth - gutterWidth), (Object)gutterWidth, (Object)editor.getColorsScheme().getDefaultBackground());
        }
        Triple triple2 = triple;
        int fillX = ((Number)triple2.component1()).intValue();
        int fillWidth = ((Number)triple2.component2()).intValue();
        Color fillColor = (Color)triple2.component3();
        g.setColor(fillColor);
        if (editor.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(fillX + diffViewOffset, top, fillWidth - diffViewOffset, height);
        } else {
            g.fillRect(fillX, top, fillWidth, height);
        }
        actionBetweenBackgroundAndStripe.invoke();
    }

    public static /* synthetic */ void paintNotebookCellBackgroundGutter$default(NotebookUtil notebookUtil, EditorImpl editorImpl, Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl, Color color, Function0 function0, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        if ((n3 & 0x40) != 0) {
            color = null;
        }
        if ((n3 & 0x80) != 0) {
            function0 = NotebookUtil::paintNotebookCellBackgroundGutter$lambda$0;
        }
        notebookUtil.paintNotebookCellBackgroundGutter(editorImpl, graphics, rectangle, n, n2, bl, color, (Function0<Unit>)function0);
    }

    public final boolean isOrdinaryNotebookEditor(@NotNull Editor $this$isOrdinaryNotebookEditor) {
        Intrinsics.checkNotNullParameter((Object)$this$isOrdinaryNotebookEditor, (String)"<this>");
        return $this$isOrdinaryNotebookEditor.getEditorKind() != EditorKind.MAIN_EDITOR ? false : !this.isJupyterConsoleEditor($this$isOrdinaryNotebookEditor);
    }

    public final boolean isDiffKind(@NotNull Editor $this$isDiffKind) {
        Intrinsics.checkNotNullParameter((Object)$this$isDiffKind, (String)"<this>");
        EditorKind editorKind = $this$isDiffKind.getEditorKind();
        Intrinsics.checkNotNullExpressionValue((Object)editorKind, (String)"getEditorKind(...)");
        return this.isDiff(editorKind);
    }

    public final boolean isDiff(@NotNull EditorKind $this$isDiff) {
        Intrinsics.checkNotNullParameter((Object)$this$isDiff, (String)"<this>");
        return $this$isDiff == EditorKind.DIFF;
    }

    public final int getJupyterCellSpacing(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return editor.getLineHeight();
    }

    private static final Unit paintNotebookCellBackgroundGutter$lambda$0() {
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"JUPYTER_HISTORY_EDITOR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_JUPYTER_CONSOLE_EDITOR_KEY = key;
    }
}

