/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.dap.impl;

import com.intellij.jupyter.py.dap.impl.JupyterPyDapExceptionBreakpointHandler;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.dap.DapCommandProcessor;
import com.intellij.platform.dap.DapStackFrame;
import com.intellij.platform.dap.DapThread;
import com.intellij.platform.dap.xdebugger.DapXDebuggerPresentationFactory;
import com.intellij.platform.dap.xdebugger.DefaultDapXStackFrame;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/py/dap/impl/JupyterDapXStackFrame;", "Lcom/intellij/platform/dap/xdebugger/DefaultDapXStackFrame;", "factory", "Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;", "commandProcessor", "Lcom/intellij/platform/dap/DapCommandProcessor;", "thread", "Lcom/intellij/platform/dap/DapThread;", "frame", "Lcom/intellij/platform/dap/DapStackFrame;", "notebookFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "breakpointHandler", "Lcom/intellij/jupyter/py/dap/impl/JupyterPyDapExceptionBreakpointHandler;", "<init>", "(Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;Lcom/intellij/platform/dap/DapCommandProcessor;Lcom/intellij/platform/dap/DapThread;Lcom/intellij/platform/dap/DapStackFrame;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/jupyter/py/dap/impl/JupyterPyDapExceptionBreakpointHandler;)V", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "intellij.jupyter.py.dap"})
public final class JupyterDapXStackFrame
extends DefaultDapXStackFrame {
    @NotNull
    private final VirtualFile notebookFile;
    @NotNull
    private final JupyterPyDapExceptionBreakpointHandler breakpointHandler;

    public JupyterDapXStackFrame(@NotNull DapXDebuggerPresentationFactory factory, @NotNull DapCommandProcessor commandProcessor, @NotNull DapThread thread, @NotNull DapStackFrame frame, @NotNull VirtualFile notebookFile, @NotNull JupyterPyDapExceptionBreakpointHandler breakpointHandler) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)commandProcessor, (String)"commandProcessor");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        Intrinsics.checkNotNullParameter((Object)((Object)breakpointHandler), (String)"breakpointHandler");
        super(factory, commandProcessor, thread, frame);
        this.notebookFile = notebookFile;
        this.breakpointHandler = breakpointHandler;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        VirtualFile source = this.getFrame().getSource();
        if (source == null) {
            return null;
        }
        String string = source.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        NotebookIntervalPointer cellInterval = this.breakpointHandler.getCellIntervalForDebugFile(string);
        NotebookIntervalPointer notebookIntervalPointer = cellInterval;
        if (notebookIntervalPointer == null || (notebookIntervalPointer = notebookIntervalPointer.get()) == null || (notebookIntervalPointer = notebookIntervalPointer.getLines()) == null) {
            return null;
        }
        int cellLine = notebookIntervalPointer.getFirst();
        int notebookLine = cellLine + this.getFrame().getStartPosition().getLine();
        return XDebuggerUtil.getInstance().createPosition(this.notebookFile, notebookLine);
    }
}

