/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH$\u00a8\u0006\u0010"}, d2={"Lcom/intellij/xdebugger/impl/actions/handlers/XDebuggerSplitActionHandler;", "Lcom/intellij/xdebugger/impl/actions/DebuggerActionHandler;", "<init>", "()V", "perform", "", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "session", "Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public abstract class XDebuggerSplitActionHandler
extends DebuggerActionHandler {
    public void perform(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        XDebugSessionProxy xDebugSessionProxy = DebuggerUIUtil.getSessionProxy(event);
        if (xDebugSessionProxy == null) {
            return;
        }
        XDebugSessionProxy session = xDebugSessionProxy;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        this.perform(session, dataContext);
    }

    public boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (LightEdit.owns((Project)project)) {
            return false;
        }
        XDebugSessionProxy xDebugSessionProxy = DebuggerUIUtil.getSessionProxy(event);
        if (xDebugSessionProxy == null) {
            return false;
        }
        XDebugSessionProxy session = xDebugSessionProxy;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return this.isEnabled(session, dataContext);
    }

    protected abstract boolean isEnabled(@NotNull XDebugSessionProxy var1, @NotNull DataContext var2);

    protected abstract void perform(@NotNull XDebugSessionProxy var1, @NotNull DataContext var2);
}

