/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.ide.bookmark.providers.LineBookmarkProvider;
import com.intellij.ide.bookmark.ui.tree.LineNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001cH\u0016J\n\u0010!\u001a\u00020\u0007H\u0096\u0080\u0004J\u0014\u0010\"\u001a\u00020\u001c2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0082\u0004J\n\u0010%\u001a\u00020\u0016H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/intellij/ide/bookmark/providers/LineBookmarkImpl;", "Lcom/intellij/ide/bookmark/LineBookmark;", "provider", "Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "<init>", "(Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;Lcom/intellij/openapi/vfs/VirtualFile;I)V", "getProvider", "()Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getDescriptor", "()Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLine", "()I", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "createNode", "Lcom/intellij/ide/bookmark/ui/tree/LineNode;", "canNavigate", "", "canNavigateToSource", "navigate", "", "requestFocus", "hashCode", "equals", "other", "", "toString", "intellij.platform.bookmarks"})
public final class LineBookmarkImpl
implements LineBookmark {
    @NotNull
    private final LineBookmarkProvider provider;
    @NotNull
    private final OpenFileDescriptor descriptor;

    public LineBookmarkImpl(@NotNull LineBookmarkProvider provider, @NotNull VirtualFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.provider = provider;
        this.descriptor = new OpenFileDescriptor(this.getProvider().getProject(), file, line, 0);
    }

    @NotNull
    public LineBookmarkProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final OpenFileDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.descriptor.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return virtualFile;
    }

    public int getLine() {
        return this.descriptor.getLine();
    }

    @NotNull
    public Map<String, String> getAttributes() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"url", (Object)this.getFile().getUrl()), TuplesKt.to((Object)"line", (Object)String.valueOf(this.getLine()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @ApiStatus.Internal
    @NotNull
    public LineNode createNode() {
        return new LineNode(this.getProvider().getProject(), this);
    }

    public boolean canNavigate() {
        return !this.getProvider().getProject().isDisposed() && this.descriptor.canNavigate();
    }

    public boolean canNavigateToSource() {
        return !this.getFile().isDirectory() && this.canNavigate();
    }

    public void navigate(boolean requestFocus) {
        this.descriptor.navigate(requestFocus);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getProvider(), this.getFile(), this.getLine()};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof LineBookmarkImpl && Intrinsics.areEqual((Object)((LineBookmarkImpl)other).getProvider(), (Object)this.getProvider()) && Intrinsics.areEqual((Object)((LineBookmarkImpl)other).getFile(), (Object)this.getFile()) && ((LineBookmarkImpl)other).getLine() == this.getLine();
    }

    @NotNull
    public String toString() {
        return "LineBookmarkImpl(line=" + this.getLine() + ",file=" + this.getFile() + ",provider=" + this.getProvider() + ")";
    }
}

