/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.themePicker;

import com.intellij.internal.inspector.themePicker.ThemeColorInfo;
import com.intellij.internal.inspector.themePicker.ThemeTreeNode;
import com.intellij.internal.inspector.themePicker.UiThemeColorPickerToolWindowFactory;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredTextAttributes;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.PresentableColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a\b\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"THEME_VIEWER_UI_MARKER_KEY", "", "TOOL_WINDOW_ID", "UPDATE_TABLE_SHORTCUT", "Lcom/intellij/openapi/actionSystem/MouseShortcut;", "isOurOwnUi", "", "point", "Lcom/intellij/ui/awt/RelativePoint;", "component", "Ljava/awt/Component;", "createColorsTreeModel", "Ljavax/swing/tree/TreeModel;", "allInfos", "", "Lcom/intellij/internal/inspector/themePicker/ThemeColorInfo;", "createThemeColorTree", "Ljavax/swing/JTree;", "getColorPresentation", "color", "Ljava/awt/Color;", "getColorId", "getRootPane", "Ljavax/swing/JRootPane;", "window", "", "toIcon", "Ljavax/swing/Icon;", "intellij.platform.ide.ui.inspector"})
@SourceDebugExtension(value={"SMAP\nUiThemeColorPicker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiThemeColorPicker.kt\ncom/intellij/internal/inspector/themePicker/UiThemeColorPickerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,545:1\n1807#2,3:546\n812#2,12:549\n812#2,12:561\n812#2,12:573\n*S KotlinDebug\n*F\n+ 1 UiThemeColorPicker.kt\ncom/intellij/internal/inspector/themePicker/UiThemeColorPickerKt\n*L\n256#1:546,3\n392#1:549,12\n393#1:561,12\n394#1:573,12\n*E\n"})
public final class UiThemeColorPickerKt {
    @NotNull
    private static final String THEME_VIEWER_UI_MARKER_KEY = "ThemeColorPopupIdentity";
    @NotNull
    private static final String TOOL_WINDOW_ID = "UI Theme Color Picker";
    @NotNull
    private static final MouseShortcut UPDATE_TABLE_SHORTCUT = new MouseShortcut(1, 704, 1);

    private static final boolean isOurOwnUi(RelativePoint point) {
        Component component = UIUtil.getDeepestComponentAt((Component)point.getComponent(), (int)point.getPoint().x, (int)point.getPoint().y);
        if (component == null) {
            return false;
        }
        Component component2 = component;
        return UiThemeColorPickerKt.isOurOwnUi(component2);
    }

    private static final boolean isOurOwnUi(Component component) {
        boolean bl;
        block3: {
            JBIterable jBIterable = UIUtil.uiParents((Component)component, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"uiParents(...)");
            Iterable $this$any$iv = (Iterable)jBIterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Component it = (Component)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof JComponent && ((JComponent)it).getClientProperty(THEME_VIEWER_UI_MARKER_KEY) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final TreeModel createColorsTreeModel(List<? extends ThemeColorInfo> allInfos) {
        DefaultMutableTreeNode infoRoot;
        String label;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv3;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        Iterable $this$filterIsInstance$iv = allInfos;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv3) {
            if (!(element$iv$iv instanceof ThemeColorInfo.ColorInfo)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List colorInfos = (List)destination$iv$iv;
        Iterable $this$filterIsInstance$iv2 = allInfos;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ThemeColorInfo.HighlighterInfo)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List highlighterInfos = (List)destination$iv$iv2;
        Iterable $this$filterIsInstance$iv3 = allInfos;
        boolean $i$f$filterIsInstance3 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo3 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ThemeColorInfo.SyntaxInfo)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List syntaxInfos = (List)destination$iv$iv3;
        if (!((Collection)colorInfos).isEmpty()) {
            DefaultMutableTreeNode colorsRoot = colorInfos.size() != allInfos.size() ? UiThemeColorPickerKt.createColorsTreeModel$labelNode(root, "Colors") : root;
            for (ThemeColorInfo.ColorInfo info : colorInfos) {
                label = UiThemeColorPickerKt.getColorPresentation(info.getColor());
                UiThemeColorPickerKt.createColorsTreeModel$colorNode(colorsRoot, info.getColor(), label);
            }
        }
        for (ThemeColorInfo.HighlighterInfo highlighterInfo : highlighterInfos) {
            infoRoot = UiThemeColorPickerKt.createColorsTreeModel$labelNode(root, "Highlighter '" + UiThemeColorPickerKt.createColorsTreeModel$shortenLabel(highlighterInfo.getText()) + "'");
            if (highlighterInfo.getForcedAttributes() != null) {
                DefaultMutableTreeNode forcedNode = UiThemeColorPickerKt.createColorsTreeModel$labelNode(infoRoot, "Forced attributes");
                UiThemeColorPickerKt.createColorsTreeModel$attributesNodes$default(forcedNode, highlighterInfo.getForcedAttributes(), false, 2, null);
            }
            if (highlighterInfo.getKey() != null) {
                StringBuilder $this$createColorsTreeModel_u24lambda_u244 = $i$f$filterIsInstanceTo3 = new StringBuilder();
                boolean bl = false;
                $this$createColorsTreeModel_u24lambda_u244.append("Attribute Key");
                if (highlighterInfo.getForcedAttributes() != null) {
                    $this$createColorsTreeModel_u24lambda_u244.append(" (overwritten)");
                }
                label = $i$f$filterIsInstanceTo3.toString();
                DefaultMutableTreeNode keysNode = UiThemeColorPickerKt.createColorsTreeModel$labelNode(infoRoot, label);
                String string = highlighterInfo.getKey().getExternalName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
                UiThemeColorPickerKt.createColorsTreeModel$labelNode(keysNode, string);
            }
            if (highlighterInfo.getForcedAttributes() != null || highlighterInfo.getKey() != null || highlighterInfo.getAttributes() == null) continue;
            UiThemeColorPickerKt.createColorsTreeModel$attributesNodes$default(infoRoot, highlighterInfo.getAttributes(), false, 2, null);
        }
        for (ThemeColorInfo.SyntaxInfo syntaxInfo : syntaxInfos) {
            infoRoot = UiThemeColorPickerKt.createColorsTreeModel$labelNode(root, "Syntax '" + UiThemeColorPickerKt.createColorsTreeModel$shortenLabel(syntaxInfo.getText()) + "'");
            if (!(syntaxInfo.getAttributeKeys().length == 0)) {
                DefaultMutableTreeNode keysGroup = UiThemeColorPickerKt.createColorsTreeModel$labelNode(infoRoot, "Keys");
                for (TextAttributesKey key : syntaxInfo.getAttributeKeys()) {
                    String string = key.getExternalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
                    UiThemeColorPickerKt.createColorsTreeModel$labelNode(keysGroup, string);
                }
            }
            UiThemeColorPickerKt.createColorsTreeModel$attributesNodes$default(infoRoot, syntaxInfo.getAttributes(), false, 2, null);
        }
        return new DefaultTreeModel(root);
    }

    private static final JTree createThemeColorTree() {
        Tree tree = new Tree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                DefaultMutableTreeNode defaultMutableTreeNode = node instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)node : null;
                Object object = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                ThemeTreeNode value = object instanceof ThemeTreeNode ? (ThemeTreeNode)object : null;
                object = value;
                if (object instanceof ThemeTreeNode.ColorNode) {
                    this.append(UiThemeColorPickerKt.access$getColorPresentation(((ThemeTreeNode.ColorNode)value).getColor()));
                    this.setIcon(UiThemeColorPickerKt.access$toIcon(((ThemeTreeNode.ColorNode)value).getColor()));
                } else if (object instanceof ThemeTreeNode.TextNode) {
                    this.append(((ThemeTreeNode.TextNode)value).getLabel());
                    this.setIcon(null);
                } else if (object == null) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(UiThemeColorPickerToolWindowFactory.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Unexpected tree node: " + node);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
        });
        return (JTree)tree;
    }

    private static final String getColorPresentation(Color color) {
        String id = UiThemeColorPickerKt.getColorId(color);
        String hex = UIUtil.colorToHex((Color)color);
        if (id != null) {
            return id + " #" + hex;
        }
        return "#" + hex;
    }

    private static final String getColorId(Color color) {
        if (color instanceof PresentableColor) {
            String name = ((PresentableColor)color).getPresentableName();
            if (name != null) {
                return name;
            }
            if (color == JBColor.RED) {
                return "JBColor.RED";
            }
            if (color == JBColor.BLUE) {
                return "JBColor.BLUE";
            }
            if (color == JBColor.WHITE) {
                return "JBColor.WHITE";
            }
            if (color == JBColor.BLACK) {
                return "JBColor.BLACK";
            }
            if (color == JBColor.GRAY) {
                return "JBColor.GRAY";
            }
            if (color == JBColor.LIGHT_GRAY) {
                return "JBColor.LIGHT_GRAY";
            }
            if (color == JBColor.DARK_GRAY) {
                return "JBColor.DARK_GRAY";
            }
            if (color == JBColor.PINK) {
                return "JBColor.PINK";
            }
            if (color == JBColor.ORANGE) {
                return "JBColor.ORANGE";
            }
            if (color == JBColor.YELLOW) {
                return "JBColor.YELLOW";
            }
            if (color == JBColor.GREEN) {
                return "JBColor.GREEN";
            }
            if (color == JBColor.MAGENTA) {
                return "JBColor.MAGENTA";
            }
            if (color == JBColor.CYAN) {
                return "JBColor.CYAN";
            }
        }
        return null;
    }

    private static final JRootPane getRootPane(Object window) {
        if (window instanceof RootPaneContainer) {
            return ((RootPaneContainer)window).getRootPane();
        }
        return null;
    }

    private static final Icon toIcon(Color $this$toIcon) {
        return (Icon)new ColorIcon(16, $this$toIcon);
    }

    private static final String createColorsTreeModel$shortenLabel(String $this$createColorsTreeModel_u24shortenLabel) {
        String string = StringUtil.shortenTextWithEllipsis((String)StringsKt.replace$default((String)$this$createColorsTreeModel_u24shortenLabel, (String)"\n", (String)" ", (boolean)false, (int)4, null), (int)20, (int)5);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        return string;
    }

    private static final DefaultMutableTreeNode createColorsTreeModel$labelNode(DefaultMutableTreeNode $this$createColorsTreeModel_u24labelNode, String label) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(new ThemeTreeNode.TextNode(label));
        $this$createColorsTreeModel_u24labelNode.add(child);
        return child;
    }

    private static final DefaultMutableTreeNode createColorsTreeModel$colorNode(DefaultMutableTreeNode $this$createColorsTreeModel_u24colorNode, Color color, String label) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(new ThemeTreeNode.ColorNode(color, label));
        $this$createColorsTreeModel_u24colorNode.add(child);
        return child;
    }

    private static final void createColorsTreeModel$attributesNodes(DefaultMutableTreeNode $this$createColorsTreeModel_u24attributesNodes, TextAttributes textAttributes, boolean recursiveCall) {
        block8: {
            if (textAttributes == null) {
                return;
            }
            if (textAttributes == TextAttributes.ERASE_MARKER) {
                UiThemeColorPickerKt.createColorsTreeModel$labelNode($this$createColorsTreeModel_u24attributesNodes, "ERASE MARKER");
                return;
            }
            if (textAttributes instanceof LayeredTextAttributes) {
                DefaultMutableTreeNode keysGroup = UiThemeColorPickerKt.createColorsTreeModel$labelNode($this$createColorsTreeModel_u24attributesNodes, "LayeredTextAttributes");
                TextAttributesKey[] textAttributesKeyArray = ((LayeredTextAttributes)textAttributes).getKeys();
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray, (String)"getKeys(...)");
                for (TextAttributesKey key : textAttributesKeyArray) {
                    String string = key.getExternalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
                    UiThemeColorPickerKt.createColorsTreeModel$labelNode(keysGroup, string);
                }
                LayeredTextAttributes layeredTextAttributes = LayeredTextAttributes.create(EditorColorsManager.getInstance().getGlobalScheme(), ((LayeredTextAttributes)textAttributes).getKeys());
                Intrinsics.checkNotNullExpressionValue((Object)((Object)layeredTextAttributes), (String)"create(...)");
                LayeredTextAttributes upToDateValue = layeredTextAttributes;
                if (!Intrinsics.areEqual((Object)((Object)upToDateValue), (Object)textAttributes) && !recursiveCall) {
                    DefaultMutableTreeNode upToDate = UiThemeColorPickerKt.createColorsTreeModel$labelNode(keysGroup, "OUTDATED! Up to date value:");
                    UiThemeColorPickerKt.createColorsTreeModel$attributesNodes(upToDate, upToDateValue, true);
                }
            }
            Color color = textAttributes.getBackgroundColor();
            if (color != null) {
                Color it = color;
                boolean bl = false;
                UiThemeColorPickerKt.createColorsTreeModel$colorNode($this$createColorsTreeModel_u24attributesNodes, it, "Background");
            }
            Color color2 = textAttributes.getForegroundColor();
            if (color2 != null) {
                Color it = color2;
                boolean bl = false;
                UiThemeColorPickerKt.createColorsTreeModel$colorNode($this$createColorsTreeModel_u24attributesNodes, it, "Foreground");
            }
            Color color3 = textAttributes.getErrorStripeColor();
            if (color3 != null) {
                Color it = color3;
                boolean bl = false;
                UiThemeColorPickerKt.createColorsTreeModel$colorNode($this$createColorsTreeModel_u24attributesNodes, it, "Error Stripe");
            }
            Color color4 = textAttributes.getEffectColor();
            if (color4 == null) break block8;
            Color it = color4;
            boolean bl = false;
            UiThemeColorPickerKt.createColorsTreeModel$colorNode($this$createColorsTreeModel_u24attributesNodes, it, "Effect");
        }
    }

    static /* synthetic */ void createColorsTreeModel$attributesNodes$default(DefaultMutableTreeNode defaultMutableTreeNode, TextAttributes textAttributes, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        UiThemeColorPickerKt.createColorsTreeModel$attributesNodes(defaultMutableTreeNode, textAttributes, bl);
    }

    public static final /* synthetic */ JRootPane access$getRootPane(Object window) {
        return UiThemeColorPickerKt.getRootPane(window);
    }

    public static final /* synthetic */ boolean access$isOurOwnUi(RelativePoint point) {
        return UiThemeColorPickerKt.isOurOwnUi(point);
    }

    public static final /* synthetic */ MouseShortcut access$getUPDATE_TABLE_SHORTCUT$p() {
        return UPDATE_TABLE_SHORTCUT;
    }

    public static final /* synthetic */ TreeModel access$createColorsTreeModel(List allInfos) {
        return UiThemeColorPickerKt.createColorsTreeModel(allInfos);
    }

    public static final /* synthetic */ JTree access$createThemeColorTree() {
        return UiThemeColorPickerKt.createThemeColorTree();
    }

    public static final /* synthetic */ boolean access$isOurOwnUi(Component component) {
        return UiThemeColorPickerKt.isOurOwnUi(component);
    }

    public static final /* synthetic */ String access$getColorPresentation(Color color) {
        return UiThemeColorPickerKt.getColorPresentation(color);
    }

    public static final /* synthetic */ Icon access$toIcon(Color $receiver) {
        return UiThemeColorPickerKt.toIcon($receiver);
    }
}

