/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.SELContext;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.ServicesRegistrar;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u001f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/agent/impl/VolumeMapper;", "", "pathMapper", "Lcom/intellij/docker/agent/DockerAgentPathMapper;", "<init>", "(Lcom/intellij/docker/agent/DockerAgentPathMapper;)V", "expandPath", "Lcom/github/dockerjava/api/model/Bind;", "bind", "", "binds", "([Lcom/github/dockerjava/api/model/Bind;)[Lcom/github/dockerjava/api/model/Bind;", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nCreateContainerCmdValueTransfers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateContainerCmdValueTransfers.kt\ncom/intellij/docker/agent/impl/VolumeMapper\n+ 2 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,314:1\n8#2:315\n11705#3:316\n12052#3,3:317\n37#4,2:320\n*S KotlinDebug\n*F\n+ 1 CreateContainerCmdValueTransfers.kt\ncom/intellij/docker/agent/impl/VolumeMapper\n*L\n285#1:315\n295#1:316\n295#1:317,3\n295#1:320,2\n*E\n"})
final class VolumeMapper {
    @NotNull
    private final DockerAgentPathMapper pathMapper;

    public VolumeMapper(@NotNull DockerAgentPathMapper pathMapper) {
        Intrinsics.checkNotNullParameter((Object)pathMapper, (String)"pathMapper");
        this.pathMapper = pathMapper;
    }

    private final Bind expandPath(Bind bind) {
        boolean applySELinuxLabel;
        String mappedPath = this.pathMapper.mapPath(bind.getPath());
        Path hostPath = Path.of(mappedPath, new String[0]);
        ServicesRegistrar.AdvancedSettingsService advancedSettingsService = ServicesRegistrar.INSTANCE.get(ServicesRegistrar.INSTANCE.getADVANCED_SETTINGS_SERVICE());
        boolean bl = applySELinuxLabel = advancedSettingsService != null ? advancedSettingsService.getBoolean("docker.selinux.label.volumes") : false;
        if (applySELinuxLabel) {
            if (hostPath.isAbsolute() && hostPath.getNameCount() < 2) {
                applySELinuxLabel = false;
            } else {
                Path home = Path.of(System.getProperty("user.home"), new String[0]);
                if (Intrinsics.areEqual((Object)hostPath, (Object)home)) {
                    applySELinuxLabel = false;
                }
            }
            if (!applySELinuxLabel) {
                boolean $i$f$logger = false;
                Logger logger = LoggerFactory.getLogger(VolumeMapper.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
                logger.warn("Applying selinux label to system directory can make your machine inoperable, selinux label won't be applied to " + hostPath);
            }
        }
        return new Bind(mappedPath, bind.getVolume(), bind.getAccessMode(), applySELinuxLabel ? SELContext.shared : SELContext.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bind[] expandPath(@NotNull Bind[] binds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)binds, (String)"binds");
        Bind[] $this$map$iv = binds;
        boolean $i$f$map = false;
        Bind[] bindArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.expandPath((Bind)p0));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Bind[0]);
    }
}

