/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.lsp.core;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerListener;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.python.lsp.core.PyLspService;
import com.intellij.python.lsp.core.PyLspToolCustomization;
import com.intellij.python.lsp.core.PyLspToolDescriptor;
import com.intellij.python.lsp.core.PyLspToolSupportProvider;
import com.intellij.python.lsp.core.PyLspToolUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.externaltools.PyLspTool;
import com.jetbrains.python.externaltools.configuration.PyLspToolConfiguration;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u00015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H&J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u0004\u0018\u00010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010!\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010)\u001a\u00060*R\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\"\u0010-\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00190.X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u000202X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u00066"}, d2={"Lcom/intellij/python/lsp/core/PyLspToolDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "toolNames", "Lcom/jetbrains/python/externaltools/PyLspTool;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/externaltools/PyLspTool;)V", "getToolNames", "()Lcom/jetbrains/python/externaltools/PyLspTool;", "isSupportedFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "configurableClass", "Ljava/lang/Class;", "Lcom/intellij/openapi/options/Configurable;", "getConfigurableClass", "()Ljava/lang/Class;", "toolConfig", "Lcom/jetbrains/python/externaltools/configuration/PyLspToolConfiguration;", "getToolConfig", "()Lcom/jetbrains/python/externaltools/configuration/PyLspToolConfiguration;", "executableNames", "", "", "getExecutableNames", "()Ljava/util/List;", "lspArguments", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "findExecutable", "Ljava/nio/file/Path;", "supportProvider", "Lcom/intellij/python/lsp/core/PyLspToolSupportProvider;", "getSupportProvider", "()Lcom/intellij/python/lsp/core/PyLspToolSupportProvider;", "setSupportProvider", "(Lcom/intellij/python/lsp/core/PyLspToolSupportProvider;)V", "registeredActionIds", "", "lspServerListener", "Lcom/intellij/python/lsp/core/PyLspToolDescriptor$PyLspToolDescriptorLspServerListener;", "getLspServerListener", "()Lcom/intellij/python/lsp/core/PyLspToolDescriptor$PyLspToolDescriptorLspServerListener;", "commandDescriptions", "", "getCommandDescriptions", "()Ljava/util/Map;", "lspCustomization", "Lcom/intellij/python/lsp/core/PyLspToolCustomization;", "getLspCustomization", "()Lcom/intellij/python/lsp/core/PyLspToolCustomization;", "PyLspToolDescriptorLspServerListener", "intellij.python.lsp.core"})
@SourceDebugExtension(value={"SMAP\nPyLspToolSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyLspToolSupportProvider.kt\ncom/intellij/python/lsp/core/PyLspToolDescriptor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,399:1\n37#2,2:400\n*S KotlinDebug\n*F\n+ 1 PyLspToolSupportProvider.kt\ncom/intellij/python/lsp/core/PyLspToolDescriptor\n*L\n152#1:400,2\n*E\n"})
public abstract class PyLspToolDescriptor
extends ProjectWideLspServerDescriptor {
    @NotNull
    private final PyLspTool toolNames;
    public PyLspToolSupportProvider supportProvider;
    @NotNull
    private final List<String> registeredActionIds;
    @NotNull
    private final PyLspToolDescriptorLspServerListener lspServerListener;
    @NotNull
    private final Map<String, String> commandDescriptions;
    @NotNull
    private final PyLspToolCustomization lspCustomization;

    public PyLspToolDescriptor(@NotNull Project project, @NotNull PyLspTool toolNames) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolNames, (String)"toolNames");
        super(project, toolNames.getPresentableName());
        this.toolNames = toolNames;
        this.registeredActionIds = new ArrayList();
        this.lspServerListener = new PyLspToolDescriptorLspServerListener();
        this.commandDescriptions = MapsKt.emptyMap();
        this.lspCustomization = new PyLspToolCustomization(this.getToolConfig());
    }

    @NotNull
    public final PyLspTool getToolNames() {
        return this.toolNames;
    }

    public boolean isSupportedFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getFileType() instanceof PythonFileType;
    }

    @NotNull
    public abstract Class<? extends Configurable> getConfigurableClass();

    @NotNull
    public abstract PyLspToolConfiguration<?> getToolConfig();

    @NotNull
    public List<String> getExecutableNames() {
        return CollectionsKt.listOf((Object)this.toolNames.getPackageName());
    }

    @NotNull
    public abstract List<String> lspArguments();

    @NotNull
    public GeneralCommandLine createCommandLine() {
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Path path = this.findExecutable();
        Intrinsics.checkNotNull((Object)path);
        spreadBuilder.add((Object)((Object)path.toAbsolutePath()).toString());
        Collection $this$toTypedArray$iv = this.lspArguments();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        return new GeneralCommandLine((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    @Nullable
    public final Path findExecutable() {
        return PyLspToolUtil.INSTANCE.findExecutable(this.getToolConfig(), this.getProject(), (Iterable<String>)this.getExecutableNames());
    }

    @NotNull
    public final PyLspToolSupportProvider getSupportProvider() {
        PyLspToolSupportProvider pyLspToolSupportProvider = this.supportProvider;
        if (pyLspToolSupportProvider != null) {
            return pyLspToolSupportProvider;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"supportProvider");
        return null;
    }

    public final void setSupportProvider(@NotNull PyLspToolSupportProvider pyLspToolSupportProvider) {
        Intrinsics.checkNotNullParameter((Object)pyLspToolSupportProvider, (String)"<set-?>");
        this.supportProvider = pyLspToolSupportProvider;
    }

    @NotNull
    public PyLspToolDescriptorLspServerListener getLspServerListener() {
        return this.lspServerListener;
    }

    @NotNull
    public Map<String, String> getCommandDescriptions() {
        return this.commandDescriptions;
    }

    @NotNull
    public PyLspToolCustomization getLspCustomization() {
        return this.lspCustomization;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/lsp/core/PyLspToolDescriptor$PyLspToolDescriptorLspServerListener;", "Lcom/intellij/platform/lsp/api/LspServerListener;", "<init>", "(Lcom/intellij/python/lsp/core/PyLspToolDescriptor;)V", "serverInitialized", "", "params", "Lorg/eclipse/lsp4j/InitializeResult;", "serverStopped", "shutdownNormally", "", "intellij.python.lsp.core"})
    @SourceDebugExtension(value={"SMAP\nPyLspToolSupportProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyLspToolSupportProvider.kt\ncom/intellij/python/lsp/core/PyLspToolDescriptor$PyLspToolDescriptorLspServerListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,399:1\n1915#2,2:400\n1915#2,2:402\n*S KotlinDebug\n*F\n+ 1 PyLspToolSupportProvider.kt\ncom/intellij/python/lsp/core/PyLspToolDescriptor$PyLspToolDescriptorLspServerListener\n*L\n170#1:400,2\n201#1:402,2\n*E\n"})
    public class PyLspToolDescriptorLspServerListener
    implements LspServerListener {
        /*
         * WARNING - void declaration
         */
        public void serverInitialized(@NotNull InitializeResult params) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            ActionManager actionManager = ActionManager.getInstance();
            ExecuteCommandOptions commandProvider = params.getCapabilities().getExecuteCommandProvider();
            if (commandProvider == null) {
                return;
            }
            List list = commandProvider.getCommands();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCommands(...)");
            Iterable iterable = list;
            PyLspToolDescriptor pyLspToolDescriptor = PyLspToolDescriptor.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String command = (String)element$iv;
                boolean bl = false;
                String actionId = "LSP.Command." + pyLspToolDescriptor.getPresentableName() + "." + command;
                if (actionManager.getAction(actionId) != null) {
                    actionManager.unregisterAction(actionId);
                }
                if (pyLspToolDescriptor.getCommandDescriptions().containsKey(command) && pyLspToolDescriptor.getCommandDescriptions().get(command) == null) continue;
                String string = params.getServerInfo().getName();
                String string2 = pyLspToolDescriptor.getCommandDescriptions().get(command);
                if (string2 == null) {
                    string2 = command;
                }
                String text = string + ": " + string2;
                AnAction action2 = new AnAction(text, pyLspToolDescriptor, command){
                    final /* synthetic */ PyLspToolDescriptor this$0;
                    final /* synthetic */ String $command;
                    {
                        this.this$0 = $receiver;
                        this.$command = $command;
                        super($text);
                    }

                    public void actionPerformed(AnActionEvent e) {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            LspServerManager lspServerManager = LspServerManager.Companion.getInstance(this.this$0.getProject());
                            LspServer lspServer = (LspServer)CollectionsKt.firstOrNull((Iterable)lspServerManager.getServersForProvider(this.this$0.getSupportProvider().getClass()));
                            if (lspServer == null) break block1;
                            LspServer lspServer2 = lspServer;
                            PyLspToolDescriptor pyLspToolDescriptor = this.this$0;
                            String string = this.$command;
                            LspServer server = lspServer2;
                            boolean bl = false;
                            ComponentManager $this$service$iv = (ComponentManager)pyLspToolDescriptor.getProject();
                            boolean $i$f$service = false;
                            Class<PyLspService> serviceClass$iv = PyLspService.class;
                            Object object = $this$service$iv.getService(serviceClass$iv);
                            if (object == null) {
                                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                            }
                            BuildersKt.launch$default((CoroutineScope)((PyLspService)object).getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(server, string, null){
                                int label;
                                final /* synthetic */ LspServer $server;
                                final /* synthetic */ String $command;
                                {
                                    this.$server = $server;
                                    this.$command = $command;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = this.$server.sendRequest(arg_0 -> serverInitialized.1.action.actionPerformed.1.1.invokeSuspend$lambda$0(this.$command, arg_0), (Continuation)this);
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }

                                private static final CompletableFuture invokeSuspend$lambda$0(String $command, LanguageServer it) {
                                    CompletableFuture completableFuture = it.getWorkspaceService().executeCommand(new ExecuteCommandParams($command, null));
                                    Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"executeCommand(...)");
                                    return completableFuture;
                                }
                            }), (int)3, null);
                        }
                    }
                };
                actionManager.registerAction(actionId, action2);
                pyLspToolDescriptor.registeredActionIds.add(actionId);
            }
        }

        public void serverStopped(boolean shutdownNormally) {
            ActionManager actionManager = ActionManager.getInstance();
            Iterable $this$forEach$iv = PyLspToolDescriptor.this.registeredActionIds;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String actionId = (String)element$iv;
                boolean bl = false;
                actionManager.unregisterAction(actionId);
            }
            PyLspToolDescriptor.this.registeredActionIds.clear();
        }
    }
}

