/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.lsp.core.type;

import com.google.common.util.concurrent.Striped;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.lsp.core.type.PyStringTypeResolver;
import com.jetbrains.python.psi.PyInstantTypeProvider;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyWrapperTypeProvider;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u001b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u001c2\u0011\u0010\u001d\u001a\r\u0012\u0004\u0012\u00020\u00140\u001e\u00a2\u0006\u0002\b\u001fH$J\u0018\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#J\u0012\u0010$\u001a\u0004\u0018\u00010\u00152\u0006\u0010!\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\u0014H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u00152\u0006\u0010(\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/python/lsp/core/type/LspTypeEvalContext;", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "psiFileTimestamp", "", "stringTypeLocks", "Lcom/google/common/util/concurrent/Striped;", "Ljava/util/concurrent/locks/Lock;", "Lkotlin/jvm/internal/EnhancedNullability;", "requestedTypesCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "isFullLoaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cacheElementToStringType", "Ljava/util/WeakHashMap;", "Lcom/jetbrains/python/psi/PyTypedElement;", "", "cacheStringTypeToType", "Ljava/util/concurrent/ConcurrentSkipListMap;", "Lcom/jetbrains/python/psi/types/PyType;", "unresolvedSet", "Ljava/util/concurrent/ConcurrentSkipListSet;", "requestTypes", "", "pyTypedElements", "", "Lorg/jetbrains/annotations/Unmodifiable;", "provideType", "element", "evalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "resolveTypeByLsp", "loadAllTypes", "", "loadSingleType", "typedElement", "Companion", "intellij.python.lsp.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLspTypeEvalContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspTypeEvalContext.kt\ncom/intellij/python/lsp/core/type/LspTypeEvalContext\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n23#2:113\n*S KotlinDebug\n*F\n+ 1 LspTypeEvalContext.kt\ncom/intellij/python/lsp/core/type/LspTypeEvalContext\n*L\n84#1:113\n*E\n"})
public abstract class LspTypeEvalContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFile psiFile;
    private final long psiFileTimestamp;
    @NotNull
    private final Striped<Lock> stringTypeLocks;
    @NotNull
    private final AtomicInteger requestedTypesCount;
    @NotNull
    private AtomicBoolean isFullLoaded;
    @NotNull
    private final WeakHashMap<PyTypedElement, String> cacheElementToStringType;
    @NotNull
    private ConcurrentSkipListMap<String, PyType> cacheStringTypeToType;
    @NotNull
    private ConcurrentSkipListSet<String> unresolvedSet;
    private static final int FULL_LOAD_THRESHOLD = 10;

    public LspTypeEvalContext(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.psiFile = psiFile;
        this.psiFileTimestamp = this.psiFile.getModificationStamp();
        Striped striped = Striped.lock((int)64);
        Intrinsics.checkNotNullExpressionValue((Object)striped, (String)"lock(...)");
        this.stringTypeLocks = striped;
        this.requestedTypesCount = new AtomicInteger(0);
        this.isFullLoaded = new AtomicBoolean(false);
        this.cacheElementToStringType = new WeakHashMap();
        this.cacheStringTypeToType = new ConcurrentSkipListMap();
        this.unresolvedSet = new ConcurrentSkipListSet();
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    @Nullable
    protected abstract List<String> requestTypes(@NotNull Collection<? extends PyTypedElement> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final PyType provideType(@NotNull PyTypedElement element, @NotNull TypeEvalContext evalContext) {
        PyType pyType;
        String stringType;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)evalContext, (String)"evalContext");
        String string = this.cacheElementToStringType.get(element);
        if (string == null) {
            string = this.resolveTypeByLsp(element);
        }
        if ((stringType = string) == null) {
            return null;
        }
        Object object = this.stringTypeLocks.get((Object)stringType);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Lock lock = (Lock)object;
        lock.lock();
        try {
            PyType pyType2;
            boolean bl = false;
            if (this.unresolvedSet.contains(stringType)) {
                pyType2 = null;
            } else {
                PyType cachedResolved = this.cacheStringTypeToType.get(stringType);
                if (cachedResolved != null) {
                    pyType2 = cachedResolved;
                } else {
                    PyType resolvedType = PyStringTypeResolver.INSTANCE.resolvePyType(evalContext, (PsiElement)element, stringType);
                    if (resolvedType != null) {
                        ((Map)this.cacheStringTypeToType).put(stringType, resolvedType);
                    } else {
                        this.unresolvedSet.add(stringType);
                    }
                    pyType2 = resolvedType;
                }
            }
            pyType = pyType2;
        }
        finally {
            lock.unlock();
        }
        return pyType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String resolveTypeByLsp(PyTypedElement element) {
        String string;
        if (this.requestedTypesCount.incrementAndGet() >= 10) {
            LspTypeEvalContext lspTypeEvalContext = this;
            synchronized (lspTypeEvalContext) {
                boolean $i$a$-synchronized-LspTypeEvalContext$resolveTypeByLsp$32 = false;
                this.loadAllTypes(element);
                Unit $i$a$-synchronized-LspTypeEvalContext$resolveTypeByLsp$32 = Unit.INSTANCE;
            }
            string = this.cacheElementToStringType.get(element);
        } else {
            PyTypedElement pyTypedElement = element;
            synchronized (pyTypedElement) {
                String newType;
                boolean bl = false;
                String string2 = newType = this.loadSingleType(element);
                // MONITOREXIT @DISABLED, blocks:[1, 3, 6] lbl23 : MonitorExitStatement: MONITOREXIT : var2_3
                string = string2;
            }
        }
        return string;
    }

    private final void loadAllTypes(PyTypedElement element) {
        if (this.isFullLoaded.get()) {
            return;
        }
        Iterable iterable = Companion.collectElementsForCalculation((PsiElement)element);
        Set<PyTypedElement> set = this.cacheElementToStringType.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        List requestedTypes = CollectionsKt.minus((Iterable)iterable, (Iterable)set);
        if (requestedTypes.isEmpty()) {
            return;
        }
        List<String> contents = this.requestTypes(requestedTypes);
        if (contents == null) {
            LspTypeEvalContext $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LspTypeEvalContext.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to load all types for " + this.psiFile.getName() + " Current stamp " + this.psiFile.getModificationStamp() + " calculating: " + this.psiFileTimestamp);
            return;
        }
        for (Pair pair : CollectionsKt.zip((Iterable)requestedTypes, (Iterable)contents)) {
            PyTypedElement pyTypedElement = (PyTypedElement)pair.component1();
            String stringType = (String)pair.component2();
            ((Map)this.cacheElementToStringType).put(pyTypedElement, stringType);
        }
        this.isFullLoaded.set(true);
    }

    private final String loadSingleType(PyTypedElement typedElement) {
        List<String> types = this.requestTypes(CollectionsKt.listOf((Object)typedElement));
        Collection collection = types;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        String string = (String)CollectionsKt.single(types);
        if (string == null) {
            string = "";
        }
        String resolvedType = string;
        ((Map)this.cacheElementToStringType).put(typedElement, resolvedType);
        return resolvedType;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/lsp/core/type/LspTypeEvalContext$Companion;", "", "<init>", "()V", "FULL_LOAD_THRESHOLD", "", "collectElementsForCalculation", "", "Lcom/jetbrains/python/psi/PyTypedElement;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.python.lsp.core"})
    @SourceDebugExtension(value={"SMAP\nLspTypeEvalContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspTypeEvalContext.kt\ncom/intellij/python/lsp/core/type/LspTypeEvalContext$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n777#2:113\n873#2,2:114\n*S KotlinDebug\n*F\n+ 1 LspTypeEvalContext.kt\ncom/intellij/python/lsp/core/type/LspTypeEvalContext$Companion\n*L\n109#1:113\n109#1:114,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PyTypedElement> collectElementsForCalculation(@NotNull PsiElement element) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                return CollectionsKt.emptyList();
            }
            PsiFile psiFile2 = psiFile;
            Class[] classArray = new Class[]{PyTypedElement.class};
            Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)psiFile2), (Class[])classArray);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectElementsOfType(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PyTypedElement it = (PyTypedElement)element$iv$iv;
                boolean bl = false;
                if (!(!(it instanceof PyWrapperTypeProvider) && !(it instanceof PyInstantTypeProvider))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

