/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.lsp.core.type;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/python/lsp/core/type/PyStringTypeResolver;", "", "<init>", "()V", "resolvePyType", "Lcom/jetbrains/python/psi/types/PyType;", "typeEvalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "anchor", "Lcom/intellij/psi/PsiElement;", "stringType", "", "intellij.python.lsp.core"})
public final class PyStringTypeResolver {
    @NotNull
    public static final PyStringTypeResolver INSTANCE = new PyStringTypeResolver();

    private PyStringTypeResolver() {
    }

    @Nullable
    public final PyType resolvePyType(@NotNull TypeEvalContext typeEvalContext, @NotNull PsiElement anchor, @NotNull String stringType) {
        Ref type;
        Intrinsics.checkNotNullParameter((Object)typeEvalContext, (String)"typeEvalContext");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)stringType, (String)"stringType");
        if (StringsKt.isBlank((CharSequence)stringType) || Intrinsics.areEqual((Object)stringType, (Object)"Unknown")) {
            return null;
        }
        if (StringsKt.startsWith$default((String)stringType, (String)"def ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)stringType, (String)"@Todo", (boolean)false, (int)2, null)) {
            return null;
        }
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)stringType);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"fromDottedString(...)");
        QualifiedName qualifiedName2 = qualifiedName;
        String[] stringArray = new String[]{"builtins"};
        if (qualifiedName2.matchesPrefix(QualifiedName.fromComponents((String[])stringArray))) {
            QualifiedName qualifiedName3 = qualifiedName2.removeHead(1);
            Intrinsics.checkNotNullExpressionValue((Object)qualifiedName3, (String)"removeHead(...)");
            QualifiedName builtinClassName = qualifiedName3;
            if (builtinClassName.getComponentCount() == 1) {
                PyBuiltinCache pyBuiltinCache = PyBuiltinCache.Companion.getInstance(anchor);
                String string = builtinClassName.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                PyClass builtinClass = pyBuiltinCache.getClass(string);
                if (builtinClass != null) {
                    return (PyType)builtinClass.getType(typeEvalContext);
                }
            }
        }
        PsiFile psiFile = FileContextUtil.getContextFile((PsiElement)anchor);
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        PyExpression pyExpression = PyUtil.createExpressionFromFragment((String)stringType, (PsiElement)((PsiElement)file));
        if (pyExpression == null) {
            return null;
        }
        PyExpression typeExpression = pyExpression;
        Ref ref = type = PyTypingTypeProvider.getTypeForTypeHint((PyExpression)typeExpression, (TypeEvalContext)typeEvalContext);
        return ref != null ? (PyType)ref.get() : null;
    }
}

