/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServer;
import com.intellij.platform.lsp.api.LspServerManager;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiFile;
import com.intellij.python.ruff.RuffConfiguration;
import com.intellij.python.ruff.RuffImportOptimizerKt;
import com.intellij.python.ruff.server.RuffLspSupportProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeActionTriggerKind;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/python/ruff/RuffImportOptimizer;", "Lcom/intellij/lang/ImportOptimizer;", "<init>", "()V", "supports", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "processFile", "Ljava/lang/Runnable;", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffImportOptimizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffImportOptimizer.kt\ncom/intellij/python/ruff/RuffImportOptimizer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,95:1\n30#2,2:96\n*S KotlinDebug\n*F\n+ 1 RuffImportOptimizer.kt\ncom/intellij/python/ruff/RuffImportOptimizer\n*L\n32#1:96,2\n*E\n"})
public final class RuffImportOptimizer
implements ImportOptimizer {
    public boolean supports(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        LspServerManager lspServerManager = LspServerManager.Companion.getInstance(project2);
        Collection servers = lspServerManager.getServersForProvider(RuffLspSupportProvider.class);
        Project project3 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project3;
        boolean $i$f$service = false;
        Class<RuffConfiguration> serviceClass$iv = RuffConfiguration.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        RuffConfiguration toolConfig = (RuffConfiguration)((Object)object);
        return !servers.isEmpty() && toolConfig.getSortImports();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Runnable processFile(@NotNull PsiFile psiFile) {
        void $this$processFile_u24lambda_u241;
        CodeActionContext codeActionContext;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Runnable noResult = RuffImportOptimizer::processFile$lambda$0;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return noResult;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        LspServerManager lspServerManager = LspServerManager.Companion.getInstance(project2);
        Collection servers = lspServerManager.getServersForProvider(RuffLspSupportProvider.class);
        if (servers.isEmpty()) {
            RuffImportOptimizerKt.access$getLOG$p().warn("No Ruff LSP server found for file: " + virtualFile2.getPath());
            return noResult;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return noResult;
        }
        Document document2 = document;
        LspServer server = (LspServer)CollectionsKt.first((Iterable)servers);
        Range range = Lsp4jUtilKt.getLsp4jRange((Document)document2, (int)0, (int)document2.getTextLength());
        CodeActionContext codeActionContext2 = codeActionContext = new CodeActionContext();
        Range range2 = range;
        TextDocumentIdentifier textDocumentIdentifier = server.getDocumentIdentifier(virtualFile2);
        boolean bl = false;
        $this$processFile_u24lambda_u241.setDiagnostics(CollectionsKt.emptyList());
        $this$processFile_u24lambda_u241.setTriggerKind(CodeActionTriggerKind.Invoked);
        $this$processFile_u24lambda_u241.setOnly(CollectionsKt.listOf((Object)"source.organizeImports"));
        Unit unit = Unit.INSTANCE;
        CodeActionContext codeActionContext3 = codeActionContext;
        Range range3 = range2;
        TextDocumentIdentifier textDocumentIdentifier2 = textDocumentIdentifier;
        CodeActionParams params = new CodeActionParams(textDocumentIdentifier2, range3, codeActionContext3);
        DocumentImpl tempDocument = new DocumentImpl((CharSequence)document2.getText(), false, true);
        List list = (List)LspServer.sendRequestSync$default((LspServer)server, (int)0, arg_0 -> RuffImportOptimizer.processFile$lambda$2(params, arg_0), (int)1, null);
        if (list == null) {
            return noResult;
        }
        List codeActions = list;
        Ref.BooleanRef updated = new Ref.BooleanRef();
        for (Either either : codeActions) {
            Object object;
            CodeAction resolvedAction;
            CodeAction codeAction;
            if ((CodeAction)either.getRight() == null || codeAction.getData() == null || (CodeAction)LspServer.sendRequestSync$default((LspServer)server, (int)0, arg_0 -> RuffImportOptimizer.processFile$lambda$3(codeAction, arg_0), (int)1, null) == null || resolvedAction.getEdit() == null || (object = resolvedAction.getEdit()) == null || (object = object.getDocumentChanges()) == null) continue;
            Object changes = object;
            Iterator iterator = changes.iterator();
            while (iterator.hasNext()) {
                Either change = (Either)iterator.next();
                if (!change.isLeft()) continue;
                TextDocumentEdit textDocumentEdit = (TextDocumentEdit)change.getLeft();
                List edits = textDocumentEdit.getEdits();
                updated.element = true;
                Document document3 = (Document)tempDocument;
                Intrinsics.checkNotNull((Object)edits);
                Lsp4jUtilKt.applyTextEdits((Document)document3, (List)edits);
            }
        }
        return () -> RuffImportOptimizer.processFile$lambda$4(updated, document2, tempDocument);
    }

    private static final void processFile$lambda$0() {
    }

    private static final CompletableFuture processFile$lambda$2(CodeActionParams $params, LanguageServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CompletableFuture completableFuture = it.getTextDocumentService().codeAction($params);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"codeAction(...)");
        return completableFuture;
    }

    private static final CompletableFuture processFile$lambda$3(CodeAction $codeAction, LanguageServer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CompletableFuture completableFuture = it.getTextDocumentService().resolveCodeAction($codeAction);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"resolveCodeAction(...)");
        return completableFuture;
    }

    private static final void processFile$lambda$4(Ref.BooleanRef $updated, Document $document, DocumentImpl $tempDocument) {
        if ($updated.element) {
            $document.setText((CharSequence)$tempDocument.getText());
        }
    }
}

