/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.python.ruff.RuffRuleInfo;
import com.intellij.python.ruff.RuffService;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.TomlLanguage;
import org.toml.lang.psi.TomlArray;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlLiteral;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffErrorCodeCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "<init>", "()V", "tomlRuffLintPattern", "Lcom/intellij/patterns/PsiElementPattern$Capture;", "Lcom/intellij/psi/PsiElement;", "RuffErrorCodeCompletionProvider", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffErrorCodeCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffErrorCodeCompletionContributor.kt\ncom/intellij/python/ruff/codeinsight/RuffErrorCodeCompletionContributor\n+ 2 PatternUtil.kt\ncom/intellij/python/ruff/codeinsight/PatternUtilKt\n*L\n1#1,121:1\n10#2:122\n14#2:123\n20#2,3:124\n14#2:127\n10#2:128\n*S KotlinDebug\n*F\n+ 1 RuffErrorCodeCompletionContributor.kt\ncom/intellij/python/ruff/codeinsight/RuffErrorCodeCompletionContributor\n*L\n32#1:122\n57#1:123\n58#1:124,3\n62#1:127\n63#1:128\n*E\n"})
public final class RuffErrorCodeCompletionContributor
extends CompletionContributor {
    public RuffErrorCodeCompletionContributor() {
        RuffErrorCodeCompletionProvider provider = new RuffErrorCodeCompletionProvider();
        PsiElementPattern.Capture capture = PlatformPatterns.psiComment();
        Intrinsics.checkNotNullExpressionValue((Object)capture, (String)"psiComment(...)");
        PsiElementPattern.Capture $this$withParent$iv = capture;
        boolean $i$f$withParent = false;
        TreeElementPattern treeElementPattern = $this$withParent$iv.withParent(PyFile.class);
        Intrinsics.checkNotNull((Object)treeElementPattern, (String)"null cannot be cast to non-null type com.intellij.patterns.PsiElementPattern.Capture<com.intellij.psi.PsiElement>");
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)treeElementPattern).withText((ElementPattern)StandardPatterns.string().startsWith("# ruff: noqa:")), provider);
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiComment().withText((ElementPattern)StandardPatterns.string().startsWith("# noqa:")), provider);
        this.extend(CompletionType.BASIC, (ElementPattern)this.tomlRuffLintPattern(), provider);
    }

    /*
     * WARNING - void declaration
     */
    private final PsiElementPattern.Capture<PsiElement> tomlRuffLintPattern() {
        void $this$with$iv;
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)TomlLanguage.INSTANCE);
        boolean $i$f$psiElement22 = false;
        PsiElementPattern.Capture capture2 = PlatformPatterns.psiElement(TomlLiteral.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture2, (String)"psiElement(...)");
        PsiElementPattern.Capture $i$f$psiElement22 = capture2;
        String debugMethodName$iv = "ruffLintKey";
        boolean $i$f$with = false;
        ObjectPattern objectPattern = $this$with$iv.with((PatternCondition)new PatternCondition<TomlLiteral>(debugMethodName$iv){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public boolean accepts(PsiElement t, ProcessingContext context) {
                void literal;
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                TomlLiteral tomlLiteral = (TomlLiteral)t;
                PatternCondition $this$tomlRuffLintPattern_u24lambda_u240 = this;
                boolean bl = false;
                return RuffDocumentationUtil.INSTANCE.isRuffCodeElement((TomlLiteral)literal);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)objectPattern, (String)"with(...)");
        PsiElementPattern.Capture capture3 = (PsiElementPattern.Capture)objectPattern;
        boolean $i$f$psiElement = false;
        PsiElementPattern.Capture capture4 = PlatformPatterns.psiElement(TomlArray.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture4, (String)"psiElement(...)");
        PsiElementPattern.Capture $this$withParent$iv = capture4;
        boolean $i$f$withParent = false;
        TreeElementPattern treeElementPattern = $this$withParent$iv.withParent(TomlKeyValue.class);
        Intrinsics.checkNotNull((Object)treeElementPattern, (String)"null cannot be cast to non-null type com.intellij.patterns.PsiElementPattern.Capture<com.intellij.psi.PsiElement>");
        TreeElementPattern treeElementPattern2 = capture.withParent((ElementPattern)capture3.withParent((ElementPattern)((PsiElementPattern.Capture)treeElementPattern)));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern2, (String)"withParent(...)");
        return (PsiElementPattern.Capture)treeElementPattern2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffErrorCodeCompletionContributor$RuffErrorCodeCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.python.ruff"})
    @SourceDebugExtension(value={"SMAP\nRuffErrorCodeCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffErrorCodeCompletionContributor.kt\ncom/intellij/python/ruff/codeinsight/RuffErrorCodeCompletionContributor$RuffErrorCodeCompletionProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,121:1\n30#2,2:122\n*S KotlinDebug\n*F\n+ 1 RuffErrorCodeCompletionContributor.kt\ncom/intellij/python/ruff/codeinsight/RuffErrorCodeCompletionContributor$RuffErrorCodeCompletionProvider\n*L\n77#1:122,2\n*E\n"})
    private static final class RuffErrorCodeCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            result.stopHere();
            Project project = parameters.getPosition().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean bl = false;
            Class<RuffService> serviceClass$iv = RuffService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            RuffService ruffService = (RuffService)object;
            for (Map.Entry<String, RuffRuleInfo> entry : ruffService.getRuleInformation().entrySet()) {
                String code = entry.getKey();
                RuffRuleInfo ruleInfo = entry.getValue();
                result.addElement((LookupElement)LookupElementBuilder.create((String)code).withPresentableText(code).withTypeText(ruleInfo.getName(), true).withTailText(" (" + ruleInfo.getLinter() + ")", true).withLookupString(ruleInfo.getName()).withCaseSensitivity(true));
            }
            if (Intrinsics.areEqual((Object)parameters.getPosition().getContainingFile().getLanguage(), (Object)TomlLanguage.INSTANCE)) {
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)LookupElementBuilder.create((String)"ALL").withPresentableText("ALL").withTypeText("All Ruff rules", true).withLookupString("everything").withLookupString("all rules").withLookupString("all linters").withTailText(" (all rules)", true).withCaseSensitivity(true)), (double)1.0));
                for (Map.Entry<String, Object> entry : ruffService.getLinterInformation().entrySet()) {
                    String prefix = entry.getKey();
                    String linterName = (String)entry.getValue();
                    result.addElement((LookupElement)LookupElementBuilder.create((String)prefix).withPresentableText(prefix).withTypeText("All " + linterName + " rules", true).withTailText(" (" + linterName + ")", true).withLookupString(linterName).withCaseSensitivity(true));
                }
            }
        }
    }
}

