/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.python.ruff.RuffBundle;
import com.intellij.python.ruff.RuffRuleInfo;
import com.intellij.python.ruff.RuffService;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtil;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00052\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00052\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffTooltipLinkHandler;", "Lcom/intellij/codeInsight/highlighting/TooltipLinkHandler;", "<init>", "()V", "getDescription", "", "refSuffix", "editor", "Lcom/intellij/openapi/editor/Editor;", "getDescriptionTitle", "extractRuleName", "findRuleByName", "Lcom/intellij/python/ruff/RuffRuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "ruleName", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffTooltipLinkHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffTooltipLinkHandler.kt\ncom/intellij/python/ruff/codeinsight/RuffTooltipLinkHandler\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,57:1\n30#2,2:58\n*S KotlinDebug\n*F\n+ 1 RuffTooltipLinkHandler.kt\ncom/intellij/python/ruff/codeinsight/RuffTooltipLinkHandler\n*L\n50#1:58,2\n*E\n"})
public final class RuffTooltipLinkHandler
extends TooltipLinkHandler {
    @Nullable
    public String getDescription(@NotNull String refSuffix, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)refSuffix, (String)"refSuffix");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        if (project2.isDisposed()) {
            return null;
        }
        String string = this.extractRuleName(refSuffix);
        if (string == null) {
            return null;
        }
        String ruleName = string;
        RuffRuleInfo ruffRuleInfo = this.findRuleByName(project2, ruleName);
        if (ruffRuleInfo == null) {
            return null;
        }
        RuffRuleInfo ruleInfo = ruffRuleInfo;
        return RuffDocumentationUtil.INSTANCE.formatRuleDocumentation(ruleInfo, project2);
    }

    @NotNull
    public String getDescriptionTitle(@NotNull String refSuffix, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)refSuffix, (String)"refSuffix");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return RuffBundle.INSTANCE.message("inspection.message.ruff.rule.documentation", new Object[0]);
    }

    private final String extractRuleName(String refSuffix) {
        String[] stringArray = new String[]{"/"};
        List parts = StringsKt.split$default((CharSequence)refSuffix, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 2 || !Intrinsics.areEqual(parts.get(0), (Object)"rules")) {
            return null;
        }
        return (String)parts.get(1);
    }

    private final RuffRuleInfo findRuleByName(Project project, String ruleName) {
        Object v2;
        block2: {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RuffService> serviceClass$iv = RuffService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            RuffService ruffService = (RuffService)object;
            Iterable iterable = ruffService.getRuleInformation().values();
            for (Object t : iterable) {
                RuffRuleInfo ruleInfo = (RuffRuleInfo)t;
                boolean bl = false;
                String string = ruleInfo.getName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string, (Object)ruleName)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }
}

