/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.data;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.InstructionsUtil;
import com.intellij.rt.coverage.instrumentation.InstrumentationOptions;
import com.intellij.rt.coverage.instrumentation.data.FilteredMethodStorage;
import com.intellij.rt.coverage.util.ArrayUtil;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.LineMapper;
import com.intellij.rt.coverage.util.StringsPool;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jetbrains.coverage.gnu.trove.TIntHashSet;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;

public class ProjectContext {
    private final InstrumentationOptions myOptions;
    private final ClassFinder myClassFinder;
    private final StringsPool myStringPool = new StringsPool();
    private final FilteredMethodStorage myAnnotationStorage = new FilteredMethodStorage();
    private volatile Map<String, TIntHashSet> myIgnoredLines;
    private volatile Map<String, FileMapData[]> myLinesMap;
    private volatile Map<String, String[]> myInherits;

    /*
     * WARNING - void declaration
     */
    public ProjectContext(InstrumentationOptions options) {
        this(options, new ClassFinder(options.includePatterns, var1_1.excludePatterns));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ProjectContext(InstrumentationOptions options, ClassFinder classFinder) {
        void var2_2;
        void var1_1;
        this.myOptions = var1_1;
        this.myClassFinder = var2_2;
    }

    public InstrumentationOptions getOptions() {
        return this.myOptions;
    }

    public FilteredMethodStorage getFilteredStorage() {
        return this.myAnnotationStorage;
    }

    /*
     * WARNING - void declaration
     */
    public String getFromPool(String s) {
        void var1_1;
        return this.myStringPool.getFromPool((String)var1_1);
    }

    public ClassFinder getClassFinder() {
        return this.myClassFinder;
    }

    /*
     * WARNING - void declaration
     */
    public void addLineMaps(String className, FileMapData[] fileDatas) {
        void var2_3;
        void var1_1;
        void var3_4;
        Map<String, FileMapData[]> linesMap = this.myLinesMap;
        if (linesMap == null) {
            ProjectContext projectContext = this;
            synchronized (projectContext) {
                linesMap = this.myLinesMap;
                if (linesMap == null) {
                    this.myLinesMap = linesMap = new ConcurrentHashMap<String, FileMapData[]>();
                }
            }
        }
        var3_4.put(var1_1, var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public void addIgnoredLines(String className, TIntHashSet lines) {
        void var2_3;
        void var1_1;
        void var3_4;
        if (lines == null || lines.isEmpty()) {
            return;
        }
        Map<String, TIntHashSet> ignoredLines = this.myIgnoredLines;
        if (ignoredLines == null) {
            ProjectContext projectContext = this;
            synchronized (projectContext) {
                ignoredLines = this.myIgnoredLines;
                if (ignoredLines == null) {
                    this.myIgnoredLines = ignoredLines = new ConcurrentHashMap<String, TIntHashSet>();
                }
            }
        }
        var3_4.put(var1_1, var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public void finalizeCoverage(ProjectData projectData) {
        void var1_1;
        this.applyLineMappings(projectData);
        this.dropIgnoredLines((ProjectData)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void dropLineMappings(ProjectData projectData) {
        void var1_1;
        if (this.myLinesMap != null) {
            for (Map.Entry<String, FileMapData[]> entry : this.myLinesMap.entrySet()) {
                void var3_3;
                ClassData classData = projectData.getClassData(entry.getKey());
                ProjectContext.dropLineMappings(projectData, classData, (FileMapData[])var3_3.getValue());
            }
        }
        this.dropIgnoredLines((ProjectData)var1_1);
    }

    public void applyHits(ProjectData projectData) {
        for (ClassData classData : projectData.getClassesCollection()) {
            classData.applyHits();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dropLineMappings(ProjectData projectData, ClassData classData) {
        TIntHashSet ignoredLines;
        FileMapData[] mappings;
        if (this.myLinesMap != null && (mappings = this.myLinesMap.get(classData.getName())) != null) {
            void var1_1;
            ProjectContext.dropLineMappings((ProjectData)var1_1, classData, mappings);
        }
        if (this.myIgnoredLines != null && (ignoredLines = this.myIgnoredLines.get(classData.getName())) != null) {
            void var3_3;
            void var2_2;
            ProjectContext.dropIgnoredLines((ClassData)var2_2, (TIntHashSet)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dropIgnoredLines(ProjectData projectData) {
        if (this.myIgnoredLines == null) {
            return;
        }
        for (Map.Entry<String, TIntHashSet> e : this.myIgnoredLines.entrySet()) {
            void var3_3;
            ClassData classData = projectData.getClassData(e.getKey());
            if (classData == null) continue;
            ProjectContext.dropIgnoredLines(classData, (TIntHashSet)var3_3.getValue());
        }
    }

    public synchronized void setCollectInherits(boolean collectInherits) {
        if (collectInherits) {
            this.myInherits = new ConcurrentHashMap<String, String[]>();
            return;
        }
        this.myInherits = null;
    }

    public Map<String, String[]> getInherits() {
        return this.myInherits;
    }

    /*
     * WARNING - void declaration
     */
    public void addInherits(String className, String[] inherits) {
        void var2_2;
        void var1_1;
        if (this.myInherits == null) {
            return;
        }
        this.myInherits.put((String)var1_1, (String[])var2_2);
    }

    public boolean shouldCollectInherits() {
        return this.myInherits != null;
    }

    /*
     * WARNING - void declaration
     */
    private void applyLineMappings(ProjectData projectData) {
        if (this.myLinesMap == null) {
            return;
        }
        for (Map.Entry<String, FileMapData[]> entry : this.myLinesMap.entrySet()) {
            void var3_3;
            String className = entry.getKey();
            ClassData classData = projectData.getClassData(className);
            if (classData == null) continue;
            FileMapData[] fileData = entry.getValue();
            FileMapData mainData = null;
            for (void aFileData : var3_3) {
                ClassData classInfo;
                String mappedClassName = this.getFromPool(aFileData.getClassName());
                if (mappedClassName.equals(className)) {
                    mainData = aFileData;
                    continue;
                }
                if (this.shouldIncludeClass(mappedClassName)) {
                    classInfo = projectData.getOrCreateClassData(mappedClassName);
                    if (this.getOptions().isSaveSource && classInfo.getSource() == null) {
                        classInfo.setSource(aFileData.getFileName());
                    }
                } else {
                    classInfo = new ClassData((String)((Object)classInfo));
                }
                ProjectContext.applyLineMappings(aFileData.getLines(), classInfo, classData);
                InstructionsUtil.applyInstructionsSMAP(projectData, aFileData.getLines(), classInfo, classData);
            }
            if (mainData == null) continue;
            ClassData classData2 = classData;
            ProjectContext.applyLineMappings(mainData.getLines(), classData2, classData2);
            ClassData classData3 = classData;
            InstructionsUtil.applyInstructionsSMAP(projectData, mainData.getLines(), classData3, classData3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void applyLineMappings(LineMapData[] linesMap, ClassData sourceClassData, ClassData targetClassData) {
        void var2_2;
        void var1_1;
        LineMapData[] lineMapDataArray;
        sourceClassData.resetLines((LineData[])new BasicLineMapper().mapLines(lineMapDataArray, (ClassData)var1_1, (ClassData)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static void dropLineMappings(ProjectData projectData, ClassData classData, FileMapData[] mappings) {
        void var2_2;
        void var1_1;
        ProjectData projectData2;
        LineMapper.dropMappedLines(mappings, classData.getLines(), classData.getName());
        InstructionsUtil.dropMappedLines(projectData2, var1_1.getName(), (FileMapData[])var2_2);
    }

    private static void dropIgnoredLines(ClassData classData, TIntHashSet ignoredLines) {
        ClassData classData2;
        ignoredLines.forEach(new TIntProcedure(){

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean execute(int line) {
                void var1_1;
                ArrayUtil.safeStore(classData2.getLines(), (int)var1_1, null);
                return true;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldIncludeClass(String className) {
        void var2_2;
        void var1_1;
        if (ClassNameUtil.matchesPatterns(className, this.getOptions().excludePatterns)) {
            return false;
        }
        List<Pattern> includePatterns = this.getOptions().includePatterns;
        return includePatterns == null || includePatterns.isEmpty() || ClassNameUtil.matchesPatterns((String)var1_1, (List<Pattern>)var2_2);
    }

    private static class BasicLineMapper
    extends LineMapper<LineData> {
        private BasicLineMapper() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected LineData createNewLine(LineData targetLine, int line) {
            void var1_1;
            void var2_2;
            return new LineData((int)var2_2, var1_1.getMethodSignature());
        }

        protected LineData[] createArray(int size) {
            return new LineData[size];
        }

        protected LineData[] getLines(ClassData classData) {
            return (LineData[])classData.getLines();
        }
    }
}

