/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.plan;

import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.ddl.ModifyObjectAction;
import com.intellij.database.dialects.base.plan.AbstractXmlPlanModelBuilder;
import com.intellij.database.dialects.mssql.model.MsIndex;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.plan.MsRawPlanData;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.JavaXmlDocumentKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MsPlanModelBuilder
extends AbstractXmlPlanModelBuilder<MsRawPlanData, Element> {
    private static final Map<String, PlanModel.NodeType> LOGICAL_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<Pair<PlanModel.NodeType, String>, PlanModel.NodeType> PHYSICAL_MAPPING = new HashMap<Pair<PlanModel.NodeType, String>, PlanModel.NodeType>();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private final XPathExpression STATEMENTS_QUERY = this.compileXPath("//Statements/StmtSimple");
    private final XPathExpression FIRST_OP_QUERY = this.compileXPath("QueryPlan/RelOp");
    private final XPathExpression MISSING_INDICES_QUERY = this.compileXPath("QueryPlan/MissingIndexes/MissingIndexGroup");
    private final XPathExpression ACCESS_OBJECT_QUERY = this.compileXPath("*/Object");
    private final XPathExpression RUNTIME_QUERY = this.compileXPath("RunTimeInformation/RunTimeCountersPerThread");
    private final XPathExpression SUB_OPS_QUERY = this.compileXPath("*/RelOp");

    public MsPlanModelBuilder() {
        super(EnumSet.of(PlanModel.Feature.STARTUP_COST));
    }

    @NotNull
    public MsRawPlanData createData() {
        return new MsRawPlanData();
    }

    protected void parseData() {
        this.parseXmls(((MsRawPlanData)this.myData).xmls);
    }

    @NotNull
    protected String getRawData() {
        String string = ((MsRawPlanData)this.myData).xmls.toString();
        if (string == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected boolean hasRawData() {
        return true;
    }

    private void parseXmls(@NotNull List<String> xmls) {
        if (xmls == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(1);
        }
        try {
            DocumentBuilder builder = JavaXmlDocumentKt.createDocumentBuilder();
            this.openNode(null);
            for (String xml : xmls) {
                Document doc = builder.parse(new InputSource(new StringReader(xml)));
                NodeList statements = MsPlanModelBuilder.queryElements((XPathExpression)this.STATEMENTS_QUERY, (Element)doc.getDocumentElement());
                if (statements.getLength() == 0) continue;
                for (int i = 0; i < statements.getLength(); ++i) {
                    Element statement = (Element)statements.item(i);
                    this.parseStatement(statement);
                }
            }
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (IOException | SAXException e) {
            throw new PlanRetrievalException("Failed to parse XML", (Throwable)e);
        }
    }

    @NotNull
    protected String parseRawDescription(final @NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(2);
        }
        String string = new Object((MsPlanModelBuilder)this){
            final StringBuilder sb = new StringBuilder();
            {
                this.visit("", element);
            }

            void visit(String prefix, Element el) {
                int i;
                NamedNodeMap attributes = el.getAttributes();
                for (i = 0; i < attributes.getLength(); ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    this.sb.append(prefix).append(attr.getName()).append(" = ").append(attr.getValue()).append(";\n");
                }
                for (i = 0; i < el.getChildNodes().getLength(); ++i) {
                    Element child = (Element)ObjectUtils.tryCast((Object)el.getChildNodes().item(i), Element.class);
                    if (child == null || "RelOp".equals(child.getTagName()) || "OutputList".equals(child.getTagName()) || "DefinedValues".equals(child.getTagName())) continue;
                    this.visit(prefix + child.getTagName() + ".", child);
                }
            }
        }.sb.toString();
        if (string == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected String parseAccessRelation(@NotNull Element element) {
        Element obj;
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(4);
        }
        if ((obj = MsPlanModelBuilder.queryElement((XPathExpression)this.ACCESS_OBJECT_QUERY, (Element)element)) == null) {
            this.unsupportedFormat();
        }
        return obj.getAttribute("Schema") + "." + obj.getAttribute("Table");
    }

    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(5);
        }
        try {
            if ("RelOp".equals(element.getTagName())) {
                return new BigDecimal(element.getAttribute("EstimateRows"));
            }
            return new BigDecimal(element.getAttribute("StatementEstRows"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    protected String parseAccessIndex(@NotNull Element element) {
        Element obj;
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(6);
        }
        if ((obj = MsPlanModelBuilder.queryElement((XPathExpression)this.ACCESS_OBJECT_QUERY, (Element)element)) == null) {
            this.unsupportedFormat();
        }
        return obj.getAttribute("Index");
    }

    protected void parsePlan(@NotNull Element state) {
        if (state == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(7);
        }
        this.openNode(null);
        this.parseSubPlans(state);
        String logOp = state.getAttribute("LogicalOp");
        String phyOp = state.getAttribute("PhysicalOp");
        PlanModel.NodeType type = LOGICAL_MAPPING.get(logOp);
        type = (PlanModel.NodeType)ObjectUtils.chooseNotNull((Object)PHYSICAL_MAPPING.get(Pair.create((Object)type, (Object)phyOp)), (Object)type);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        String text = phyOp.equals(logOp) ? phyOp : logOp + " - " + phyOp;
        PlanModel.GenericNode node = this.createNode(state, type, text);
        this.closeNode(node);
    }

    protected void parseSubPlans(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(8);
        }
        NodeList sub = MsPlanModelBuilder.queryElements((XPathExpression)this.SUB_OPS_QUERY, (Element)element);
        for (int i = 0; i < sub.getLength(); ++i) {
            this.parsePlan((Element)sub.item(i));
        }
    }

    protected void parseStatement(@NotNull Element element) {
        String stmtType;
        PlanModel.NodeType type;
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(9);
        }
        this.openNode(null);
        Element plan = this.querySingleElement(this.FIRST_OP_QUERY, element);
        if (plan != null) {
            this.parsePlan(plan);
        }
        if ((type = STATEMENT_MAPPING.get(stmtType = element.getAttribute("StatementType"))) == null) {
            type = PlanModel.NodeType.STATEMENT;
        }
        PlanModel.GenericNode node = this.createNode(element, type, type == PlanModel.NodeType.STATEMENT ? stmtType : null);
        node.setHints(MsPlanModelBuilder.parseMissingIndices(MsPlanModelBuilder.queryElements((XPathExpression)this.MISSING_INDICES_QUERY, (Element)element)));
        this.closeNode(node);
    }

    private static PlanModel.Hint[] parseMissingIndices(@NotNull NodeList element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(10);
        }
        if (element.getLength() == 0) {
            return PlanModel.GenericNode.NO_HINTS;
        }
        ArrayList<PlanModel.Hint> res = new ArrayList<PlanModel.Hint>(element.getLength());
        NamingService ns = NamingServices.getNamingService((Dbms)Dbms.MSSQL);
        for (int i = 0; i < element.getLength(); ++i) {
            Element group = (Element)element.item(i);
            double impact = Double.parseDouble(group.getAttribute("Impact"));
            NodeList indices = group.getElementsByTagName("MissingIndex");
            for (int j = 0; j < indices.getLength(); ++j) {
                Element index = (Element)indices.item(j);
                ObjectPath path = ObjectPath.create((String)ns.unquoteIdentifier(StringUtil.notNullize((String)index.getAttribute("Database"))), (ObjectKind)ObjectKind.DATABASE).append(ns.unquoteIdentifier(StringUtil.notNullize((String)index.getAttribute("Schema"))), ObjectKind.SCHEMA).append(ns.unquoteIdentifier(StringUtil.notNullize((String)index.getAttribute("Table"))), ObjectKind.TABLE);
                ArrayList<String> eq = new ArrayList<String>();
                ArrayList<String> inEq = new ArrayList<String>();
                ArrayList<String> incl = new ArrayList<String>();
                NodeList columnsGr = index.getElementsByTagName("ColumnGroup");
                for (int k = 0; k < columnsGr.getLength(); ++k) {
                    ArrayList<String> tgt;
                    Element columns = (Element)columnsGr.item(k);
                    String usage = columns.getAttribute("Usage");
                    ArrayList<String> arrayList = "EQUALITY".equals(usage) ? eq : ("INEQUALITY".equals(usage) ? inEq : (tgt = "INCLUDE".equals(usage) ? incl : null));
                    if (tgt == null) continue;
                    NodeList colNames = columns.getElementsByTagName("Column");
                    for (int m = 0; m < colNames.getLength(); ++m) {
                        Element col = (Element)colNames.item(m);
                        tgt.add(ns.unquoteIdentifier(StringUtil.notNullize((String)col.getAttribute("Name"))));
                    }
                }
                res.add(MsPlanModelBuilder.createIndexHint(path, eq, inEq, incl, impact));
            }
        }
        return res.toArray(PlanModel.GenericNode.NO_HINTS);
    }

    private static PlanModel.Hint createIndexHint(ObjectPath path, List<String> eq, List<String> inEq, List<String> incl, double impact) {
        HtmlBuilder text = new HtmlBuilder();
        text.append(DatabaseBundle.message((String)"MsMissingIndex.missing.index.on.0", (Object[])new Object[]{path.getDisplayName()})).appendRaw("\n\t").append(DatabaseBundle.message((String)"MsMissingIndex.impact.0", (Object[])new Object[]{impact})).appendRaw("\n");
        MsPlanModelBuilder.appendColumns(eq, text, DatabaseBundle.message((String)"MsMissingIndex.equality", (Object[])new Object[0]));
        MsPlanModelBuilder.appendColumns(inEq, text, DatabaseBundle.message((String)"MsMissingIndex.inequality", (Object[])new Object[0]));
        MsPlanModelBuilder.appendColumns(incl, text, DatabaseBundle.message((String)"MsMissingIndex.include", (Object[])new Object[0]));
        text.appendLink("$ACTION0", DatabaseBundle.message((String)"MsMissingIndex.create", (Object[])new Object[0]));
        return new PlanModel.Hint(text.toString(), new PlanModel.Action[]{MsPlanModelBuilder.createIndexAction(path, eq, inEq, incl)});
    }

    private static void appendColumns(List<String> eq, HtmlBuilder text, @Nls String usage) {
        if (!eq.isEmpty()) {
            text.append("\t").append(DatabaseBundle.message((String)"MsMissingIndex.0.columns.1", (Object[])new Object[]{usage, String.join((CharSequence)", ", eq)})).appendRaw("\n");
        }
    }

    private static PlanModel.Action createIndexAction(final ObjectPath path, final List<String> eq, final List<String> inEq, final List<String> incl) {
        return new PlanModel.Action(){

            public void perform(@NotNull DbDataSource dataSource) {
                MsTable basicTable;
                DbTable table;
                if (dataSource == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((table = (DbTable)ObjectUtils.tryCast((Object)DbSqlUtilCore.findElement((DbDataSource)dataSource, (ObjectPath)path), DbTable.class)) == null) {
                    ConnDatabaseNotifications.DATABASE_EXECUTION_GROUP().createNotification(DatabaseBundle.message((String)"MsMissingIndex.notification.content.unable.to.find.table", (Object[])new Object[]{path.getDisplayName()}), NotificationType.INFORMATION).setDisplayId("MsPlanModelBuilder.unable.to.find.table").notify(dataSource.getProject());
                }
                if ((basicTable = (MsTable)ObjectUtils.tryCast((Object)(table == null ? null : table.getDelegate()), MsTable.class)) == null) {
                    return;
                }
                ObjectKind spKind = DbImplUtilCore.getDatabaseDialect((DbElement)dataSource).getSearchPathObjectKind();
                ObjectPath sp = ObjectPaths.of((DasObject)basicTable).findParent(spKind, false);
                ModifyObjectAction.showDialog((Project)dataSource.getProject(), (RawDataSource)dataSource.getDelegateDataSource(), (BasicModel)basicTable.getModel(), (SearchPath)SearchPath.of((ObjectPath)sp), pull -> {
                    MsTable mTable = (MsTable)pull.pullObject((BasicElement)basicTable);
                    MsIndex index = (MsIndex)mTable.getIndices().createNewOne();
                    index.setColNames(ContainerUtil.concat((List)eq, (List)inEq));
                    index.setIncludedColNames(incl);
                    return index;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dialects/mssql/plan/MsPlanModelBuilder$2", "perform"));
            }
        };
    }

    @Nullable
    protected Double parseTotalCost(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(11);
        }
        try {
            if ("RelOp".equals(element.getTagName())) {
                return Double.valueOf(element.getAttribute("EstimatedTotalSubtreeCost"));
            }
            return Double.valueOf(element.getAttribute("StatementSubTreeCost"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected void parseActualInfo(@NotNull Element element, @NotNull PlanModel.GenericNode node) {
        NodeList runtime;
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(12);
        }
        if (node == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(13);
        }
        if ((runtime = MsPlanModelBuilder.queryElements((XPathExpression)this.RUNTIME_QUERY, (Element)element)).getLength() != 0) {
            this.myActual = true;
        }
        Double total = null;
        BigDecimal rows = null;
        for (int i = 0; i < runtime.getLength(); ++i) {
            String threadRows;
            BigDecimal threadRowsN;
            Double threadElapsedMs;
            Element thread = (Element)runtime.item(i);
            String threadElapsed = MsPlanModelBuilder.getAttr((Element)thread, (String)"ActualElapsedms");
            Double d = threadElapsedMs = threadElapsed == null ? null : Double.valueOf(Double.parseDouble(threadElapsed));
            if (threadElapsedMs != null && (total == null || total.compareTo(threadElapsedMs) < 0)) {
                total = threadElapsedMs;
            }
            BigDecimal bigDecimal = threadRowsN = (threadRows = MsPlanModelBuilder.getAttr((Element)thread, (String)"ActualRows")) == null ? null : new BigDecimal(threadRows);
            if (threadRowsN == null) continue;
            rows = rows == null ? threadRowsN : threadRowsN.add(rows);
        }
        node.setActualTotalTime(total);
        node.setActualStartupTime(null);
        node.setActualNumRows(rows);
    }

    @Nullable
    protected Double parseStartupCost(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(14);
        }
        return null;
    }

    protected boolean parseSubqueryCorrelated(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(15);
        }
        return false;
    }

    protected boolean parseSubqueryScalar(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(16);
        }
        return false;
    }

    static {
        LOGICAL_MAPPING.put("Aggregate", PlanModel.NodeType.AGGREGATE);
        LOGICAL_MAPPING.put("Assert", PlanModel.NodeType.OPERATION);
        LOGICAL_MAPPING.put("Async Concat", PlanModel.NodeType.UNION_ALL);
        LOGICAL_MAPPING.put("Batch Hash Table Build", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Bitmap Create", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Clustered Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Clustered Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Clustered Update", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Collapse", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Compute Scalar", PlanModel.NodeType.VALUE);
        LOGICAL_MAPPING.put("Concatenation", PlanModel.NodeType.UNION_ALL);
        LOGICAL_MAPPING.put("Constant Scan", PlanModel.NodeType.VALUE);
        LOGICAL_MAPPING.put("Cross Join", PlanModel.NodeType.NESTED_LOOPS);
        LOGICAL_MAPPING.put("Delete", PlanModel.NodeType.STATEMENT);
        LOGICAL_MAPPING.put("Deleted Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Distinct Sort", PlanModel.NodeType.SORT_UNIQUE);
        LOGICAL_MAPPING.put("Distinct", PlanModel.NodeType.UNIQUE);
        LOGICAL_MAPPING.put("Distribute Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Eager Spool", PlanModel.NodeType.TEMPORARY);
        LOGICAL_MAPPING.put("Filter", PlanModel.NodeType.FILTER);
        LOGICAL_MAPPING.put("Flow Distinct", PlanModel.NodeType.UNIQUE);
        LOGICAL_MAPPING.put("Full Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Gather Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Generic", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Inner Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        LOGICAL_MAPPING.put("Inserted Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Lazy Spool", PlanModel.NodeType.TEMPORARY);
        LOGICAL_MAPPING.put("Left Anti Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Left Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Left Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Log Row Scan", PlanModel.NodeType.OPERATION);
        LOGICAL_MAPPING.put("Merge Interval", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Parameter Table Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Partial Aggregate", PlanModel.NodeType.AGGREGATE);
        LOGICAL_MAPPING.put("Print", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Remote Delete", PlanModel.NodeType.DELETE);
        LOGICAL_MAPPING.put("Remote Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Remote Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Remote Insert", PlanModel.NodeType.INSERT);
        LOGICAL_MAPPING.put("Remote Query", PlanModel.NodeType.SELECT);
        LOGICAL_MAPPING.put("Remote Scan", PlanModel.NodeType.SEQ_SCAN);
        LOGICAL_MAPPING.put("Remote Update", PlanModel.NodeType.UPDATE);
        LOGICAL_MAPPING.put("Repartition Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("RID Lookup", PlanModel.NodeType.ROWID_ACCESS);
        LOGICAL_MAPPING.put("Right Anti Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Right Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Right Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Segment", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Sequence", PlanModel.NodeType.SEQUENTIALLY);
        LOGICAL_MAPPING.put("Sort", PlanModel.NodeType.SORT);
        LOGICAL_MAPPING.put("Split", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Switch", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Table-valued function", PlanModel.NodeType.TABLE_FUNCTION);
        LOGICAL_MAPPING.put("Table Scan", PlanModel.NodeType.SEQ_SCAN);
        LOGICAL_MAPPING.put("Top", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("TopN Sort", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("UDX", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Union", PlanModel.NodeType.UNION);
        LOGICAL_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        LOGICAL_MAPPING.put("Merge", PlanModel.NodeType.MERGE);
        LOGICAL_MAPPING.put("Merge Stats", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Local Stats", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Window Spool", PlanModel.NodeType.TEMPORARY);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.JOIN, (Object)"Nested Loops"), PlanModel.NodeType.NESTED_LOOPS);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.JOIN, (Object)"Merge Join"), PlanModel.NodeType.MERGE_JOIN);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.JOIN, (Object)"Hash Match"), PlanModel.NodeType.HASH_JOIN);
        STATEMENT_MAPPING.put("SELECT", PlanModel.NodeType.SELECT);
        STATEMENT_MAPPING.put("MERGE", PlanModel.NodeType.MERGE);
        STATEMENT_MAPPING.put("DELETE", PlanModel.NodeType.DELETE);
        STATEMENT_MAPPING.put("INSERT", PlanModel.NodeType.INSERT);
        STATEMENT_MAPPING.put("UPDATE", PlanModel.NodeType.UPDATE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/plan/MsPlanModelBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmls";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawData";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/plan/MsPlanModelBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseXmls";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseMissingIndices";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseActualInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }
}

