/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.actions.convert;

import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.visualization.IntervalsGenerator;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.util.keyFMap.KeyFMap;
import com.jetbrains.python.PythonLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J0\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\t0\u0011j\b\u0012\u0004\u0012\u00020\t`\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/py/actions/convert/PythonIntervalsGenerator;", "Lcom/intellij/notebooks/visualization/IntervalsGenerator;", "<init>", "()V", "intervalData", "Lcom/intellij/util/keyFMap/KeyFMap;", "Lorg/jetbrains/annotations/NotNull;", "makeIntervals", "", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "document", "Lcom/intellij/openapi/editor/Document;", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "addInterval", "", "arr", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "newLine", "", "hasFirstMarker", "", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nPythonIntervalsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonIntervalsGenerator.kt\ncom/intellij/jupyter/py/actions/convert/PythonIntervalsGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1807#2,3:61\n1#3:64\n*S KotlinDebug\n*F\n+ 1 PythonIntervalsGenerator.kt\ncom/intellij/jupyter/py/actions/convert/PythonIntervalsGenerator\n*L\n22#1:61,3\n*E\n"})
public final class PythonIntervalsGenerator
implements IntervalsGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyFMap intervalData;
    @NotNull
    private static final Set<String> FIRST_MARKERS;
    @NotNull
    private static final Set<String> NEW_LINE_MARKERS;
    @NotNull
    private static final String NEW_LINE_MARKER_PREFIX = "\n#";

    public PythonIntervalsGenerator() {
        KeyFMap keyFMap = KeyFMap.EMPTY_MAP.plus(NotebookCellLines.Companion.getINTERVAL_LANGUAGE_KEY(), (Object)PythonLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)keyFMap, (String)"plus(...)");
        this.intervalData = keyFMap;
    }

    @NotNull
    public List<NotebookCellLines.Interval> makeIntervals(@NotNull Document document, @Nullable DocumentEvent event) {
        boolean bl;
        CharSequence text;
        ArrayList<NotebookCellLines.Interval> intervals;
        block6: {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            intervals = new ArrayList<NotebookCellLines.Interval>();
            CharSequence charSequence = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            text = charSequence;
            Iterable $this$any$iv = FIRST_MARKERS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((CharSequence)text, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean hasFirstMarker = bl;
        int markerPos = 0;
        while ((markerPos = StringsKt.indexOf$default((CharSequence)text, (String)NEW_LINE_MARKER_PREFIX, (int)markerPos, (boolean)false, (int)4, null)) != -1) {
            Object v2;
            block7: {
                Iterable iterable = NEW_LINE_MARKERS;
                for (Object t : iterable) {
                    String marker = (String)t;
                    boolean bl3 = false;
                    int markerEnd = markerPos + marker.length();
                    if (!(markerEnd <= text.length() && Intrinsics.areEqual((Object)((Object)text.subSequence(markerPos, markerEnd)).toString(), (Object)marker))) continue;
                    v2 = t;
                    break block7;
                }
                v2 = null;
            }
            String marker = v2;
            if (marker == null) {
                markerPos += 2;
                continue;
            }
            int newMarkerLine = document.getLineNumber(markerPos += marker.length());
            this.addInterval(intervals, newMarkerLine, hasFirstMarker);
        }
        this.addInterval(intervals, Math.max(document.getLineCount(), 1), hasFirstMarker);
        return intervals;
    }

    private final void addInterval(ArrayList<NotebookCellLines.Interval> arr, int newLine, boolean hasFirstMarker) {
        int n;
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.lastOrNull((List)arr);
        if (interval != null) {
            NotebookCellLines.Interval it = interval;
            boolean bl = false;
            n = it.getLines().getLast() + 1;
        } else {
            n = 0;
        }
        int startLine = n;
        boolean isRaw = arr.isEmpty() && !hasFirstMarker;
        NotebookCellLines.MarkersAtLines markerAtLines = isRaw ? NotebookCellLines.MarkersAtLines.NO : NotebookCellLines.MarkersAtLines.TOP;
        arr.add(new NotebookCellLines.Interval(arr.size(), CellType.CODE, RangesKt.until((int)startLine, (int)newLine), markerAtLines, this.intervalData));
    }

    static {
        Object[] objectArray = new String[]{"#%%", "# %%"};
        FIRST_MARKERS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"\n#%%", "\n# %%"};
        NEW_LINE_MARKERS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/py/actions/convert/PythonIntervalsGenerator$Companion;", "", "<init>", "()V", "FIRST_MARKERS", "", "", "getFIRST_MARKERS$intellij_jupyter_py", "()Ljava/util/Set;", "NEW_LINE_MARKERS", "NEW_LINE_MARKER_PREFIX", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getFIRST_MARKERS$intellij_jupyter_py() {
            return FIRST_MARKERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

